/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma;

import java.io.IOException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import org.videolan.vlma.exception.AlreadyExistsException;
import org.videolan.vlma.exception.NotFoundException;
import org.videolan.vlma.model.Command;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.model.Satellite;
import org.videolan.vlma.model.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Data
extends Remote {
    public void reload() throws RemoteException;

    public void stop() throws RemoteException;

    public String getString(String var1) throws RemoteException;

    public Integer getInt(String var1) throws RemoteException;

    public List getList(String var1) throws RemoteException;

    public void setProperty(String var1, Object var2) throws RemoteException;

    public void clearProperty(String var1) throws RemoteException;

    public List<Satellite> getSatellites() throws RemoteException;

    public Satellite getSatellite(int var1) throws NotFoundException, RemoteException;

    public void add(Satellite var1) throws AlreadyExistsException, RemoteException;

    public void update(Satellite var1) throws NotFoundException, RemoteException;

    public void remove(Satellite var1) throws NotFoundException, RemoteException;

    public List<Server> getServers() throws RemoteException;

    public Server getServer(int var1) throws NotFoundException, RemoteException;

    public void add(Server var1) throws AlreadyExistsException, RemoteException;

    public void update(Server var1) throws NotFoundException, RemoteException;

    public void remove(Server var1) throws NotFoundException, RemoteException;

    public List<Media> getMedias() throws RemoteException;

    public Media getMedia(int var1) throws RemoteException;

    public void add(Media var1) throws RemoteException;

    public void update(Media var1) throws NotFoundException, RemoteException;

    public void remove(Media var1) throws NotFoundException, RemoteException;

    public Program newProgram() throws RemoteException;

    public String getUrlOfProgram(Program var1) throws RemoteException;

    public void updateSatChannels(URL var1) throws IOException, RemoteException;

    public void giveOrders() throws RemoteException;

    public List<Command> getCommands() throws RemoteException;

    public void startOrderMonitoring() throws RemoteException;

    public void startCheckAllVLCs() throws RemoteException;
}

