/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.web.servers;

import java.util.Map;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.VlServer;
import org.videolan.vlma.web.servers.ServersAdapterAdd;

public class ServersAdapterAddValidator
implements Validator {
    public boolean supports(Class arg0) {
        return arg0.equals(ServersAdapterAdd.class);
    }

    public void validate(Object arg0, Errors arg1) {
        ServersAdapterAdd serversAdapterAdd = (ServersAdapterAdd)arg0;
        IVlData data = serversAdapterAdd.getData();
        if (serversAdapterAdd == null) {
            arg1.rejectValue("name", "servers.adapter.add.error.not-specified");
            return;
        }
        String adapterName = serversAdapterAdd.getName().trim();
        try {
            Integer.parseInt(adapterName);
        }
        catch (NumberFormatException e) {
            arg1.rejectValue("name", "servers.adapter.add.error.invalidname");
        }
        VlServer s = data.getServer(serversAdapterAdd.getServer());
        Map m = s.getAdapters();
        if (m.containsKey(adapterName)) {
            arg1.rejectValue("name", "servers.adapter.add.error.existingname");
        }
        String type = serversAdapterAdd.getType();
        try {
            Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            arg1.rejectValue("type", "servers.adapter.add.error.invalidtype");
        }
    }
}

