/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import vlcskineditor.FrameUpdater;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Layout;
import vlcskineditor.Main;
import vlcskineditor.Window;
import vlcskineditor.history.ItemMoveEvent;
import vlcskineditor.history.SliderEditEvent;
import vlcskineditor.items.Slider;

public class PreviewWindow
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final long serialVersionUID = 85L;
    public JInternalFrame frame;
    private JScrollPane scroll_pane;
    private JPanel zoom_panel;
    private JButton zoom_more;
    private JButton zoom_less;
    private JLabel zoom_label;
    private int z = 1;
    private Layout l;
    protected FrameUpdater fu;
    private Item selectedItem;
    private boolean startedDragging = false;
    private int dragStartX;
    private int dragStartY;
    private int dragStartItemX;
    private int dragStartItemY;
    private int draggedSliderPoint;
    private ItemMoveEvent ime = null;
    private SliderEditEvent see = null;
    private Main m;
    private Cursor move_normal_c;
    private Cursor path_normal_c;
    private Cursor path_active_c;
    private Cursor path_add_c;
    private Cursor path_del_c;
    public static final int CURSOR_MOVE = 1;
    public static final int CURSOR_PATH = 2;
    private int mode = 1;

    public PreviewWindow(Main main) {
        this.m = main;
        this.frame = new JInternalFrame();
        this.frame.setLayout(new BorderLayout());
        this.zoom_panel = new JPanel();
        this.zoom_panel.setLayout(new FlowLayout());
        this.zoom_less = new JButton("-");
        this.zoom_less.addActionListener(this);
        this.zoom_panel.add(this.zoom_less);
        this.zoom_label = new JLabel(Language.get("ZOOM_FACTOR") + " 1x");
        this.zoom_panel.add(this.zoom_label);
        this.zoom_more = new JButton("+");
        this.zoom_more.addActionListener(this);
        this.zoom_panel.add(this.zoom_more);
        this.zoom_panel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.frame.add((Component)this.zoom_panel, "First");
        this.scroll_pane = new JScrollPane(this);
        this.frame.add((Component)this.scroll_pane, "Center");
        this.frame.pack();
        this.frame.setMinimumSize(this.zoom_panel.getPreferredSize());
        this.frame.setVisible(false);
        this.frame.setResizable(true);
        this.frame.setFrameIcon(Main.preview_icon);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.move_normal_c = new Cursor(13);
        this.path_normal_c = Helper.createImageCursor("icons/path_cursor.gif", 4, 0, this);
        this.path_active_c = Helper.createImageCursor("icons/path_cursor_active.gif", 4, 0, this);
        this.path_add_c = Helper.createImageCursor("icons/path_cursor_add.gif", 4, 0, this);
        this.path_del_c = Helper.createImageCursor("icons/path_cursor_del.gif", 4, 0, this);
    }

    public void clearLayout() {
        this.l = null;
        if (this.selectedItem != null) {
            this.selectedItem.setSelected(false);
        }
        this.selectedItem = null;
        this.frame.setVisible(false);
        if (this.fu != null) {
            this.fu.stopRunning();
        }
        this.fu = null;
    }

    public void setLayout(Window window, Layout layout) {
        if (layout == null) {
            this.clearLayout();
            return;
        }
        this.l = layout;
        this.setPreferredSize(new Dimension(this.l.width * this.z, this.l.height * this.z));
        int n = this.l.width * this.z + this.scroll_pane.getBorder().getBorderInsets((Component)this.scroll_pane).left + this.scroll_pane.getBorder().getBorderInsets((Component)this.scroll_pane).right;
        int n2 = this.l.height * this.z;
        this.scroll_pane.setPreferredSize(new Dimension(n, n2));
        this.frame.setTitle("Window: " + window.id + " - Layout: " + this.l.id);
        this.frame.pack();
        this.frame.setVisible(true);
        if (this.fu == null) {
            this.fu = new FrameUpdater(this, 5);
            this.fu.start();
        }
    }

    public void selectItem(Item item) {
        if (this.selectedItem != null) {
            this.selectedItem.setSelected(false);
        }
        if (item == null) {
            return;
        }
        this.selectedItem = item;
        this.selectedItem.setSelected(true);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.l == null) {
            return;
        }
        BufferedImage bufferedImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(Color.LIGHT_GRAY);
        for (int i = 0; i < this.getWidth(); i += 20) {
            for (int j = 0; j < this.getHeight(); j += 20) {
                graphics2D.fillRect(i, j, 10, 10);
                graphics2D.fillRect(i + 10, j + 10, 10, 10);
            }
        }
        try {
            this.l.draw(graphics2D, this.z);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics.drawImage(bufferedImage, 0, 0, this);
    }

    @Override
    public void update(Graphics graphics) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.zoom_less)) {
            if (this.z > 1) {
                --this.z;
            }
            this.zoom_label.setText(Language.get("ZOOM_FACTOR") + " " + this.z + "x");
            this.setSize(this.l.width * this.z, this.l.height * this.z);
            this.setPreferredSize(new Dimension(this.l.width * this.z, this.l.height * this.z));
        } else if (actionEvent.getSource().equals(this.zoom_more)) {
            if (this.z < 16) {
                ++this.z;
            }
            this.zoom_label.setText(Language.get("ZOOM_FACTOR") + " " + this.z + "x");
            this.setSize(this.l.width * this.z, this.l.height * this.z);
            this.setPreferredSize(new Dimension(this.l.width * this.z, this.l.height * this.z));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mode == 2 && this.selectedItem.getClass().equals(Slider.class)) {
            int n;
            Slider slider = (Slider)this.selectedItem;
            int n2 = mouseEvent.getX() / this.z - slider.offsetx - slider.x;
            int n3 = this.getSliderPointAt(slider, n2, n = mouseEvent.getY() / this.z - slider.offsety - slider.y);
            if (n3 != -1) {
                if (mouseEvent.isAltDown()) {
                    slider.removeControlPoint(n3);
                } else {
                    this.setCursor(this.path_active_c);
                }
            } else if (mouseEvent.isShiftDown()) {
                slider.addControlPoint(n2, n);
            } else {
                this.setCursor(this.path_normal_c);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedItem == null) {
            return;
        }
        if (this.mode == 1) {
            if (!this.startedDragging && this.selectedItem.contains(mouseEvent.getX() / this.z, mouseEvent.getY() / this.z)) {
                this.dragStartX = mouseEvent.getX() / this.z;
                this.dragStartY = mouseEvent.getY() / this.z;
                this.ime = new ItemMoveEvent(this.selectedItem);
                this.dragStartItemX = this.selectedItem.x;
                this.dragStartItemY = this.selectedItem.y;
                this.startedDragging = true;
            } else if (this.startedDragging) {
                this.selectedItem.x = this.dragStartItemX + mouseEvent.getX() / this.z - this.dragStartX;
                this.selectedItem.y = this.dragStartItemY + mouseEvent.getY() / this.z - this.dragStartY;
            }
        } else if (this.selectedItem.getClass().equals(Slider.class)) {
            Slider slider = (Slider)this.selectedItem;
            int n = mouseEvent.getX() / this.z - slider.offsetx - slider.x;
            int n2 = mouseEvent.getY() / this.z - slider.offsety - slider.y;
            if (!this.startedDragging) {
                int n3 = this.getSliderPointAt(slider, n, n2);
                if (n3 != -1) {
                    this.draggedSliderPoint = n3;
                    this.dragStartX = n;
                    this.dragStartY = n2;
                    this.dragStartItemX = slider.getControlX(n3);
                    this.dragStartItemY = slider.getControlY(n3);
                    this.see = new SliderEditEvent(slider);
                    this.startedDragging = true;
                }
            } else if (this.startedDragging) {
                int n4 = this.dragStartItemX + (n - this.dragStartX);
                int n5 = this.dragStartItemY + (n2 - this.dragStartY);
                slider.moveControlPointTo(this.draggedSliderPoint, n4, n5);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mode == 2) {
            this.setCursor(this.path_normal_c);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mode == 2) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.selectedItem == null) {
            return;
        }
        if (this.mode == 1) {
            if (this.selectedItem.contains(mouseEvent.getX() / this.z, mouseEvent.getY() / this.z)) {
                this.selectedItem.setHover(true);
                this.setCursor(this.move_normal_c);
            } else {
                this.selectedItem.setHover(false);
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (this.selectedItem.getClass().equals(Slider.class)) {
            int n;
            Slider slider = (Slider)this.selectedItem;
            int n2 = mouseEvent.getX() / this.z - slider.offsetx - slider.x;
            int n3 = this.getSliderPointAt(slider, n2, n = mouseEvent.getY() / this.z - slider.offsety - slider.y);
            if (n3 != -1) {
                if (mouseEvent.isAltDown()) {
                    this.setCursor(this.path_del_c);
                } else {
                    this.setCursor(this.path_active_c);
                }
            } else if (mouseEvent.isShiftDown()) {
                this.setCursor(this.path_add_c);
            } else {
                this.setCursor(this.path_normal_c);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fu.fps = 25;
        if (this.mode == 1 && this.selectedItem != null) {
            this.selectedItem.setClicked(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.fu.fps = 5;
        if (this.mode == 1) {
            if (this.startedDragging) {
                this.ime.setNew();
                this.m.hist.addEvent(this.ime);
                this.ime = null;
            }
            this.startedDragging = false;
            if (this.selectedItem == null) {
                return;
            }
            this.selectedItem.setClicked(false);
            this.dragStartX = this.selectedItem.x + this.selectedItem.offsetx;
            this.dragStartY = this.selectedItem.y + this.selectedItem.offsety;
            this.dragStartItemX = this.selectedItem.x;
            this.dragStartItemY = this.selectedItem.y;
        } else if (this.startedDragging) {
            this.see.setNew();
            this.m.hist.addEvent(this.see);
            this.see = null;
            this.startedDragging = false;
        }
    }

    public void moveItem(int n, int n2) {
        try {
            if (this.ime == null) {
                this.ime = new ItemMoveEvent(this.selectedItem);
                this.m.hist.addEvent(this.ime);
            }
            this.selectedItem.x += n;
            this.selectedItem.y += n2;
            if (this.ime.getNext() == null) {
                this.ime.setNew();
            } else {
                this.ime = null;
            }
            this.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void savePNG(File file) {
        BufferedImage bufferedImage = new BufferedImage(this.l.width, this.l.height, 2);
        if (this.selectedItem != null) {
            this.selectedItem.setSelected(false);
        }
        this.l.draw(bufferedImage.createGraphics(), 1);
        if (this.selectedItem != null) {
            this.selectedItem.setSelected(true);
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m, Language.get("ERROR_SAVEPNG_MSG") + "\n" + exception.toString(), Language.get("ERROR_SAVEPNG_TITLE"), 0);
            return;
        }
    }

    public void setCursorMode(int n) {
        this.mode = n;
    }

    public int getCursorMode() {
        return this.mode;
    }

    private int getSliderPointAt(Slider slider, int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < slider.getControlPointNum(); ++i) {
            int n4 = Math.abs(n - slider.getControlX(i));
            int n5 = Math.abs(n2 - slider.getControlY(i));
            if (n4 >= 2 || n5 >= 2) continue;
            n3 = i;
        }
        return n3;
    }
}

