/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public class Language {
    private static Hashtable<String, String> strings = new Hashtable();
    private static LinkedList<Language> langs = new LinkedList();
    private String name;
    private String code;
    private File file;

    private Language(String string, String string2, String string3) {
        this.name = string2;
        this.code = string;
        this.file = new File("lang", string3);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.name + " (" + this.code + ")";
    }

    private static void load(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if ((string = new String(string.getBytes(), "UTF-8")).startsWith("@include")) {
                    stringArray = string.substring(9);
                    Language.load(new File(file.getParent() + File.separator + (String)stringArray));
                    continue;
                }
                if (string.startsWith("#") || (stringArray = string.split("\\|")).length != 2) continue;
                strings.put(stringArray[0], stringArray[1].replaceAll("\\\\n", "\n"));
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void loadLanguage(Language language) {
        Language.load(language.getFile());
    }

    public static void loadLanguageByCode(String string) {
        for (Language language : Language.getAvailableLanguages()) {
            if (!language.getCode().equals(string)) continue;
            Language.loadLanguage(language);
        }
    }

    public static List<Language> getAvailableLanguages() {
        return langs;
    }

    public static boolean isLanguageAvailable(String string) {
        for (Language language : Language.getAvailableLanguages()) {
            if (!language.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String get(String string) {
        String string2 = strings.get(string);
        return string2 != null ? string2 : string;
    }

    static {
        try {
            File file = new File("lang/languages.txt");
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if ((string = new String(string.getBytes(), "UTF-8")).startsWith("#") || (stringArray = string.split("\\|")).length != 3) continue;
                langs.add(new Language(stringArray[0], stringArray[1], stringArray[2]));
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

