/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.Theme;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class WorkbenchThemeManager
implements IThemeManager {
    private IThemeRegistry themeRegistry;
    private static WorkbenchThemeManager instance;
    private ColorRegistry defaultThemeColorRegistry;
    private FontRegistry defaultThemeFontRegistry;
    private IPropertyChangeListener currentThemeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            WorkbenchThemeManager.this.firePropertyChange(event);
            if (event.getSource() instanceof FontRegistry) {
                JFaceResources.getFontRegistry().put(event.getProperty(), (FontData[])event.getNewValue());
            } else if (event.getSource() instanceof ColorRegistry) {
                JFaceResources.getColorRegistry().put(event.getProperty(), (RGB)event.getNewValue());
            }
        }
    };
    private Map themes = new HashMap(7);
    private ITheme currentTheme;
    private ListenerList propertyChangeListeners = new ListenerList();

    private WorkbenchThemeManager() {
        this.defaultThemeColorRegistry = new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        this.defaultThemeFontRegistry = new FontRegistry(PlatformUI.getWorkbench().getDisplay());
        FontRegistry jfaceFonts = JFaceResources.getFontRegistry();
        Iterator i = jfaceFonts.getKeySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.defaultThemeFontRegistry.put(key, jfaceFonts.getFontData(key));
        }
    }

    public static WorkbenchThemeManager getInstance() {
        if (instance == null) {
            instance = new WorkbenchThemeManager();
            instance.getCurrentTheme();
        }
        return instance;
    }

    public void dispose() {
        Iterator i = this.themes.values().iterator();
        while (i.hasNext()) {
            ITheme theme = (ITheme)i.next();
            theme.removePropertyChangeListener(this.currentThemeListener);
            theme.dispose();
        }
        this.themes.clear();
    }

    private IThemeRegistry getThemeRegistry() {
        if (this.themeRegistry == null) {
            this.themeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
        }
        return this.themeRegistry;
    }

    public ITheme getTheme(String id) {
        if (id.equals("org.eclipse.ui.defaultTheme")) {
            return this.getTheme((IThemeDescriptor)null);
        }
        IThemeDescriptor td = this.getThemeRegistry().findTheme(id);
        if (td == null) {
            return null;
        }
        return this.getTheme(td);
    }

    private ITheme getTheme(IThemeDescriptor td) {
        ITheme theme = (ITheme)this.themes.get(td);
        if (theme == null) {
            theme = new Theme(td);
            this.themes.put(td, theme);
        }
        return theme;
    }

    public ITheme getCurrentTheme() {
        if (this.currentTheme == null) {
            String themeId = PlatformUI.getWorkbench().getPreferenceStore().getString("CURRENT_THEME_ID");
            if (themeId.equals("")) {
                themeId = "org.eclipse.ui.defaultTheme";
            }
            this.setCurrentTheme(themeId);
        }
        return this.currentTheme;
    }

    public void setCurrentTheme(String id) {
        ITheme oldTheme = this.currentTheme;
        if (WorkbenchThemeManager.getInstance().doSetCurrentTheme(id)) {
            String key;
            this.firePropertyChange("CHANGE_CURRENT_THEME", oldTheme, this.getCurrentTheme());
            if (oldTheme != null) {
                oldTheme.removePropertyChangeListener(this.currentThemeListener);
            }
            this.currentTheme.addPropertyChangeListener(this.currentThemeListener);
            if (!WorkbenchPlugin.getDefault().getPreferenceStore().getString("CURRENT_THEME_ID").equals(id)) {
                WorkbenchPlugin.getDefault().getPreferenceStore().setValue("CURRENT_THEME_ID", id);
                WorkbenchPlugin.getDefault().savePluginPreferences();
            }
            ColorRegistry jfaceColors = JFaceResources.getColorRegistry();
            ColorRegistry themeColors = this.currentTheme.getColorRegistry();
            Iterator i = themeColors.getKeySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                jfaceColors.put(key, themeColors.getRGB(key));
            }
            FontRegistry jfaceFonts = JFaceResources.getFontRegistry();
            FontRegistry themeFonts = this.currentTheme.getFontRegistry();
            i = themeFonts.getKeySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                jfaceFonts.put(key, themeFonts.getFontData(key));
            }
        }
    }

    private boolean doSetCurrentTheme(String id) {
        ITheme oldTheme = this.currentTheme;
        ITheme newTheme = this.getTheme(id);
        if (oldTheme != newTheme && newTheme != null) {
            this.currentTheme = newTheme;
            return true;
        }
        return false;
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.propertyChangeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
        }
    }

    protected void firePropertyChange(String changeId, ITheme oldTheme, ITheme newTheme) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, changeId, (Object)oldTheme, (Object)newTheme);
        this.firePropertyChange(event);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    public ColorRegistry getDefaultThemeColorRegistry() {
        return this.defaultThemeColorRegistry;
    }

    public FontRegistry getDefaultThemeFontRegistry() {
        return this.defaultThemeFontRegistry;
    }
}

