/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationScheduler;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.DecoratorRegistryReader;
import org.eclipse.ui.internal.decorators.FullDecoratorDefinition;
import org.eclipse.ui.internal.decorators.FullImageDecoratorRunnable;
import org.eclipse.ui.internal.decorators.FullTextDecoratorRunnable;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.decorators.LightweightDecoratorManager;
import org.eclipse.ui.progress.WorkbenchJob;

public class DecoratorManager
implements IDelayedLabelDecorator,
ILabelProviderListener,
IDecoratorManager {
    public static final Object FAMILY_DECORATE = new Object();
    private DecorationScheduler scheduler;
    private LightweightDecoratorManager lightweightManager;
    private ListenerList listeners = new ListenerList();
    private HashMap cachedFullDecorators = new HashMap();
    private FullDecoratorDefinition[] fullDefinitions;
    private FullTextDecoratorRunnable fullTextRunnable = new FullTextDecoratorRunnable();
    private FullImageDecoratorRunnable fullImageRunnable = new FullImageDecoratorRunnable();
    private static final FullDecoratorDefinition[] EMPTY_FULL_DEF = new FullDecoratorDefinition[0];
    private final String PREFERENCE_SEPARATOR = ",";
    private final String VALUE_SEPARATOR = ":";
    private final String P_TRUE = "true";
    private final String P_FALSE = "false";
    static /* synthetic */ Class class$org$eclipse$core$runtime$IAdaptable;

    public DecoratorManager() {
        DecoratorRegistryReader reader = new DecoratorRegistryReader();
        Collection values = reader.readRegistry(Platform.getExtensionRegistry());
        ArrayList<DecoratorDefinition> full = new ArrayList<DecoratorDefinition>();
        ArrayList<DecoratorDefinition> lightweight = new ArrayList<DecoratorDefinition>();
        Iterator allDefinitions = values.iterator();
        while (allDefinitions.hasNext()) {
            DecoratorDefinition nextDefinition = (DecoratorDefinition)allDefinitions.next();
            if (nextDefinition.isFull()) {
                full.add(nextDefinition);
                continue;
            }
            lightweight.add(nextDefinition);
        }
        this.fullDefinitions = new FullDecoratorDefinition[full.size()];
        full.toArray(this.fullDefinitions);
        LightweightDecoratorDefinition[] lightweightDefinitions = new LightweightDecoratorDefinition[lightweight.size()];
        lightweight.toArray(lightweightDefinitions);
        this.lightweightManager = new LightweightDecoratorManager(lightweightDefinitions);
        this.scheduler = new DecorationScheduler(this);
    }

    public void addDecorator(DecoratorDefinition definition) {
        if (definition.isFull()) {
            if (this.getFullDecoratorDefinition(definition.getId()) == null) {
                FullDecoratorDefinition[] oldDefs = this.fullDefinitions;
                this.fullDefinitions = new FullDecoratorDefinition[this.fullDefinitions.length + 1];
                System.arraycopy(oldDefs, 0, this.fullDefinitions, 0, oldDefs.length);
                this.fullDefinitions[oldDefs.length] = (FullDecoratorDefinition)definition;
                this.clearCaches();
                this.updateForEnablementChange();
            }
        } else if (this.getLightweightManager().addDecorator((LightweightDecoratorDefinition)definition)) {
            this.clearCaches();
            this.updateForEnablementChange();
        }
    }

    static Collection getDecoratorsFor(Object element, DecoratorDefinition[] enabledDefinitions) {
        ArrayList<DecoratorDefinition> decorators = new ArrayList<DecoratorDefinition>();
        for (int i = 0; i < enabledDefinitions.length; ++i) {
            if (!enabledDefinitions[i].getEnablement().isEnabledForExpression(element, "objectClass")) continue;
            decorators.add(enabledDefinitions[i]);
        }
        return decorators;
    }

    public void restoreListeners() {
        this.applyDecoratorsPreference();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    void fireListeners(final LabelProviderChangedEvent event) {
        Object[] array = this.listeners.getListeners();
        for (int i = 0; i < array.length; ++i) {
            final ILabelProviderListener l = (ILabelProviderListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
        }
    }

    void fireListenersInUIThread(final LabelProviderChangedEvent event) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
            this.fireListeners(event);
            return;
        }
        WorkbenchJob updateJob = new WorkbenchJob(WorkbenchMessages.getString("DecorationScheduler.UpdateJobName")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DecoratorManager.this.fireListeners(event);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public String decorateText(String text, Object element) {
        String newResult;
        int i;
        Object adapted = this.getResourceAdapter(element);
        String result = this.scheduler.decorateWithText(text, element, adapted);
        FullDecoratorDefinition[] decorators = this.getDecoratorsFor(element);
        for (i = 0; i < decorators.length; ++i) {
            if (!decorators[i].getEnablement().isEnabledFor(element) || (newResult = this.safeDecorateText(element, result, decorators[i])) == null) continue;
            result = newResult;
        }
        if (adapted != null) {
            decorators = this.getDecoratorsFor(adapted);
            for (i = 0; i < decorators.length; ++i) {
                if (!decorators[i].isAdaptable() || !decorators[i].getEnablement().isEnabledFor(adapted) || (newResult = this.safeDecorateText(adapted, result, decorators[i])) == null) continue;
                result = newResult;
            }
        }
        return result;
    }

    private String safeDecorateText(Object element, String start, FullDecoratorDefinition decorator) {
        this.fullTextRunnable.setValues(start, element, decorator);
        Platform.run((ISafeRunnable)this.fullTextRunnable);
        String newResult = this.fullTextRunnable.getResult();
        return newResult;
    }

    public Image decorateImage(Image image, Object element) {
        Image newResult;
        int i;
        Object adapted = this.getResourceAdapter(element);
        Image result = this.scheduler.decorateWithOverlays(image, element, adapted);
        FullDecoratorDefinition[] decorators = this.getDecoratorsFor(element);
        for (i = 0; i < decorators.length; ++i) {
            if (!decorators[i].getEnablement().isEnabledFor(element) || (newResult = this.safeDecorateImage(element, result, decorators[i])) == null) continue;
            result = newResult;
        }
        if (adapted != null) {
            decorators = this.getDecoratorsFor(adapted);
            for (i = 0; i < decorators.length; ++i) {
                if (!decorators[i].isAdaptable() || !decorators[i].getEnablement().isEnabledFor(adapted) || (newResult = this.safeDecorateImage(adapted, result, decorators[i])) == null) continue;
                result = newResult;
            }
        }
        return result;
    }

    private Image safeDecorateImage(Object element, Image start, FullDecoratorDefinition decorator) {
        this.fullImageRunnable.setValues(start, element, decorator);
        Platform.run((ISafeRunnable)this.fullImageRunnable);
        Image newResult = this.fullImageRunnable.getResult();
        return newResult;
    }

    private Object getResourceAdapter(Object element) {
        if (element instanceof IAdaptable) {
            Object adapted;
            Method m;
            IAdaptable adaptable = (IAdaptable)element;
            Class contributorResourceAdapterClass = LegacyResourceSupport.getIContributorResourceAdapterClass();
            if (contributorResourceAdapterClass == null) {
                return null;
            }
            Object resourceAdapter = adaptable.getAdapter(contributorResourceAdapterClass);
            if (resourceAdapter == null) {
                try {
                    Class c = LegacyResourceSupport.getDefaultContributorResourceAdapterClass();
                    m = c.getDeclaredMethod("getDefault", new Class[0]);
                    resourceAdapter = m.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
            try {
                m = contributorResourceAdapterClass.getDeclaredMethod("getAdaptedResource", class$org$eclipse$core$runtime$IAdaptable == null ? (class$org$eclipse$core$runtime$IAdaptable = DecoratorManager.class$("org.eclipse.core.runtime.IAdaptable")) : class$org$eclipse$core$runtime$IAdaptable);
                adapted = m.invoke(resourceAdapter, adaptable);
            }
            catch (Exception e) {
                return null;
            }
            if (adapted != element) {
                return adapted;
            }
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.isLabelProperty(element, property, true);
    }

    public boolean isLabelProperty(Object element, String property, boolean checkAdapted) {
        boolean fullCheck = this.isLabelProperty(element, property, this.getDecoratorsFor(element));
        if (fullCheck) {
            return fullCheck;
        }
        boolean lightweightCheck = this.isLabelProperty(element, property, this.lightweightManager.getDecoratorsFor(element));
        if (lightweightCheck) {
            return true;
        }
        if (checkAdapted) {
            Object adapted = this.getResourceAdapter(element);
            if (adapted == null || adapted == element) {
                return false;
            }
            fullCheck = this.isLabelProperty(adapted, property, this.getDecoratorsFor(adapted));
            if (fullCheck) {
                return fullCheck;
            }
            return this.isLabelProperty(adapted, property, this.lightweightManager.getDecoratorsFor(adapted));
        }
        return false;
    }

    private boolean isLabelProperty(Object element, String property, DecoratorDefinition[] decorators) {
        for (int i = 0; i < decorators.length; ++i) {
            if (!decorators[i].getEnablement().isEnabledFor(element) || !decorators[i].isLabelProperty(element, property)) continue;
            return true;
        }
        return false;
    }

    private FullDecoratorDefinition[] enabledFullDefinitions() {
        ArrayList<FullDecoratorDefinition> result = new ArrayList<FullDecoratorDefinition>();
        for (int i = 0; i < this.fullDefinitions.length; ++i) {
            if (!this.fullDefinitions[i].isEnabled()) continue;
            result.add(this.fullDefinitions[i]);
        }
        FullDecoratorDefinition[] returnArray = new FullDecoratorDefinition[result.size()];
        result.toArray(returnArray);
        return returnArray;
    }

    public void dispose() {
    }

    public void clearCaches() {
        this.cachedFullDecorators.clear();
        this.lightweightManager.reset();
    }

    public void updateForEnablementChange() {
        this.scheduler.clearResults();
        this.fireListenersInUIThread(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        this.writeDecoratorsPreference();
    }

    public DecoratorDefinition[] getAllDecoratorDefinitions() {
        LightweightDecoratorDefinition[] lightweightDefinitions = this.lightweightManager.getDefinitions();
        DecoratorDefinition[] returnValue = new DecoratorDefinition[this.fullDefinitions.length + lightweightDefinitions.length];
        System.arraycopy(this.fullDefinitions, 0, returnValue, 0, this.fullDefinitions.length);
        System.arraycopy(lightweightDefinitions, 0, returnValue, this.fullDefinitions.length, lightweightDefinitions.length);
        return returnValue;
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        Object[] elements = event.getElements();
        this.scheduler.clearResults();
        if (elements == null) {
            this.fireListeners(event);
        } else {
            for (int i = 0; i < elements.length; ++i) {
                Object adapted = this.getResourceAdapter(elements[i]);
                this.scheduler.queueForDecoration(elements[i], adapted, true, null);
            }
        }
    }

    private void writeDecoratorsPreference() {
        StringBuffer enabledIds = new StringBuffer();
        this.writeDecoratorsPreference(enabledIds, this.fullDefinitions);
        this.writeDecoratorsPreference(enabledIds, this.lightweightManager.getDefinitions());
        WorkbenchPlugin.getDefault().getPreferenceStore().setValue("ENABLED_DECORATORS", enabledIds.toString());
    }

    private void writeDecoratorsPreference(StringBuffer enabledIds, DecoratorDefinition[] definitions) {
        for (int i = 0; i < definitions.length; ++i) {
            enabledIds.append(definitions[i].getId());
            enabledIds.append(":");
            if (definitions[i].isEnabled()) {
                enabledIds.append("true");
            } else {
                enabledIds.append("false");
            }
            enabledIds.append(",");
        }
    }

    private void applyDecoratorsPreference() {
        String id;
        String preferenceValue = WorkbenchPlugin.getDefault().getPreferenceStore().getString("ENABLED_DECORATORS");
        StringTokenizer tokenizer = new StringTokenizer(preferenceValue, ",");
        HashSet<String> enabledIds = new HashSet<String>();
        HashSet<String> disabledIds = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String nextValuePair = tokenizer.nextToken();
            id = nextValuePair.substring(0, nextValuePair.indexOf(":"));
            if (nextValuePair.endsWith("true")) {
                enabledIds.add(id);
                continue;
            }
            disabledIds.add(id);
        }
        for (int i = 0; i < this.fullDefinitions.length; ++i) {
            id = this.fullDefinitions[i].getId();
            if (enabledIds.contains(id)) {
                this.fullDefinitions[i].setEnabled(true);
                continue;
            }
            if (!disabledIds.contains(id)) continue;
            this.fullDefinitions[i].setEnabled(false);
        }
        LightweightDecoratorDefinition[] lightweightDefinitions = this.lightweightManager.getDefinitions();
        for (int i = 0; i < lightweightDefinitions.length; ++i) {
            String id2 = lightweightDefinitions[i].getId();
            if (enabledIds.contains(id2)) {
                lightweightDefinitions[i].setEnabled(true);
                continue;
            }
            if (!disabledIds.contains(id2)) continue;
            lightweightDefinitions[i].setEnabled(false);
        }
    }

    public void shutdown() {
        for (int i = 0; i < this.fullDefinitions.length; ++i) {
            if (!this.fullDefinitions[i].isEnabled()) continue;
            this.fullDefinitions[i].setEnabled(false);
        }
        this.lightweightManager.shutdown();
        this.scheduler.shutdown();
    }

    public boolean getEnabled(String decoratorId) {
        DecoratorDefinition definition = this.getDecoratorDefinition(decoratorId);
        if (definition == null) {
            return false;
        }
        return definition.isEnabled();
    }

    public ILabelDecorator getLabelDecorator() {
        return this;
    }

    public void setEnabled(String decoratorId, boolean enabled) throws CoreException {
        DecoratorDefinition definition = this.getDecoratorDefinition(decoratorId);
        if (definition != null) {
            definition.setEnabled(enabled);
            this.clearCaches();
            this.updateForEnablementChange();
        }
    }

    public IBaseLabelProvider getBaseLabelProvider(String decoratorId) {
        ILabelDecorator fullProvider = this.getLabelDecorator(decoratorId);
        if (fullProvider == null) {
            return this.getLightweightLabelDecorator(decoratorId);
        }
        return fullProvider;
    }

    public ILabelDecorator getLabelDecorator(String decoratorId) {
        FullDecoratorDefinition definition = this.getFullDecoratorDefinition(decoratorId);
        if (definition != null && definition.isEnabled()) {
            return definition.getDecorator();
        }
        return null;
    }

    public ILightweightLabelDecorator getLightweightLabelDecorator(String decoratorId) {
        LightweightDecoratorDefinition definition = this.lightweightManager.getDecoratorDefinition(decoratorId);
        if (definition != null && definition.isEnabled()) {
            return definition.getDecorator();
        }
        return null;
    }

    private DecoratorDefinition getDecoratorDefinition(String decoratorId) {
        FullDecoratorDefinition returnValue = this.getFullDecoratorDefinition(decoratorId);
        if (returnValue == null) {
            return this.lightweightManager.getDecoratorDefinition(decoratorId);
        }
        return returnValue;
    }

    private FullDecoratorDefinition getFullDecoratorDefinition(String decoratorId) {
        for (int i = 0; i < this.fullDefinitions.length; ++i) {
            if (!this.fullDefinitions[i].getId().equals(decoratorId)) continue;
            return this.fullDefinitions[i];
        }
        return null;
    }

    private FullDecoratorDefinition[] getDecoratorsFor(Object element) {
        if (element == null) {
            return EMPTY_FULL_DEF;
        }
        String className = element.getClass().getName();
        FullDecoratorDefinition[] decoratorArray = (FullDecoratorDefinition[])this.cachedFullDecorators.get(className);
        if (decoratorArray != null) {
            return decoratorArray;
        }
        Collection decorators = DecoratorManager.getDecoratorsFor(element, this.enabledFullDefinitions());
        if (decorators.size() == 0) {
            decoratorArray = EMPTY_FULL_DEF;
        } else {
            decoratorArray = new FullDecoratorDefinition[decorators.size()];
            decorators.toArray(decoratorArray);
        }
        this.cachedFullDecorators.put(className, decoratorArray);
        return decoratorArray;
    }

    LightweightDecoratorManager getLightweightManager() {
        return this.lightweightManager;
    }

    public void update(String decoratorId) {
        IBaseLabelProvider provider = this.getBaseLabelProvider(decoratorId);
        if (provider != null) {
            this.scheduler.clearResults();
            this.fireListeners(new LabelProviderChangedEvent(provider));
        }
    }

    public boolean prepareDecoration(Object element, String originalText) {
        if (this.scheduler.isDecorationReady(element) || !this.getLightweightManager().hasEnabledDefinitions()) {
            return true;
        }
        this.scheduler.queueForDecoration(element, this.getResourceAdapter(element), true, originalText);
        return this.fullDefinitions.length > 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

