/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.UserLibrary;
import org.eclipse.jdt.internal.core.UserLibraryClasspathContainer;

public class UserLibraryManager {
    public static final String CP_USERLIBRARY_PREFERENCES_PREFIX = "org.eclipse.jdt.core.userLibrary.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    private static Map userLibraries;
    private static final boolean logProblems = false;
    private static Preferences.IPropertyChangeListener listener;

    private UserLibraryManager() {
    }

    public static String[] getUserLibraryNames() {
        Set set = UserLibraryManager.getLibraryMap().keySet();
        return set.toArray(new String[set.size()]);
    }

    public static UserLibrary getUserLibrary(String name) {
        return (UserLibrary)UserLibraryManager.getLibraryMap().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserLibraries(String[] newNames, UserLibrary[] newLibs, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue(newNames.length == newLibs.length, "names and libraries should have the same length");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Configure user libraries...", newNames.length);
        try {
            int last = newNames.length - 1;
            for (int i = 0; i < newLibs.length; ++i) {
                UserLibraryManager.internalSetUserLibrary(newNames[i], newLibs[i], i == last, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void setUserLibrary(String name, UserLibrary library, IProgressMonitor monitor) throws JavaModelException {
        UserLibraryManager.internalSetUserLibrary(name, library, true, true, monitor);
    }

    static Map getLibraryMap() {
        if (userLibraries == null) {
            userLibraries = new HashMap();
            Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
            preferences.addPropertyChangeListener(listener);
            String[] propertyNames = preferences.propertyNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                String propertyName = propertyNames[i];
                if (!propertyName.startsWith(CP_USERLIBRARY_PREFERENCES_PREFIX)) continue;
                try {
                    UserLibraryManager.recreatePersistedUserLibraryEntry(propertyName, preferences.getString(propertyName), false, false);
                    continue;
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
        }
        return userLibraries;
    }

    static void recreatePersistedUserLibraryEntry(String propertyName, String savedString, boolean save, boolean rebind) throws JavaModelException {
        String libName = propertyName.substring(CP_USERLIBRARY_PREFERENCES_PREFIX.length());
        if (savedString == null || savedString.equals(CP_ENTRY_IGNORE)) {
            UserLibraryManager.internalSetUserLibrary(libName, null, save, rebind, null);
        } else {
            try {
                StringReader reader = new StringReader(savedString);
                UserLibrary library = UserLibrary.createFromString(reader);
                UserLibraryManager.internalSetUserLibrary(libName, library, save, rebind, null);
            }
            catch (IOException e) {
                UserLibraryManager.internalSetUserLibrary(libName, null, save, rebind, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void internalSetUserLibrary(String name, UserLibrary library, boolean save, boolean rebind, IProgressMonitor monitor) throws JavaModelException {
        Object previous;
        if (library == null ? (previous = UserLibraryManager.getLibraryMap().remove(name)) == null : library.equals(previous = UserLibraryManager.getLibraryMap().put(name, library))) {
            return;
        }
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        String containerKey = CP_USERLIBRARY_PREFERENCES_PREFIX + name;
        String containerString = CP_ENTRY_IGNORE;
        if (library != null) {
            try {
                containerString = library.serialize();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        preferences.removePropertyChangeListener(listener);
        try {
            preferences.setDefault(containerKey, CP_ENTRY_IGNORE);
            preferences.setValue(containerKey, containerString);
            if (save) {
                JavaCore.getPlugin().savePluginPreferences();
            }
            if (rebind) {
                UserLibraryManager.rebindClasspathEntries(name, library == null, monitor);
            }
        }
        finally {
            preferences.addPropertyChangeListener(listener);
        }
    }

    private static void rebindClasspathEntries(String name, boolean remove, IProgressMonitor monitor) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] projects = JavaCore.create(root).getJavaProjects();
        IPath containerPath = new Path("org.eclipse.jdt.USER_LIBRARY").append(name);
        ArrayList<IJavaProject> affectedProjects = new ArrayList<IJavaProject>();
        block0: for (int i = 0; i < projects.length; ++i) {
            IJavaProject project = projects[i];
            IClasspathEntry[] entries = project.getRawClasspath();
            for (int k = 0; k < entries.length; ++k) {
                IClasspathEntry curr = entries[k];
                if (curr.getEntryKind() != 5 || !containerPath.equals(curr.getPath())) continue;
                affectedProjects.add(project);
                continue block0;
            }
        }
        if (!affectedProjects.isEmpty()) {
            IJavaProject[] affected = affectedProjects.toArray(new IJavaProject[affectedProjects.size()]);
            IClasspathContainer[] containers = new IClasspathContainer[affected.length];
            if (!remove) {
                UserLibraryClasspathContainer container = new UserLibraryClasspathContainer(name);
                containers[0] = container;
            }
            JavaCore.setClasspathContainer(containerPath, affected, containers, monitor);
        } else if (monitor != null) {
            monitor.done();
        }
    }

    static {
        listener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String key = event.getProperty();
                if (key.startsWith(UserLibraryManager.CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                    try {
                        UserLibraryManager.recreatePersistedUserLibraryEntry(key, (String)event.getNewValue(), false, true);
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

