/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExtMethodPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Text cvsRsh;
    Text cvsServer;
    Text cvsRshParameters;
    private Button useExternal;
    private Button useInternal;
    private Combo methodType;
    private Control internal;
    private Control external;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtMethodPreferencePage.this.updateEnablements();
            }
        };
        this.useExternal = this.createRadioButton(composite, Policy.bind("ExtMethodPreferencePage.0"), 1);
        this.useExternal.addSelectionListener((SelectionListener)selectionListener);
        this.external = this.createExternalArea(composite);
        this.useInternal = this.createRadioButton(composite, Policy.bind("ExtMethodPreferencePage.1"), 1);
        this.useInternal.addSelectionListener((SelectionListener)selectionListener);
        this.internal = this.createInternalArea(composite);
        this.initializeDefaults();
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.ext_preference_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void updateEnablements() {
        this.external.setEnabled(this.useExternal.getSelection());
        this.cvsRsh.setEnabled(this.useExternal.getSelection());
        this.cvsRshParameters.setEnabled(this.useExternal.getSelection());
        this.cvsServer.setEnabled(this.useExternal.getSelection());
        this.internal.setEnabled(!this.useExternal.getSelection());
        this.methodType.setEnabled(!this.useExternal.getSelection());
    }

    private Control createInternalArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        Label intro = new Label(composite, 16448);
        intro.setText("Choosing to use another connection method allows the meta information in CVS projects to be compatible with external CVS tools while using a custom connection method.");
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        intro.setLayoutData((Object)data);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.connectionType"), 1);
        this.methodType = this.createCombo(composite);
        return composite;
    }

    protected Control createExternalArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        Label intro = new Label(composite, 16448);
        intro.setText(Policy.bind("ExtMethodPreferencePage_message"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        intro.setLayoutData((Object)data);
        new Label(composite, 16384).setText(Policy.bind("ExtMethodPreferencePage_CVS_RSH"));
        this.cvsRsh = new Text(composite, 2048);
        this.cvsRsh.setLayoutData((Object)new GridData(768));
        Button b = new Button(composite, 0);
        b.setText(Policy.bind("ExtMethodPreferencePage_Browse"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, b.computeSize((int)-1, (int)-1, (boolean)true).x);
        b.setLayoutData((Object)data);
        b.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(ExtMethodPreferencePage.this.getShell());
                d.setText(Policy.bind("ExtMethodPreferencePage_Details"));
                String file = d.open();
                if (file != null) {
                    ExtMethodPreferencePage.this.setCvsRshText(file);
                }
            }
        });
        new Label(composite, 16384).setText(Policy.bind("ExtMethodPreferencePage_CVS_RSH_Parameters"));
        this.cvsRshParameters = new Text(composite, 2048);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        this.cvsRshParameters.setLayoutData((Object)data);
        new Label(composite, 16384).setText(Policy.bind("ExtMethodPreferencePage_CVS_SERVER__7"));
        this.cvsServer = new Text(composite, 2048);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        this.cvsServer.setLayoutData((Object)data);
        WorkbenchHelp.setHelp((Control)this.cvsRsh, (String)"org.eclipse.team.cvs.ui.ext_preference_rsh_context");
        WorkbenchHelp.setHelp((Control)this.cvsRshParameters, (String)"org.eclipse.team.cvs.ui.ext_preference_param_context");
        WorkbenchHelp.setHelp((Control)this.cvsServer, (String)"org.eclipse.team.cvs.ui.ext_preference_server_context");
        return composite;
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.cvsRsh.setText(store.getString("pref_cvs_rsh"));
        this.cvsRshParameters.setText(store.getString("pref_cvs_rsh_parameters"));
        this.cvsServer.setText(store.getString("pref_cvs_server"));
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (name.equals("ext")) continue;
            this.methodType.add(name);
        }
        String method = store.getString("pref_ext_connection_method_proxy");
        if (method.equals("ext")) {
            this.methodType.select(0);
        } else {
            this.methodType.select(this.methodType.indexOf(method));
        }
        this.useExternal.setSelection(method.equals("ext"));
        this.useInternal.setSelection(!method.equals("ext"));
        this.updateEnablements();
    }

    protected void setCvsRshText(String s) {
        this.cvsRsh.setText(s);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        String method;
        IPreferenceStore store = this.getPreferenceStore();
        if (this.useExternal.getSelection()) {
            method = "ext";
            store.setValue("pref_cvs_rsh", this.cvsRsh.getText());
            store.setValue("pref_cvs_rsh_parameters", this.cvsRshParameters.getText());
            store.setValue("pref_cvs_server", this.cvsServer.getText());
            CVSProviderPlugin.getPlugin().setCvsRshCommand(this.cvsRsh.getText());
            CVSProviderPlugin.getPlugin().setCvsRshParameters(this.cvsRshParameters.getText());
            CVSProviderPlugin.getPlugin().setCvsServer(this.cvsServer.getText());
        } else {
            method = this.methodType.getText();
        }
        store.setValue("pref_ext_connection_method_proxy", method);
        CVSRepositoryLocation.setExtConnectionMethodProxy((String)method);
        CVSUIPlugin.getPlugin().savePluginPreferences();
        return super.performOk();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 1;
        combo.setLayoutData((Object)data);
        return combo;
    }
}

