/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class RunToLineActionDelegate
implements IEditorActionDelegate,
IActionDelegate2 {
    private IEditorPart fActivePart = null;
    private IRunToLineTarget fPartTarget = null;
    private IAction fAction = null;
    private ISelectionListener fSelectionListener = new DebugSelectionListener();
    private ISuspendResume fTargetElement = null;
    static /* synthetic */ Class class$org$eclipse$debug$ui$actions$IRunToLineTarget;

    public void dispose() {
        this.fActivePart.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
        this.fActivePart = null;
        this.fPartTarget = null;
    }

    public void run(IAction action) {
        if (this.fPartTarget != null && this.fTargetElement != null) {
            try {
                this.fPartTarget.runToLine((IWorkbenchPart)this.fActivePart, this.fActivePart.getSite().getSelectionProvider().getSelection(), this.fTargetElement);
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.fActivePart.getSite().getWorkbenchWindow().getShell(), ActionMessages.getString("RunToLineAction.0"), ActionMessages.getString("RunToLineAction.1"), e.getStatus());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.update();
    }

    public void update() {
        if (this.fAction == null) {
            return;
        }
        if (this.fPartTarget != null && this.fTargetElement != null) {
            this.fAction.setEnabled(this.fTargetElement.isSuspended() && this.fPartTarget.canRunToLine((IWorkbenchPart)this.fActivePart, this.fActivePart.getSite().getSelectionProvider().getSelection(), this.fTargetElement));
        } else {
            this.fAction.setEnabled(false);
        }
    }

    public void init(IAction action) {
        this.fAction = action;
        if (action != null) {
            action.setText(ActionMessages.getString("RunToLineActionDelegate.4"));
            action.setImageDescriptor(DebugUITools.getImageDescriptor("IMG_LCL_RUN_TO_LINE"));
            action.setDisabledImageDescriptor(DebugUITools.getImageDescriptor("IMG_DLCL_RUN_TO_LINE"));
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.init(action);
        if (this.fActivePart != null && !this.fActivePart.equals(targetEditor)) {
            this.fActivePart.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
        }
        this.fPartTarget = null;
        this.fActivePart = targetEditor;
        if (targetEditor != null) {
            IAdapterManager adapterManager;
            targetEditor.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", this.fSelectionListener);
            this.fPartTarget = (IRunToLineTarget)targetEditor.getAdapter(class$org$eclipse$debug$ui$actions$IRunToLineTarget == null ? (class$org$eclipse$debug$ui$actions$IRunToLineTarget = RunToLineActionDelegate.class$("org.eclipse.debug.ui.actions.IRunToLineTarget")) : class$org$eclipse$debug$ui$actions$IRunToLineTarget);
            if (this.fPartTarget == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)targetEditor, "org.eclipse.debug.internal.ui.actions.IRunToLineTarget")) {
                this.fPartTarget = (IRunToLineTarget)adapterManager.loadAdapter((Object)targetEditor, "org.eclipse.debug.internal.ui.actions.IRunToLineTarget");
            }
        }
        this.update();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DebugSelectionListener
    implements ISelectionListener {
        DebugSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object object;
            IStructuredSelection ss;
            RunToLineActionDelegate.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof ISuspendResume) {
                RunToLineActionDelegate.this.fTargetElement = (ISuspendResume)object;
            }
            RunToLineActionDelegate.this.update();
        }
    }
}

