/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;

public abstract class OpenTypeAction
extends ObjectActionDelegate {
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Iterator itr = selection.iterator();
        try {
            while (itr.hasNext()) {
                Object element = itr.next();
                this.doAction(element);
            }
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected abstract IDebugElement getDebugElement(IAdaptable var1);

    protected abstract String getTypeNameToOpen(IDebugElement var1) throws DebugException;

    protected void doAction(Object e) throws DebugException {
        IAdaptable element = (IAdaptable)e;
        IDebugElement dbgElement = this.getDebugElement(element);
        if (dbgElement != null) {
            Object sourceElement = this.getSourceElement(dbgElement);
            if (sourceElement == null) {
                try {
                    String typeName = this.getTypeNameToOpen(dbgElement);
                    sourceElement = OpenTypeAction.findTypeInWorkspace(typeName);
                }
                catch (CoreException x) {
                    JDIDebugUIPlugin.log(x);
                }
            }
            if (sourceElement != null) {
                this.openInEditor(sourceElement);
            }
        }
    }

    protected void openInEditor(Object sourceElement) {
        try {
            IEditorPart part = EditorUtility.openInEditor((Object)sourceElement);
            if (part != null && sourceElement instanceof IJavaElement) {
                EditorUtility.revealInEditor((IEditorPart)part, (IJavaElement)((IJavaElement)sourceElement));
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public static IType findTypeInWorkspace(String typeName) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        for (int i = 0; i < projects.length; ++i) {
            IType type = OpenTypeAction.findType(projects[i], typeName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private static IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        String pathStr = fullyQualifiedName.replace('.', '/') + ".java";
        IJavaElement jelement = jproject.findElement((IPath)new Path(pathStr));
        if (jelement == null) {
            IType res;
            IType type;
            String qualifier = Signature.getQualifier((String)fullyQualifiedName);
            if (qualifier.length() > 0 && (type = OpenTypeAction.findType(jproject, qualifier)) != null && (res = type.getType(Signature.getSimpleName((String)fullyQualifiedName))).exists()) {
                return res;
            }
        } else {
            if (jelement.getElementType() == 5) {
                String simpleName = Signature.getSimpleName((String)fullyQualifiedName);
                return ((ICompilationUnit)jelement).getType(simpleName);
            }
            if (jelement.getElementType() == 6) {
                return ((IClassFile)jelement).getType();
            }
        }
        return null;
    }

    protected Object getSourceElement(Object e) {
        if (e instanceof IDebugElement) {
            IDebugElement de = (IDebugElement)e;
            String typeName = null;
            try {
                List list;
                typeName = this.getTypeNameToOpen(de);
                if (typeName != null && !(list = ToggleBreakpointAdapter.searchForTypes(typeName, de.getLaunch())).isEmpty()) {
                    return list.get(0);
                }
            }
            catch (CoreException ex) {
                JDIDebugUIPlugin.errorDialog(ActionMessages.getString("OpenTypeAction.2"), ex.getStatus());
            }
        }
        return null;
    }

    public static Object findSourceElement(String typeName, ISourceLocator sourceLocator) {
        JavaUISourceLocator javaSourceLocator;
        if (sourceLocator instanceof ISourceLookupDirector) {
            ISourceLookupDirector director = (ISourceLookupDirector)sourceLocator;
            String fileName = typeName.replace('.', File.separatorChar);
            Object object = director.getSourceElement((Object)(fileName = fileName + ".java"));
            if (object != null) {
                IJavaElement element;
                if (object instanceof IAdaptable && (element = (IJavaElement)((IAdaptable)object).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = OpenTypeAction.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement)) != null) {
                    return element;
                }
                return object;
            }
        }
        IJavaSourceLocation[] locations = null;
        if (sourceLocator instanceof JavaUISourceLocator) {
            javaSourceLocator = (JavaUISourceLocator)sourceLocator;
            locations = javaSourceLocator.getSourceLocations();
        } else if (sourceLocator instanceof JavaSourceLocator) {
            javaSourceLocator = (JavaSourceLocator)sourceLocator;
            locations = javaSourceLocator.getSourceLocations();
        }
        if (locations != null) {
            for (int i = 0; i < locations.length; ++i) {
                IJavaSourceLocation location = locations[i];
                Object sourceElement = null;
                try {
                    sourceElement = location.findSourceElement(typeName);
                }
                catch (CoreException e) {
                    // empty catch block
                }
                if (sourceElement == null) continue;
                return sourceElement;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

