/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

class RussianStemmer {
    private char[] charset;
    private int RV;
    private int R1;
    private int R2;
    private static char A = '\u0000';
    private static char B = '\u0001';
    private static char V = (char)2;
    private static char G = (char)3;
    private static char D = (char)4;
    private static char E = (char)5;
    private static char ZH = (char)6;
    private static char Z = (char)7;
    private static char I = (char)8;
    private static char I_ = (char)9;
    private static char K = (char)10;
    private static char L = (char)11;
    private static char M = (char)12;
    private static char N = (char)13;
    private static char O = (char)14;
    private static char P = (char)15;
    private static char R = (char)16;
    private static char S = (char)17;
    private static char T = (char)18;
    private static char U = (char)19;
    private static char F = (char)20;
    private static char X = (char)21;
    private static char TS = (char)22;
    private static char CH = (char)23;
    private static char SH = (char)24;
    private static char SHCH = (char)25;
    private static char HARD = (char)26;
    private static char Y = (char)27;
    private static char SOFT = (char)28;
    private static char AE = (char)29;
    private static char IU = (char)30;
    private static char IA = (char)31;
    private static char[] vowels = new char[]{A, E, I, O, U, Y, AE, IU, IA};
    private static char[][] perfectiveGerundEndings1 = new char[][]{{V}, {V, SH, I}, {V, SH, I, S, SOFT}};
    private static char[][] perfectiveGerund1Predessors = new char[][]{{A}, {IA}};
    private static char[][] perfectiveGerundEndings2 = new char[][]{{I, V}, {Y, V}, {I, V, SH, I}, {Y, V, SH, I}, {I, V, SH, I, S, SOFT}, {Y, V, SH, I, S, SOFT}};
    private static char[][] adjectiveEndings = new char[][]{{E, E}, {I, E}, {Y, E}, {O, E}, {E, I_}, {I, I_}, {Y, I_}, {O, I_}, {E, M}, {I, M}, {Y, M}, {O, M}, {I, X}, {Y, X}, {U, IU}, {IU, IU}, {A, IA}, {IA, IA}, {O, IU}, {E, IU}, {I, M, I}, {Y, M, I}, {E, G, O}, {O, G, O}, {E, M, U}, {O, M, U}};
    private static char[][] participleEndings1 = new char[][]{{SHCH}, {E, M}, {N, N}, {V, SH}, {IU, SHCH}};
    private static char[][] participleEndings2 = new char[][]{{I, V, SH}, {Y, V, SH}, {U, IU, SHCH}};
    private static char[][] participle1Predessors = new char[][]{{A}, {IA}};
    private static char[][] reflexiveEndings = new char[][]{{S, IA}, {S, SOFT}};
    private static char[][] verbEndings1 = new char[][]{{I_}, {L}, {N}, {L, O}, {N, O}, {E, T}, {IU, T}, {L, A}, {N, A}, {L, I}, {E, M}, {N, Y}, {E, T, E}, {I_, T, E}, {T, SOFT}, {E, SH, SOFT}, {N, N, O}};
    private static char[][] verbEndings2 = new char[][]{{IU}, {U, IU}, {E, N}, {E, I_}, {IA, T}, {U, I_}, {I, L}, {Y, L}, {I, M}, {Y, M}, {I, T}, {Y, T}, {I, L, A}, {Y, L, A}, {E, N, A}, {I, T, E}, {I, L, I}, {Y, L, I}, {I, L, O}, {Y, L, O}, {E, N, O}, {U, E, T}, {U, IU, T}, {E, N, Y}, {I, T, SOFT}, {Y, T, SOFT}, {I, SH, SOFT}, {E, I_, T, E}, {U, I_, T, E}};
    private static char[][] verb1Predessors = new char[][]{{A}, {IA}};
    private static char[][] nounEndings = new char[][]{{A}, {U}, {I_}, {O}, {U}, {E}, {Y}, {I}, {SOFT}, {IA}, {E, V}, {O, V}, {I, E}, {SOFT, E}, {IA, X}, {I, IU}, {E, I}, {I, I}, {E, I_}, {O, I_}, {E, M}, {A, M}, {O, M}, {A, X}, {SOFT, IU}, {I, IA}, {SOFT, IA}, {I, I_}, {IA, M}, {IA, M, I}, {A, M, I}, {I, E, I_}, {I, IA, M}, {I, E, M}, {I, IA, X}, {I, IA, M, I}};
    private static char[][] superlativeEndings = new char[][]{{E, I_, SH}, {E, I_, SH, E}};
    private static char[][] derivationalEndings = new char[][]{{O, S, T}, {O, S, T, SOFT}};

    public RussianStemmer() {
    }

    public RussianStemmer(char[] charset) {
        this.charset = charset;
    }

    private boolean adjectival(StringBuffer stemmingZone) {
        if (!this.findAndRemoveEnding(stemmingZone, adjectiveEndings)) {
            return false;
        }
        boolean r = this.findAndRemoveEnding(stemmingZone, participleEndings1, participle1Predessors) || this.findAndRemoveEnding(stemmingZone, participleEndings2);
        return true;
    }

    private boolean derivational(StringBuffer stemmingZone) {
        int endingLength = this.findEnding(stemmingZone, derivationalEndings);
        if (endingLength == 0) {
            return false;
        }
        if (this.R2 - this.RV <= stemmingZone.length() - endingLength) {
            stemmingZone.setLength(stemmingZone.length() - endingLength);
            return true;
        }
        return false;
    }

    private int findEnding(StringBuffer stemmingZone, int startIndex, char[][] theEndingClass) {
        boolean match = false;
        for (int i = theEndingClass.length - 1; i >= 0; --i) {
            char[] theEnding = theEndingClass[i];
            if (startIndex < theEnding.length - 1) {
                match = false;
                continue;
            }
            match = true;
            int stemmingIndex = startIndex;
            for (int j = theEnding.length - 1; j >= 0; --j) {
                if (stemmingZone.charAt(stemmingIndex--) == this.charset[theEnding[j]]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return theEndingClass[i].length;
        }
        return 0;
    }

    private int findEnding(StringBuffer stemmingZone, char[][] theEndingClass) {
        return this.findEnding(stemmingZone, stemmingZone.length() - 1, theEndingClass);
    }

    private boolean findAndRemoveEnding(StringBuffer stemmingZone, char[][] theEndingClass) {
        int endingLength = this.findEnding(stemmingZone, theEndingClass);
        if (endingLength == 0) {
            return false;
        }
        stemmingZone.setLength(stemmingZone.length() - endingLength);
        return true;
    }

    private boolean findAndRemoveEnding(StringBuffer stemmingZone, char[][] theEndingClass, char[][] thePredessors) {
        int endingLength = this.findEnding(stemmingZone, theEndingClass);
        if (endingLength == 0) {
            return false;
        }
        int predessorLength = this.findEnding(stemmingZone, stemmingZone.length() - endingLength - 1, thePredessors);
        if (predessorLength == 0) {
            return false;
        }
        stemmingZone.setLength(stemmingZone.length() - endingLength);
        return true;
    }

    private void markPositions(String word) {
        int i;
        this.RV = 0;
        this.R1 = 0;
        this.R2 = 0;
        for (i = 0; word.length() > i && !this.isVowel(word.charAt(i)); ++i) {
        }
        if (word.length() - 1 < ++i) {
            return;
        }
        this.RV = i;
        while (word.length() > i && this.isVowel(word.charAt(i))) {
            ++i;
        }
        if (word.length() - 1 < ++i) {
            return;
        }
        this.R1 = i;
        while (word.length() > i && !this.isVowel(word.charAt(i))) {
            ++i;
        }
        if (word.length() - 1 < ++i) {
            return;
        }
        while (word.length() > i && this.isVowel(word.charAt(i))) {
            ++i;
        }
        if (word.length() - 1 < ++i) {
            return;
        }
        this.R2 = i;
    }

    private boolean isVowel(char letter) {
        for (int i = 0; i < vowels.length; ++i) {
            if (letter != this.charset[vowels[i]]) continue;
            return true;
        }
        return false;
    }

    private boolean noun(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, nounEndings);
    }

    private boolean perfectiveGerund(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, perfectiveGerundEndings1, perfectiveGerund1Predessors) || this.findAndRemoveEnding(stemmingZone, perfectiveGerundEndings2);
    }

    private boolean reflexive(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, reflexiveEndings);
    }

    private boolean removeI(StringBuffer stemmingZone) {
        if (stemmingZone.length() > 0 && stemmingZone.charAt(stemmingZone.length() - 1) == this.charset[I]) {
            stemmingZone.setLength(stemmingZone.length() - 1);
            return true;
        }
        return false;
    }

    private boolean removeSoft(StringBuffer stemmingZone) {
        if (stemmingZone.length() > 0 && stemmingZone.charAt(stemmingZone.length() - 1) == this.charset[SOFT]) {
            stemmingZone.setLength(stemmingZone.length() - 1);
            return true;
        }
        return false;
    }

    public void setCharset(char[] newCharset) {
        this.charset = newCharset;
    }

    private void setEndings() {
        vowels = new char[]{A, E, I, O, U, Y, AE, IU, IA};
        perfectiveGerundEndings1 = new char[][]{{V}, {V, SH, I}, {V, SH, I, S, SOFT}};
        perfectiveGerund1Predessors = new char[][]{{A}, {IA}};
        perfectiveGerundEndings2 = new char[][]{{I, V}, {Y, V}, {I, V, SH, I}, {Y, V, SH, I}, {I, V, SH, I, S, SOFT}, {Y, V, SH, I, S, SOFT}};
        adjectiveEndings = new char[][]{{E, E}, {I, E}, {Y, E}, {O, E}, {E, I_}, {I, I_}, {Y, I_}, {O, I_}, {E, M}, {I, M}, {Y, M}, {O, M}, {I, X}, {Y, X}, {U, IU}, {IU, IU}, {A, IA}, {IA, IA}, {O, IU}, {E, IU}, {I, M, I}, {Y, M, I}, {E, G, O}, {O, G, O}, {E, M, U}, {O, M, U}};
        participleEndings1 = new char[][]{{SHCH}, {E, M}, {N, N}, {V, SH}, {IU, SHCH}};
        participleEndings2 = new char[][]{{I, V, SH}, {Y, V, SH}, {U, IU, SHCH}};
        participle1Predessors = new char[][]{{A}, {IA}};
        reflexiveEndings = new char[][]{{S, IA}, {S, SOFT}};
        verbEndings1 = new char[][]{{I_}, {L}, {N}, {L, O}, {N, O}, {E, T}, {IU, T}, {L, A}, {N, A}, {L, I}, {E, M}, {N, Y}, {E, T, E}, {I_, T, E}, {T, SOFT}, {E, SH, SOFT}, {N, N, O}};
        verbEndings2 = new char[][]{{IU}, {U, IU}, {E, N}, {E, I_}, {IA, T}, {U, I_}, {I, L}, {Y, L}, {I, M}, {Y, M}, {I, T}, {Y, T}, {I, L, A}, {Y, L, A}, {E, N, A}, {I, T, E}, {I, L, I}, {Y, L, I}, {I, L, O}, {Y, L, O}, {E, N, O}, {U, E, T}, {U, IU, T}, {E, N, Y}, {I, T, SOFT}, {Y, T, SOFT}, {I, SH, SOFT}, {E, I_, T, E}, {U, I_, T, E}};
        verb1Predessors = new char[][]{{A}, {IA}};
        nounEndings = new char[][]{{A}, {IU}, {I_}, {O}, {U}, {E}, {Y}, {I}, {SOFT}, {IA}, {E, V}, {O, V}, {I, E}, {SOFT, E}, {IA, X}, {I, IU}, {E, I}, {I, I}, {E, I_}, {O, I_}, {E, M}, {A, M}, {O, M}, {A, X}, {SOFT, IU}, {I, IA}, {SOFT, IA}, {I, I_}, {IA, M}, {IA, M, I}, {A, M, I}, {I, E, I_}, {I, IA, M}, {I, E, M}, {I, IA, X}, {I, IA, M, I}};
        superlativeEndings = new char[][]{{E, I_, SH}, {E, I_, SH, E}};
        derivationalEndings = new char[][]{{O, S, T}, {O, S, T, SOFT}};
    }

    public String stem(String input) {
        this.markPositions(input);
        if (this.RV == 0) {
            return input;
        }
        StringBuffer stemmingZone = new StringBuffer(input.substring(this.RV));
        if (!this.perfectiveGerund(stemmingZone)) {
            this.reflexive(stemmingZone);
            boolean bl = this.adjectival(stemmingZone) || this.verb(stemmingZone) || this.noun(stemmingZone);
        }
        this.removeI(stemmingZone);
        this.derivational(stemmingZone);
        this.superlative(stemmingZone);
        this.undoubleN(stemmingZone);
        this.removeSoft(stemmingZone);
        return input.substring(0, this.RV) + stemmingZone.toString();
    }

    private boolean superlative(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, superlativeEndings);
    }

    private boolean undoubleN(StringBuffer stemmingZone) {
        char[][] doubleN = new char[][]{{N, N}};
        if (this.findEnding(stemmingZone, doubleN) != 0) {
            stemmingZone.setLength(stemmingZone.length() - 1);
            return true;
        }
        return false;
    }

    private boolean verb(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, verbEndings1, verb1Predessors) || this.findAndRemoveEnding(stemmingZone, verbEndings2);
    }

    public static String stem(String theWord, char[] charset) {
        RussianStemmer stemmer = new RussianStemmer();
        stemmer.setCharset(charset);
        return stemmer.stem(theWord);
    }
}

