/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.internal.samples;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.launcher.RuntimeWorkbenchShortcut;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;

public class SampleEditor
extends EditorPart {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private FormText descText;
    private FormText instText;
    private ILaunchShortcut defaultShortcut = new RuntimeWorkbenchShortcut();
    private InputFileListener inputFileListener;

    public SampleEditor() {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        Properties properties = this.loadContent();
        this.form.setText(properties.getProperty("name"));
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 10;
        layout.topMargin = 10;
        layout.bottomMargin = 10;
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        this.form.getBody().setLayout((Layout)layout);
        final String launcher = properties.getProperty("launcher");
        final String launchTarget = properties.getProperty("launchTarget");
        this.descText = this.toolkit.createFormText(this.form.getBody(), true);
        this.descText.setLayoutData((Object)new TableWrapData(256));
        String desc = properties.getProperty("description");
        String content = PDEPlugin.getFormattedMessage("SampleEditor.desc", desc != null ? desc : "");
        this.descText.setText(content, true, false);
        final String helpURL = properties.getProperty("helpHref");
        if (helpURL != null) {
            Hyperlink moreLink = this.toolkit.createHyperlink(this.form.getBody(), "Read More", 0);
            moreLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    WorkbenchHelp.displayHelpResource((String)helpURL);
                }
            });
        }
        this.instText = this.toolkit.createFormText(this.form.getBody(), true);
        this.instText.setLayoutData((Object)new TableWrapData(256));
        StringBuffer buf = new StringBuffer();
        buf.append(PDEPlugin.getResourceString("SampleEditor.content"));
        this.instText.setText(buf.toString(), true, false);
        this.instText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                if (href.equals("help")) {
                    WorkbenchHelp.displayHelpResource((String)helpURL);
                } else if (href.equals("run")) {
                    SampleEditor.this.doRun(launcher, launchTarget, false);
                } else if (href.equals("debug")) {
                    SampleEditor.this.doRun(launcher, launchTarget, true);
                }
            }
        });
        this.instText.setImage("run", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_RUN_EXC));
        this.instText.setImage("debug", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DEBUG_EXC));
        this.instText.setImage("help", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
    }

    private void doRun(String launcher, String target, boolean debug) {
        ILaunchShortcut shortcut = this.defaultShortcut;
        StructuredSelection selection = target != null ? new StructuredSelection() : new StructuredSelection();
        final ILaunchShortcut fshortcut = shortcut;
        BusyIndicator.showWhile((Display)this.form.getDisplay(), (Runnable)new Runnable((ISelection)selection, debug){
            private final /* synthetic */ ISelection val$selection;
            private final /* synthetic */ boolean val$debug;
            {
                this.val$selection = val$selection;
                this.val$debug = val$debug;
            }

            public void run() {
                fshortcut.launch(this.val$selection, this.val$debug ? "debug" : "run");
            }
        });
    }

    private Properties loadContent() {
        IStorageEditorInput input = (IStorageEditorInput)this.getEditorInput();
        Properties properties = new Properties();
        try {
            IStorage storage = input.getStorage();
            InputStream is = storage.getContents();
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return properties;
    }

    public void dispose() {
        if (this.inputFileListener != null) {
            PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.inputFileListener);
            this.inputFileListener = null;
        }
        this.toolkit.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.inputFileListener = new InputFileListener();
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.inputFileListener);
    }

    public void close() {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (SampleEditor.this.toolkit != null) {
                    SampleEditor.this.getSite().getPage().closeEditor((IEditorPart)SampleEditor.this, false);
                }
            }
        });
    }

    class InputFileListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        InputFileListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                IResourceDelta delta = event.getDelta();
                try {
                    delta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IFile file;
            IResource resource = delta.getResource();
            if (resource instanceof IFile && (file = (IFile)resource).equals(((IFileEditorInput)SampleEditor.this.getEditorInput()).getFile())) {
                if (delta.getKind() == 2 || delta.getKind() == 262144) {
                    SampleEditor.this.close();
                }
                return false;
            }
            return true;
        }
    }
}

