/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;

public class OpenActionGroup
extends ResourceNavigatorActionGroup {
    private OpenFileAction openFileAction;
    public static final String OPEN_WITH_ID = "org.eclipse.ui.OpenWithSubMenu";

    public OpenActionGroup(IResourceNavigator navigator) {
        super(navigator);
    }

    protected void makeActions() {
        this.openFileAction = new OpenFileAction(this.navigator.getSite().getPage());
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean onlyFilesSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(selection, 7);
        boolean bl = onlyFilesSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(selection, 1);
        if (onlyFilesSelected) {
            this.openFileAction.selectionChanged(selection);
            menu.add((IAction)this.openFileAction);
            this.fillOpenWithMenu(menu, selection);
        }
        if (anyResourceSelected) {
            this.addNewWindowAction(menu, selection);
        }
    }

    private void fillOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IFile)) {
            return;
        }
        MenuManager submenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.openWith"), OPEN_WITH_ID);
        submenu.add((IContributionItem)new OpenWithMenu(this.navigator.getSite().getPage(), (IAdaptable)((IFile)element)));
        menu.add((IContributionItem)submenu);
    }

    private void addNewWindowAction(IMenuManager menu, IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IContainer)) {
            return;
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return;
        }
        menu.add((IAction)new OpenInNewWindowAction(this.navigator.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    public void runDefaultAction(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IFile) {
            this.openFileAction.selectionChanged(selection);
            this.openFileAction.run();
        }
    }
}

