/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.branding.IProductConstants;
import org.eclipse.ui.internal.BrandingProperties;
import org.osgi.framework.Bundle;

public class ProductProperties
extends BrandingProperties
implements IProductConstants {
    private final IProduct product;
    private String appName;
    private String aboutText;
    private ImageDescriptor aboutImageDescriptor;
    private ImageDescriptor[] windowImageDescriptors;
    private URL welcomePageUrl;
    private String productName;
    private String productId;
    private static final String ABOUT_MAPPINGS = "$nl$/about.mappings";
    private static String[] mappings = ProductProperties.loadMappings();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String[] loadMappings() {
        PropertyResourceBundle bundle;
        block17: {
            IProduct product = Platform.getProduct();
            if (product == null) {
                return new String[0];
            }
            URL location = Platform.find((Bundle)product.getDefiningBundle(), (IPath)new Path(ABOUT_MAPPINGS));
            bundle = null;
            if (location != null) {
                InputStream is = null;
                is = location.openStream();
                bundle = new PropertyResourceBundle(is);
                Object var6_4 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block17;
                }
                catch (IOException e2) {}
                break block17;
                {
                    catch (IOException e) {
                        bundle = null;
                        var6_4 = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                            break block17;
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        ArrayList<String> mappingsList = new ArrayList<String>();
        if (bundle != null) {
            boolean found = true;
            int i = 0;
            while (found) {
                try {
                    mappingsList.add(bundle.getString(Integer.toString(i)));
                }
                catch (MissingResourceException e) {
                    found = false;
                }
                ++i;
            }
        }
        return mappingsList.toArray(new String[mappingsList.size()]);
    }

    public ProductProperties(IProduct product) {
        if (product == null) {
            throw new IllegalArgumentException();
        }
        this.product = product;
    }

    public String getAppName() {
        if (this.appName == null) {
            this.appName = ProductProperties.getAppName(this.product);
        }
        return this.appName;
    }

    public String getAboutText() {
        if (this.aboutText == null) {
            this.aboutText = ProductProperties.getAboutText(this.product);
        }
        return this.aboutText;
    }

    public ImageDescriptor getAboutImage() {
        if (this.aboutImageDescriptor == null) {
            this.aboutImageDescriptor = ProductProperties.getAboutImage(this.product);
        }
        return this.aboutImageDescriptor;
    }

    public ImageDescriptor[] getWindowImages() {
        if (this.windowImageDescriptors == null) {
            this.windowImageDescriptors = ProductProperties.getWindowImages(this.product);
        }
        return this.windowImageDescriptors;
    }

    public URL getWelcomePageUrl() {
        if (this.welcomePageUrl == null) {
            this.welcomePageUrl = ProductProperties.getWelcomePageUrl(this.product);
        }
        return this.welcomePageUrl;
    }

    public String getProductName() {
        if (this.productName == null) {
            this.productName = ProductProperties.getProductName(this.product);
        }
        return this.productName;
    }

    public String getProductId() {
        if (this.productId == null) {
            this.productId = ProductProperties.getProductId(this.product);
        }
        return this.productId;
    }

    public static String getAppName(IProduct product) {
        String property = product.getProperty("appName");
        if (property == null) {
            return "";
        }
        if (property.indexOf(123) == -1) {
            return property;
        }
        return MessageFormat.format(property, mappings);
    }

    public static String getAboutText(IProduct product) {
        String property = product.getProperty("aboutText");
        if (property == null) {
            return "";
        }
        if (property.indexOf(123) == -1) {
            return property;
        }
        return MessageFormat.format(property, mappings);
    }

    public static ImageDescriptor getAboutImage(IProduct product) {
        return ProductProperties.getImage(product.getProperty("aboutImage"), product.getDefiningBundle());
    }

    public static ImageDescriptor[] getWindowImages(IProduct product) {
        String property = product.getProperty("windowImages");
        if (property == null) {
            property = product.getProperty("windowImage");
        }
        return ProductProperties.getImages(property, product.getDefiningBundle());
    }

    public static URL getWelcomePageUrl(IProduct product) {
        return ProductProperties.getUrl(product.getProperty("welcomePage"), product.getDefiningBundle());
    }

    public static String getProductName(IProduct product) {
        return product.getName();
    }

    public static String getProductId(IProduct product) {
        return product.getId();
    }
}

