/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleNativeCode;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.PermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

public class Framework
implements EventDispatcher,
EventPublisher {
    protected FrameworkAdaptor adaptor;
    protected Properties properties;
    protected boolean active;
    protected BundleRepository bundles;
    protected PackageAdminImpl packageAdmin;
    protected PermissionAdminImpl permissionAdmin;
    protected StartLevelManager startLevelManager;
    protected ServiceRegistry serviceRegistry;
    protected long serviceid;
    protected EventListeners bundleEvent;
    protected static final int BUNDLEEVENT = 1;
    protected EventListeners bundleEventSync;
    protected static final int BUNDLEEVENTSYNC = 2;
    protected EventListeners serviceEvent;
    protected static final int SERVICEEVENT = 3;
    protected EventListeners frameworkEvent;
    protected static final int FRAMEWORKEVENT = 4;
    protected EventManager eventManager;
    protected Hashtable installLock;
    protected SystemBundle systemBundle;
    protected AdminPermission adminPermission;
    protected static AliasMapper aliasMapper = new AliasMapper();

    public Framework(FrameworkAdaptor adaptor) {
        this.initialize(adaptor);
    }

    protected void initialize(FrameworkAdaptor adaptor) {
        long start = System.currentTimeMillis();
        this.adaptor = adaptor;
        this.active = false;
        this.installSecurityManager();
        if (Debug.DEBUG_SECURITY) {
            Debug.println("SecurityManager: " + System.getSecurityManager());
            Debug.println("ProtectionDomain of Framework.class: \n" + this.getClass().getProtectionDomain());
        }
        adaptor.initialize(this);
        try {
            adaptor.initializeStorage();
            adaptor.compactStorage();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        this.initializeProperties(adaptor.getProperties());
        this.packageAdmin = new PackageAdminImpl(this);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                this.permissionAdmin = new PermissionAdminImpl(this, adaptor.getPermissionStorage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        this.startLevelManager = new StartLevelManager(this);
        this.eventManager = new EventManager("Framework Event Dispatcher");
        this.bundleEvent = new EventListeners();
        this.bundleEventSync = new EventListeners();
        this.serviceEvent = new EventListeners();
        this.frameworkEvent = new EventListeners();
        this.serviceid = 1L;
        this.serviceRegistry = adaptor.getServiceRegistry();
        this.installLock = new Hashtable(10);
        this.createSystemBundle();
        URL.setURLStreamHandlerFactory(new StreamHandlerFactory(this.systemBundle.context, adaptor));
        URLConnection.setContentHandlerFactory(new ContentHandlerFactory(this.systemBundle.context));
        BundleData[] bundleDatas = adaptor.getInstalledBundles();
        this.bundles = new BundleRepository(bundleDatas == null ? 10 : bundleDatas.length + 1, this.packageAdmin);
        this.bundles.add(this.systemBundle);
        if (bundleDatas != null) {
            for (int i = 0; i < bundleDatas.length; ++i) {
                BundleData bundledata = bundleDatas[i];
                try {
                    AbstractBundle bundle = AbstractBundle.createBundle(bundledata, this);
                    this.bundles.add(bundle);
                    continue;
                }
                catch (BundleException be) {
                    this.publishFrameworkEvent(2, this.systemBundle, be);
                }
            }
        }
        this.packageAdmin.initialize();
        this.systemBundle.getBundleLoader();
        if (Debug.DEBUG_GENERAL) {
            System.out.println("Initialize the framework: " + (System.currentTimeMillis() - start));
        }
    }

    private void createSystemBundle() {
        try {
            this.systemBundle = new SystemBundle(this);
            BundleDescription newSystemBundle = this.adaptor.getPlatformAdmin().getFactory().createBundleDescription(this.systemBundle.getHeaders(""), "System Bundle", 0L);
            if (newSystemBundle == null) {
                throw new BundleException(Msg.formatter.getString("OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR"));
            }
            State state = this.adaptor.getState();
            BundleDescription oldSystemBundle = state.getBundle(0L);
            if (oldSystemBundle != null) {
                PackageSpecification[] newPackages;
                PackageSpecification[] oldPackages;
                boolean different = false;
                if (newSystemBundle.getVersion() != null && !newSystemBundle.getVersion().equals((Object)oldSystemBundle.getVersion())) {
                    different = true;
                }
                if ((oldPackages = oldSystemBundle.getPackages()).length == (newPackages = newSystemBundle.getPackages()).length) {
                    for (int i = 0; i < oldPackages.length; ++i) {
                        if (oldPackages[i].getName().equals(newPackages[i].getName())) {
                            Version oldVersion = oldPackages[i].getVersionRange().getMinimum();
                            Version newVersion = newPackages[i].getVersionRange().getMinimum();
                            if (oldVersion == null) {
                                if (newVersion == null) continue;
                                different = true;
                            } else {
                                if (oldVersion.equals(newVersion)) continue;
                                different = true;
                            }
                        } else {
                            different = true;
                        }
                        break;
                    }
                } else {
                    different = true;
                }
                if (different) {
                    state.removeBundle(0L);
                    state.addBundle(newSystemBundle);
                    state.resolve(false);
                }
            } else {
                state.addBundle(newSystemBundle);
                state.resolve(false);
            }
            SystemBundleLoader.clearSystemPackages();
            PackageSpecification[] packages = newSystemBundle.getPackages();
            if (packages != null) {
                String[] systemPackages = new String[packages.length];
                for (int i = 0; i < packages.length; ++i) {
                    String version;
                    PackageSpecification spec = packages[i];
                    if (spec.getName().equals("org.osgi.framework") && (version = spec.getVersionRange().getMinimum().toString()) != null) {
                        this.properties.put("org.osgi.framework.version", version);
                    }
                    systemPackages[i] = spec.getName();
                }
                if (System.getProperty("osgi.autoExportSystemPackages") != null) {
                    SystemBundleLoader.setSystemPackages(systemPackages);
                }
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
            throw new RuntimeException(Msg.formatter.getString("OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION", e.getMessage()));
        }
    }

    protected void initializeProperties(Properties adaptorProperties) {
        int ic;
        this.properties = System.getProperties();
        Enumeration<?> enumeration = adaptorProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (this.properties.getProperty(key) != null) continue;
            this.properties.put(key, adaptorProperties.getProperty(key));
        }
        this.properties.put("org.osgi.framework.vendor", "Eclipse");
        this.properties.put("org.osgi.framework.version", "1.3");
        this.properties.put("osgi.framework.version", "3.0.0");
        String value = this.properties.getProperty("org.osgi.framework.processor");
        if (value == null && (value = this.properties.getProperty("os.arch")) != null) {
            this.properties.put("org.osgi.framework.processor", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.os.name")) == null) {
            value = this.properties.getProperty("os.name");
            try {
                String canonicalValue = (String)aliasMapper.aliasOSName(value);
                if (canonicalValue != null) {
                    value = canonicalValue;
                }
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            if (value != null) {
                this.properties.put("org.osgi.framework.os.name", value);
            }
        }
        if ((value = this.properties.getProperty("org.osgi.framework.os.version")) == null && (value = this.properties.getProperty("os.version")) != null) {
            int space = value.indexOf(32);
            if (space > 0) {
                value = value.substring(0, space);
            }
            this.properties.put("org.osgi.framework.os.version", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.language")) == null && (value = this.properties.getProperty("user.language")) != null) {
            this.properties.put("org.osgi.framework.language", value);
            StringTokenizer tokenizer = new StringTokenizer(value, "_");
            int segments = tokenizer.countTokens();
            try {
                switch (segments) {
                    case 2: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                        break;
                    }
                    case 3: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                    }
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        value = this.properties.getProperty("org.osgi.framework.executionenvironment", "");
        String j2meConfig = this.properties.getProperty("microedition.configuration");
        String j2meProfile = this.properties.getProperty("microedition.profiles");
        StringBuffer ee = new StringBuffer(value);
        if (!(j2meConfig == null || j2meConfig.length() <= 0 || j2meProfile == null || j2meProfile.length() <= 0 || (ic = value.indexOf(j2meConfig)) >= 0 && ic + j2meConfig.length() < value.length() && value.charAt(ic + j2meConfig.length()) == '/' && value.startsWith(j2meProfile, ic + j2meConfig.length() + 1))) {
            if (ee.length() > 0) {
                ee.append(",");
            }
            ee.append(j2meConfig).append('/').append(j2meProfile);
        }
        this.properties.put("org.osgi.framework.executionenvironment", ee.toString());
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.active) {
            this.shutdown();
        }
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            for (int i = 0; i < size; ++i) {
                AbstractBundle bundle = (AbstractBundle)allBundles.get(i);
                bundle.close();
            }
            this.bundles.removeAllBundles();
        }
        this.serviceRegistry = null;
        if (this.bundleEvent != null) {
            this.bundleEvent.removeAllListeners();
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.bundleEventSync.removeAllListeners();
            this.bundleEventSync = null;
        }
        if (this.serviceEvent != null) {
            this.serviceEvent.removeAllListeners();
            this.serviceEvent = null;
        }
        if (this.frameworkEvent != null) {
            this.frameworkEvent.removeAllListeners();
            this.frameworkEvent = null;
        }
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        this.permissionAdmin = null;
        this.packageAdmin = null;
        this.adaptor = null;
    }

    public synchronized void launch() {
        if (this.active) {
            return;
        }
        this.active = true;
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to launch framework");
            }
            this.systemBundle.resume();
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Framework launch exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, this.systemBundle, be);
        }
    }

    public synchronized void shutdown() {
        if (!this.active) {
            return;
        }
        this.systemBundle.state = 16;
        try {
            this.adaptor.frameworkStopping(this.systemBundle.getContext());
        }
        catch (Throwable t) {
            this.publishFrameworkEvent(2, this.systemBundle, t);
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to shutdown Framework");
            }
            this.systemBundle.suspend();
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Framework shutdown exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, this.systemBundle, be);
        }
        try {
            this.adaptor.compactStorage();
        }
        catch (IOException e) {
            this.publishFrameworkEvent(2, this.systemBundle, e);
        }
        this.active = false;
    }

    public AbstractBundle createBundle(BundleData bundledata) throws BundleException {
        this.verifyExecutionEnvironment(bundledata.getManifest());
        return AbstractBundle.createBundle(bundledata, this);
    }

    protected boolean verifyExecutionEnvironment(Dictionary manifest) throws BundleException {
        int i;
        String headerValue = (String)manifest.get("Bundle-RequiredExecutionEnvironment");
        if (headerValue == null) {
            return true;
        }
        ManifestElement[] bundleRequiredEE = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", headerValue);
        if (bundleRequiredEE.length == 0) {
            return true;
        }
        String systemEE = System.getProperty("org.osgi.framework.executionenvironment");
        if (systemEE != null && !systemEE.equals("")) {
            ManifestElement[] systemEEs = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", systemEE);
            for (i = 0; i < systemEEs.length; ++i) {
                for (int j = 0; j < bundleRequiredEE.length; ++j) {
                    if (!systemEEs[i].getValue().equals(bundleRequiredEE[j].getValue())) continue;
                    return true;
                }
            }
        }
        StringBuffer bundleEE = new StringBuffer(25);
        for (i = 0; i < bundleRequiredEE.length; ++i) {
            if (i > 0) {
                bundleEE.append(",");
            }
            bundleEE.append(bundleRequiredEE[i]);
        }
        throw new BundleException(Msg.formatter.getString("BUNDLE_INSTALL_REQUIRED_EE_EXCEPTION", bundleEE.toString()));
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    protected String getProperty(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    protected Object setProperty(String key, String value) {
        return this.properties.put(key, value);
    }

    protected AbstractBundle installBundle(final String location) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from location: " + location);
        }
        return this.installWorker(location, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                URLConnection source = Framework.this.adaptor.mapLocationToURLConnection(location);
                return Framework.this.installWorkerPrivileged(location, source);
            }
        });
    }

    protected AbstractBundle installBundle(final String location, final InputStream in) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from inputstream: " + location + ", " + in);
        }
        return this.installWorker(location, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                BundleSource source = new BundleSource(in);
                return Framework.this.installWorkerPrivileged(location, source);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractBundle installWorker(String location, PrivilegedExceptionAction action) throws BundleException {
        block16: {
            var3_3 = this.installLock;
            synchronized (var3_3) lbl-1000:
            // 3 sources

            {
                while (true) {
                    bundle = this.getBundleByLocation(location);
                    if (bundle != null) {
                        return bundle;
                    }
                    current = Thread.currentThread();
                    reservation = this.installLock.put(location, current);
                    if (reservation != null) ** break block15
                    // MONITOREXIT @DISABLED, blocks:[5, 11] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    try {
                        bundle = (AbstractBundle)AccessController.doPrivileged(action);
                        this.publishBundleEvent(1, bundle);
                        var4_5 = bundle;
                        var10_9 = null;
                        var11_11 = this.installLock;
                        break block16;
                    }
                    catch (PrivilegedActionException e) {
                        throw (BundleException)e.getException();
                    }
                    break;
                }
            }
            catch (Throwable var9_13) {
                var10_10 = null;
                var11_12 = this.installLock;
                synchronized (var11_12) {
                    this.installLock.remove(location);
                    this.installLock.notifyAll();
                    throw var9_13;
                }
            }
            {
                if (current.equals(reservation)) {
                    throw new BundleException(Msg.formatter.getString("BUNDLE_INSTALL_RECURSION_EXCEPTION"));
                }
                try {
                    this.installLock.wait();
                }
                catch (InterruptedException e) {}
                ** continue;
            }
        }
        synchronized (var11_11) {
            this.installLock.remove(location);
            this.installLock.notifyAll();
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle installWorkerPrivileged(String location, URLConnection source) throws BundleException {
        AbstractBundle bundle;
        BundleOperation storage = this.adaptor.installBundle(location, source);
        try {
            AbstractBundle installedBundle;
            BundleData bundledata = storage.begin();
            if (bundledata.getSymbolicName() != null && (installedBundle = this.getBundleBySymbolicName(bundledata.getSymbolicName(), bundledata.getVersion().toString())) != null) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_INSTALL_SAME_UNIQUEID", new Object[]{installedBundle.getSymbolicName(), installedBundle.getVersion().toString(), installedBundle.getLocation()}));
            }
            bundle = this.createBundle(bundledata);
            try {
                String[] nativepaths = this.selectNativeCode(bundle);
                if (nativepaths != null) {
                    bundledata.installNativeCode(nativepaths);
                }
                bundle.load();
                storage.commit(false);
            }
            catch (BundleException be) {
                BundleRepository bundleRepository = this.bundles;
                synchronized (bundleRepository) {
                    bundle.unload();
                }
                bundle.close();
                throw be;
            }
            this.bundles.add(bundle);
        }
        catch (BundleException e) {
            try {
                storage.undo();
            }
            catch (BundleException ee) {
                this.publishFrameworkEvent(2, this.systemBundle, ee);
            }
            throw e;
        }
        return bundle;
    }

    public String[] selectNativeCode(Bundle bundle) throws BundleException {
        int i;
        Version osversion;
        String headerValue = (String)((AbstractBundle)bundle).getBundleData().getManifest().get("Bundle-NativeCode");
        if (headerValue == null) {
            return null;
        }
        ManifestElement[] elements = ManifestElement.parseHeader("Bundle-NativeCode", headerValue);
        BundleNativeCode[] bundleNativeCode = new BundleNativeCode[elements.length];
        String processor = this.getProperty("org.osgi.framework.processor");
        String osname = this.getProperty("org.osgi.framework.os.name");
        int length = elements.length;
        boolean optional = false;
        if (elements[length - 1].getValue().equals("*")) {
            optional = true;
            --length;
        }
        int[] score = new int[length];
        int matches = 0;
        int maxresult = 0;
        int index = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            int result;
            bundleNativeCode[i2] = new BundleNativeCode(elements[i2], (AbstractBundle)bundle);
            score[i2] = result = bundleNativeCode[i2].matchProcessorOSNameFilter(processor, osname);
            if (result <= 0) continue;
            ++matches;
            if (result <= maxresult) continue;
            maxresult = result;
            index = i2;
        }
        switch (matches) {
            case 0: {
                return this.noMatches(optional);
            }
            case 1: {
                return bundleNativeCode[index].getPaths();
            }
        }
        try {
            osversion = new Version(this.getProperty("org.osgi.framework.os.version"));
        }
        catch (Exception e) {
            osversion = Version.emptyVersion;
        }
        matches = 0;
        maxresult = 0;
        Version[] bestVersion = new Version[elements.length];
        Version maxVersion = Version.emptyVersion;
        for (i = 0; i < elements.length; ++i) {
            Version result;
            if (score[i] <= 0) continue;
            BundleNativeCode bnc = bundleNativeCode[i];
            bestVersion[i] = result = bnc.matchOSVersion(osversion);
            if (result == null) continue;
            ++matches;
            if (result.compareTo((Object)maxVersion) <= 0) continue;
            maxVersion = result;
            index = i;
        }
        switch (matches) {
            case 0: {
                return this.noMatches(optional);
            }
            case 1: {
                return bundleNativeCode[index].getPaths();
            }
        }
        for (i = 0; i < elements.length; ++i) {
            Version result = bestVersion[i];
            if (result.compareTo((Object)maxVersion) >= 0) continue;
            score[i] = 0;
        }
        String language = this.getProperty("org.osgi.framework.language");
        matches = 0;
        maxresult = 0;
        for (int i3 = 0; i3 < elements.length; ++i3) {
            int result = score[i3];
            if (result <= 0) continue;
            BundleNativeCode bnc = bundleNativeCode[i3];
            score[i3] = result = bnc.matchLanguage(language);
            if (result <= 0) continue;
            ++matches;
            if (result <= maxresult) continue;
            maxresult = result;
            index = i3;
        }
        switch (matches) {
            case 0: {
                return this.noMatches(optional);
            }
        }
        return bundleNativeCode[index].getPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundle(long id) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle getBundleBySymbolicName(String symbolicName, String version) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(symbolicName, version);
        }
    }

    protected BundleRepository getBundles() {
        return this.bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getAllBundles() {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            if (size == 0) {
                return null;
            }
            AbstractBundle[] bundlelist = new AbstractBundle[size];
            allBundles.toArray(bundlelist);
            return bundlelist;
        }
    }

    protected void resumeBundle(AbstractBundle bundle) {
        if (bundle.isActive()) {
            return;
        }
        try {
            int status = bundle.getBundleData().getStatus();
            if ((status & 1) == 0) {
                return;
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to start bundle " + bundle);
            }
            bundle.resume();
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle resume exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, bundle, be);
        }
    }

    protected boolean suspendBundle(AbstractBundle bundle, boolean lock) {
        boolean changed = false;
        if (!bundle.isActive() || bundle.isFragment()) {
            return changed;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to suspend bundle " + bundle);
            }
            bundle.suspend(lock);
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle suspend exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, bundle, be);
        }
        if (!bundle.isActive()) {
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle getBundleByLocation(String location) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            for (int i = 0; i < size; ++i) {
                AbstractBundle bundle = (AbstractBundle)allBundles.get(i);
                if (!location.equals(bundle.getLocation())) continue;
                return bundle;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getBundleBySymbolicName(String symbolicName) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundles(symbolicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference[] getServiceReferences(String clazz, String filterstring) throws InvalidSyntaxException {
        FilterImpl filter = filterstring == null ? null : new FilterImpl(filterstring);
        ServiceReference[] services = null;
        if (clazz != null) {
            try {
                this.checkGetServicePermission(clazz);
            }
            catch (SecurityException se) {
                return null;
            }
        }
        ServiceRegistry serviceRegistry = this.serviceRegistry;
        synchronized (serviceRegistry) {
            services = this.serviceRegistry.lookupServiceReferences(clazz, filter);
            if (services == null) {
                return null;
            }
            if (clazz == null) {
                int removed = 0;
                for (int i = services.length - 1; i >= 0; --i) {
                    ServiceReferenceImpl ref = (ServiceReferenceImpl)services[i];
                    String[] classes = ref.getClasses();
                    try {
                        this.checkGetServicePermission(classes);
                        continue;
                    }
                    catch (SecurityException se) {
                        services[i] = null;
                        ++removed;
                    }
                }
                if (removed > 0) {
                    ServiceReference[] temp = services;
                    services = new ServiceReference[temp.length - removed];
                    for (int i = temp.length - 1; i >= 0; --i) {
                        if (temp[i] == null) {
                            --removed;
                            continue;
                        }
                        services[i - removed] = temp[i];
                    }
                }
            }
        }
        return services;
    }

    protected long getNextServiceId() {
        long id = this.serviceid++;
        return id;
    }

    protected File getDataFile(final AbstractBundle bundle, final String filename) {
        return (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundle.getBundleData().getDataFile(filename);
            }
        });
    }

    protected void checkAdminPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.adminPermission == null) {
                this.adminPermission = new AdminPermission();
            }
            sm.checkPermission((Permission)this.adminPermission);
        }
    }

    protected void checkRegisterServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                sm.checkPermission((Permission)new ServicePermission(names[i], "register"));
            }
        }
    }

    protected void checkGetServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SecurityException se = null;
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                try {
                    sm.checkPermission((Permission)new ServicePermission(names[i], "get"));
                    return;
                }
                catch (SecurityException e) {
                    se = e;
                    continue;
                }
            }
            throw se;
        }
    }

    protected void checkGetServicePermission(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new ServicePermission(name, "get"));
        }
    }

    protected void installSecurityManager() {
        SecurityManager sm;
        String securityManager = System.getProperty("java.security.manager");
        if (securityManager != null && (sm = System.getSecurityManager()) == null) {
            if (securityManager.length() < 1) {
                securityManager = "java.lang.SecurityManager";
            }
            try {
                Class<?> clazz = Class.forName(securityManager);
                sm = (SecurityManager)clazz.newInstance();
                if (Debug.DEBUG_SECURITY) {
                    Debug.println("Setting SecurityManager to: " + sm);
                }
                System.setSecurityManager(sm);
                return;
            }
            catch (ClassNotFoundException e) {
            }
            catch (ClassCastException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new NoClassDefFoundError(securityManager);
        }
    }

    public void publishFrameworkEvent(int type, Bundle bundle, Throwable throwable) {
        if (this.frameworkEvent != null) {
            final FrameworkEvent event = new FrameworkEvent(type, bundle, throwable);
            if (System.getSecurityManager() == null) {
                this.publishFrameworkEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishFrameworkEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFrameworkEventPrivileged(FrameworkEvent event) {
        FrameworkLog frameworkLog;
        if (event.getType() == 2 && (frameworkLog = this.adaptor.getFrameworkLog()) != null) {
            frameworkLog.log(event);
        }
        ListenerQueue listeners = new ListenerQueue(this.eventManager);
        ListenerQueue contexts = new ListenerQueue(this.eventManager);
        EventListeners eventListeners = this.frameworkEvent;
        synchronized (eventListeners) {
            contexts.queueListeners(this.frameworkEvent, this);
            contexts.dispatchEventSynchronous(4, listeners);
        }
        listeners.dispatchEventAsynchronous(4, event);
    }

    public void publishBundleEvent(int type, Bundle bundle) {
        if (this.bundleEventSync != null || this.bundleEvent != null) {
            final BundleEvent event = new BundleEvent(type, bundle);
            if (System.getSecurityManager() == null) {
                this.publishBundleEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishBundleEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBundleEventPrivileged(BundleEvent event) {
        ListenerQueue listenersSync = null;
        if (this.bundleEventSync != null) {
            listenersSync = new ListenerQueue(this.eventManager);
            ListenerQueue contexts = new ListenerQueue(this.eventManager);
            EventListeners eventListeners = this.bundleEventSync;
            synchronized (eventListeners) {
                contexts.queueListeners(this.bundleEventSync, this);
                contexts.dispatchEventSynchronous(2, listenersSync);
            }
        }
        ListenerQueue listenersAsync = null;
        if (this.bundleEvent != null) {
            listenersAsync = new ListenerQueue(this.eventManager);
            ListenerQueue contexts = new ListenerQueue(this.eventManager);
            EventListeners eventListeners = this.bundleEvent;
            synchronized (eventListeners) {
                contexts.queueListeners(this.bundleEvent, this);
                contexts.dispatchEventSynchronous(1, listenersAsync);
            }
        }
        if (listenersSync != null) {
            listenersSync.dispatchEventSynchronous(2, event);
        }
        if (listenersAsync != null) {
            listenersAsync.dispatchEventAsynchronous(1, event);
        }
    }

    public void publishServiceEvent(int type, ServiceReference reference) {
        if (this.serviceEvent != null) {
            final ServiceEvent event = new ServiceEvent(type, reference);
            if (System.getSecurityManager() == null) {
                this.publishServiceEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishServiceEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishServiceEventPrivileged(ServiceEvent event) {
        ListenerQueue listeners = new ListenerQueue(this.eventManager);
        ListenerQueue contexts = new ListenerQueue(this.eventManager);
        EventListeners eventListeners = this.serviceEvent;
        synchronized (eventListeners) {
            contexts.queueListeners(this.serviceEvent, this);
            contexts.dispatchEventSynchronous(3, listeners);
        }
        listeners.dispatchEventSynchronous(3, event);
    }

    public void dispatchEvent(Object l, Object lo, int action, Object object) {
        block10: {
            try {
                BundleContextImpl context = (BundleContextImpl)l;
                if (context.isValid()) {
                    ListenerQueue queue = (ListenerQueue)object;
                    switch (action) {
                        case 1: {
                            queue.queueListeners(context.bundleEvent, context);
                            break;
                        }
                        case 2: {
                            queue.queueListeners(context.bundleEventSync, context);
                            break;
                        }
                        case 3: {
                            queue.queueListeners(context.serviceEvent, context);
                            break;
                        }
                        case 4: {
                            queue.queueListeners(context.frameworkEvent, context);
                        }
                    }
                }
            }
            catch (Throwable t) {
                FrameworkEvent event;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in Top level event dispatcher: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                this.adaptor.handleRuntimeError(t);
                if (action == 4 && (event = (FrameworkEvent)object).getType() == 2) break block10;
                BundleContextImpl context = (BundleContextImpl)l;
                this.publishFrameworkEvent(2, context.bundle, t);
            }
        }
    }

    private String[] noMatches(boolean optional) throws BundleException {
        if (optional) {
            return null;
        }
        throw new BundleException(Msg.formatter.getString("BUNDLE_NATIVECODE_MATCH_EXCEPTION"));
    }
}

