/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.internal.ui.sourcelookup.SourceContainerViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public abstract class SourceContainerAction
extends SelectionListenerAction {
    private SourceContainerViewer fViewer;
    private Button fButton;
    private Shell fShell;

    public SourceContainerAction(String label) {
        super(label);
    }

    public void setViewer(SourceContainerViewer viewer) {
        if (this.fViewer != null) {
            this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fViewer = viewer;
        if (this.fViewer != null) {
            this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.update();
        }
    }

    protected SourceContainerViewer getViewer() {
        return this.fViewer;
    }

    protected List getOrderedSelection() {
        ArrayList<ISourceContainer> targets = new ArrayList<ISourceContainer>();
        List selection = ((IStructuredSelection)this.getViewer().getSelection()).toList();
        ISourceContainer[] entries = this.getViewer().getEntries();
        for (int i = 0; i < entries.length; ++i) {
            ISourceContainer target = entries[i];
            if (!selection.contains(target)) continue;
            targets.add(target);
        }
        return targets;
    }

    protected List getEntriesAsList() {
        ISourceContainer[] entries = this.getViewer().getEntries();
        ArrayList<ISourceContainer> list = new ArrayList<ISourceContainer>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            list.add(entries[i]);
        }
        return list;
    }

    protected void setEntries(List list) {
        this.getViewer().setEntries(list.toArray(new ISourceContainer[list.size()]));
        this.getViewer().setSelection(this.getViewer().getSelection());
    }

    protected boolean isIndexSelected(IStructuredSelection selection, int index) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator entries = selection.iterator();
        List list = this.getEntriesAsList();
        while (entries.hasNext()) {
            Object next = entries.next();
            if (list.indexOf(next) != index) continue;
            return true;
        }
        return false;
    }

    public void setButton(Button button) {
        this.fButton = button;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SourceContainerAction.this.run();
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.fButton != null) {
            this.fButton.setEnabled(enabled);
        }
    }

    protected void update() {
        this.selectionChanged((IStructuredSelection)this.getViewer().getSelection());
    }

    protected Shell getShell() {
        if (this.fShell == null) {
            this.fShell = this.getViewer().getControl().getShell();
        }
        return this.fShell;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }
}

