/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class ExecutionAction
implements IActionDelegate2 {
    private String fLaunchGroupIdentifier;

    public ExecutionAction(String launchGroupIdentifier) {
        this.fLaunchGroupIdentifier = launchGroupIdentifier;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    private void openLaunchConfigurationDialog() {
        IWorkbenchWindow dwindow = DebugUIPlugin.getActiveWorkbenchWindow();
        if (dwindow == null) {
            return;
        }
        LaunchConfigurationsDialog dialog = new LaunchConfigurationsDialog(DebugUIPlugin.getShell(), this.getLaunchConfigurationManager().getLaunchGroup(this.fLaunchGroupIdentifier));
        dialog.open();
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    protected abstract String getMode();

    public void dispose() {
    }

    public void init(IAction action) {
    }

    public void run(IAction action) {
        ILaunchConfiguration configuration = this.getLaunchConfigurationManager().getLastLaunch(this.fLaunchGroupIdentifier);
        if (configuration == null) {
            this.openLaunchConfigurationDialog();
        } else {
            DebugUITools.launch(configuration, this.getMode());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

