/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class DisplayAction
extends EvaluateAction {
    protected void displayResult(final IEvaluationResult evaluationResult) {
        if (evaluationResult.hasErrors()) {
            final Display display = JDIDebugUIPlugin.getStandardDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    DisplayAction.this.reportErrors(evaluationResult);
                    DisplayAction.this.evaluationCleanup();
                }
            });
            return;
        }
        final String snippet = evaluationResult.getSnippet();
        IJavaValue resultValue = evaluationResult.getValue();
        try {
            String sig = null;
            IJavaType type = resultValue.getJavaType();
            if (type != null) {
                sig = type.getSignature();
            }
            if ("V".equals(sig)) {
                this.displayStringResult(snippet, ActionMessages.getString("DisplayAction.no_result_value"));
            } else {
                final String resultString = sig != null ? MessageFormat.format(ActionMessages.getString("DisplayAction.type_name_pattern"), resultValue.getReferenceTypeName()) : "";
                this.getDebugModelPresentation().computeDetail((IValue)resultValue, new IValueDetailListener(){

                    public void detailComputed(IValue value, String result) {
                        DisplayAction.this.displayStringResult(snippet, MessageFormat.format(ActionMessages.getString("DisplayAction.result_pattern"), resultString, result));
                    }
                });
            }
        }
        catch (DebugException x) {
            this.displayStringResult(snippet, this.getExceptionMessage(x));
        }
    }

    protected void displayStringResult(final String snippet, final String resultString) {
        final IDataDisplay directDisplay = this.getDirectDataDisplay();
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                IDataDisplay dataDisplay;
                if (!display.isDisposed() && (dataDisplay = DisplayAction.this.getDataDisplay()) != null) {
                    if (directDisplay == null) {
                        dataDisplay.displayExpression(snippet);
                    }
                    dataDisplay.displayExpressionValue(resultString);
                }
                DisplayAction.this.evaluationCleanup();
            }
        });
    }

    protected void run() {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof JavaSnippetEditor) {
            ((JavaSnippetEditor)part).evalSelection(1);
            return;
        }
        super.run();
    }
}

