/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RenameJavaElementAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public RenameJavaElementAction(IWorkbenchSite site) {
        super(site);
    }

    public RenameJavaElementAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RenameJavaElementAction.canEnable(selection));
            return;
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection selection) throws CoreException {
        IJavaElement element = RenameJavaElementAction.getJavaElement(selection);
        if (element == null) {
            return false;
        }
        RenameSupport support = RenameJavaElementAction.createGeneric(element, null, 1);
        return support != null && support.preCheck().isOK();
    }

    private static IJavaElement getJavaElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IJavaElement)) {
            return null;
        }
        return (IJavaElement)first;
    }

    public void run(IStructuredSelection selection) {
        IJavaElement element = RenameJavaElementAction.getJavaElement(selection);
        if (element == null) {
            return;
        }
        try {
            this.run(element, null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("RenameJavaElementAction.name"), RefactoringMessages.getString("RenameJavaElementAction.exception"));
        }
    }

    public void selectionChanged(ITextSelection selection) {
        block5: {
            if (selection instanceof JavaTextSelection) {
                try {
                    IJavaElement[] elements = ((JavaTextSelection)selection).resolveElementAtOffset();
                    if (elements.length == 1) {
                        RenameSupport support = RenameJavaElementAction.createGeneric(elements[0], null, 1);
                        this.setEnabled(support != null && support.preCheck().isOK());
                        break block5;
                    }
                    this.setEnabled(false);
                }
                catch (CoreException e) {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(true);
            }
        }
    }

    public void run(ITextSelection selection) {
        try {
            RenameSupport support;
            IJavaElement element = this.getJavaElement();
            if (element != null && (support = RenameJavaElementAction.createGeneric(element, null, 1)) != null && support.preCheck().isOK()) {
                this.run(element, support);
                return;
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("RenameJavaElementAction.name"), RefactoringMessages.getString("RenameJavaElementAction.exception"));
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.getString("RenameJavaElementAction.name"), (String)RefactoringMessages.getString("RenameJavaElementAction.not_available"));
    }

    public boolean canRun() {
        IJavaElement element = this.getJavaElement();
        if (element == null) {
            return false;
        }
        try {
            RenameSupport support = RenameJavaElementAction.createGeneric(element, null, 1);
            return support != null && support.preCheck().isOK();
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private IJavaElement getJavaElement() {
        IJavaElement[] elements = SelectionConverter.codeResolveHandled(this.fEditor, this.getShell(), RefactoringMessages.getString("RenameJavaElementAction.name"));
        if (elements == null || elements.length != 1) {
            return null;
        }
        return elements[0];
    }

    private void run(IJavaElement element, RenameSupport support) throws CoreException {
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        if (ActionUtil.mustDisableJavaModelAction(this.getShell(), element)) {
            return;
        }
        if (!(support != null || (support = RenameJavaElementAction.createGeneric(element, null, 1)) != null && support.preCheck().isOK())) {
            return;
        }
        support.openDialog(this.getShell());
    }

    private static RenameSupport createGeneric(IJavaElement element, String newName, int flags) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RenameSupport.create((IJavaProject)element, newName, flags);
            }
            case 3: {
                return RenameSupport.create((IPackageFragmentRoot)element, newName);
            }
            case 4: {
                return RenameSupport.create((IPackageFragment)element, newName, flags);
            }
            case 5: {
                return RenameSupport.create((ICompilationUnit)element, newName, flags);
            }
            case 7: {
                return RenameSupport.create((IType)element, newName, flags);
            }
            case 9: {
                return RenameSupport.create((IMethod)element, newName, flags);
            }
            case 8: {
                return RenameSupport.create((IField)element, newName, flags);
            }
        }
        return null;
    }
}

