/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.ssh.SSHServerConnection;
import org.eclipse.team.internal.ccvs.ssh2.JSchSession;
import org.eclipse.team.internal.ccvs.ssh2.Policy;
import org.eclipse.team.internal.core.streams.PollingInputStream;
import org.eclipse.team.internal.core.streams.PollingOutputStream;
import org.eclipse.team.internal.core.streams.TimeoutInputStream;
import org.eclipse.team.internal.core.streams.TimeoutOutputStream;

public class CVSSSH2ServerConnection
implements IServerConnection {
    private static final String COMMAND = "cvs server";
    private ICVSRepositoryLocation location;
    private String password;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Session session;
    private Channel channel;
    private IServerConnection ssh1;

    protected CVSSSH2ServerConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object v1;
        if (this.ssh1 != null) {
            this.ssh1.close();
            this.ssh1 = null;
            return;
        }
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                }
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var3_3 = null;
            try {
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9;
                v0 = var6_9 = null;
            }
            if (this.channel != null) {
                this.channel.disconnect();
            }
            throw throwable;
        }
        try {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var6_8;
            v1 = var6_8 = null;
        }
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    public InputStream getInputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getInputStream();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getOutputStream();
        }
        return this.outputStream;
    }

    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        if (this.ssh1 != null) {
            this.ssh1.open(monitor);
            return;
        }
        monitor.subTask(Policy.bind("CVSSSH2ServerConnection.open", this.location.getHost()));
        monitor.worked(1);
        this.internalOpen(monitor);
    }

    private void internalOpen(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        try {
            InputStream channel_in;
            OutputStream channel_out;
            String hostname = this.location.getHost();
            String username = this.location.getUsername();
            int port = this.location.getPort();
            if (port == 0) {
                port = 0;
            }
            int retry = 1;
            while (true) {
                this.session = JSchSession.getSession(this.location, username, this.password, hostname, port, new JSchSession.ResponsiveSocketFacory(monitor));
                this.channel = this.session.openChannel("exec");
                ((ChannelExec)this.channel).setCommand(COMMAND);
                channel_out = this.channel.getOutputStream();
                channel_in = this.channel.getInputStream();
                try {
                    this.channel.connect();
                }
                catch (JSchException ee) {
                    if (--retry < 0) {
                        throw new CVSAuthenticationException(Policy.bind("CVSSSH2ServerConnection.3"), 2);
                    }
                    if (!this.session.isConnected()) continue;
                    this.session.disconnect();
                    continue;
                }
                break;
            }
            int timeout = this.location.getTimeout();
            this.inputStream = new PollingInputStream((InputStream)new TimeoutInputStream((InputStream)new FilterInputStream(channel_in){

                public void close() throws IOException {
                }
            }, 8192, 1000L, -1L, true), timeout > 0 ? timeout : 1, monitor);
            this.outputStream = new PollingOutputStream((OutputStream)new TimeoutOutputStream((OutputStream)new FilterOutputStream(channel_out){

                public void close() throws IOException {
                }
            }, 8192, 1000L, 1000L), timeout > 0 ? timeout : 1, monitor);
        }
        catch (JSchException e) {
            if (e.toString().indexOf("invalid server's version string") == -1) {
                throw new CVSAuthenticationException(e.toString(), 2);
            }
            this.ssh1 = new SSHServerConnection(this.location, this.password);
            if (this.ssh1 == null) {
                throw new CVSAuthenticationException(e.toString(), 2);
            }
            this.ssh1.open(monitor);
        }
    }
}

