/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlockRetrieval;
import org.eclipse.debug.internal.core.memory.MemoryBlockManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IMemoryView;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.MonitorMemoryBlockDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class AddMemoryBlockAction
extends Action
implements ISelectionListener,
IDebugEventSetListener {
    private static String PREFIX = "AddMemoryBlockAction.";
    private static String TITLE = PREFIX + "title";
    private static String TOOLTIP = PREFIX + "tooltip";
    private static String FAILED = PREFIX + "failed";
    private static String EXPR_EVAL_FAILED = PREFIX + "expressionEvalFailed";
    private static String NO_MEMORY_BLOCK = PREFIX + "noMemoryBlock";
    protected ISelection currentSelection = null;
    protected IMemoryBlock fLastMemoryBlock;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IMemoryBlockRetrieval;

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public AddMemoryBlockAction() {
        ISelection selection;
        this.setText(DebugUIMessages.getString(TITLE));
        this.setToolTipText(DebugUIMessages.getString(TOOLTIP));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_MONITOR_EXPRESSION"));
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.currentSelection = selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        this.setEnabled(MemoryViewUtil.isValidSelection(selection));
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public AddMemoryBlockAction(String text, int style) {
        super(text, style);
        ISelection selection;
        this.setToolTipText(DebugUIMessages.getString(TOOLTIP));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_MONITOR_EXPRESSION"));
        DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.currentSelection = selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        this.setEnabled(MemoryViewUtil.isValidSelection(selection));
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void run() {
        ISelection selection = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (!(elem instanceof IDebugElement)) {
            return;
        }
        IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
        IMemoryBlockRetrieval standardMemRetrieval = (IMemoryBlockRetrieval)((IDebugElement)elem).getAdapter(class$org$eclipse$debug$core$model$IMemoryBlockRetrieval == null ? (class$org$eclipse$debug$core$model$IMemoryBlockRetrieval = AddMemoryBlockAction.class$("org.eclipse.debug.core.model.IMemoryBlockRetrieval")) : class$org$eclipse$debug$core$model$IMemoryBlockRetrieval);
        if (standardMemRetrieval == null) {
            standardMemRetrieval = debugTarget;
        }
        Shell shell = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        MonitorMemoryBlockDialog dialog = new MonitorMemoryBlockDialog(shell, standardMemRetrieval);
        dialog.open();
        int returnCode = dialog.getReturnCode();
        if (returnCode == 1) {
            return;
        }
        String expression = dialog.getExpression();
        try {
            if (standardMemRetrieval instanceof IExtendedMemoryBlockRetrieval) {
                IExtendedMemoryBlockRetrieval memRetrieval = (IExtendedMemoryBlockRetrieval)standardMemRetrieval;
                IExtendedMemoryBlock memBlock = memRetrieval.getExtendedMemoryBlock(expression, (IDebugElement)elem);
                if (memBlock != null) {
                    this.fLastMemoryBlock = memBlock;
                    MemoryBlockManager.getMemoryBlockManager().addMemoryBlock((IMemoryBlock)memBlock, true);
                    this.switchMemoryBlockToTop(this.fLastMemoryBlock);
                } else {
                    MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), DebugUIMessages.getString(NO_MEMORY_BLOCK), null);
                }
            } else {
                String hexPrefix;
                if ((expression = expression.toUpperCase()).startsWith(hexPrefix = "0X")) {
                    expression = expression.substring(hexPrefix.length());
                }
                BigInteger address = new BigInteger(expression, 16);
                long longAddress = address.longValue();
                String strLength = dialog.getLength();
                long length = Long.parseLong(strLength);
                if (length == 0L) {
                    length = 16L;
                }
                while (length % 16L != 0L) {
                    ++length;
                }
                IMemoryBlock memBlock = standardMemRetrieval.getMemoryBlock(longAddress, length);
                if (memBlock instanceof IExtendedMemoryBlock) {
                    Status status = new Status(2, DebugUIPlugin.getUniqueIdentifier(), 0, "IMemoryBlockRetrieval returns IExtendedMemoryBlock.  This may result in unexpected behavior.", null);
                    DebugUIPlugin.log((IStatus)status);
                }
                if (memBlock != null) {
                    this.fLastMemoryBlock = memBlock;
                    MemoryBlockManager.getMemoryBlockManager().addMemoryBlock(memBlock, true);
                    this.switchMemoryBlockToTop(this.fLastMemoryBlock);
                } else {
                    MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), DebugUIMessages.getString(NO_MEMORY_BLOCK), null);
                }
            }
        }
        catch (DebugException e1) {
            MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), DebugUIMessages.getString(FAILED), (Exception)((Object)e1));
        }
        catch (NumberFormatException e2) {
            String message = DebugUIMessages.getString(FAILED) + "\n" + DebugUIMessages.getString(EXPR_EVAL_FAILED);
            MemoryViewUtil.openError(DebugUIMessages.getString(TITLE), message, null);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setEnabled(MemoryViewUtil.isValidSelection(selection));
        this.currentSelection = selection;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            this.handleDebugEvent(events[i]);
        }
    }

    private void handleDebugEvent(DebugEvent event) {
        Object src = event.getSource();
        IDebugTarget srcDT = null;
        IDebugTarget selectionDT = null;
        if (event.getKind() == 8) {
            Object elem;
            if (src instanceof ITerminate && src instanceof IDebugElement) {
                srcDT = ((IDebugElement)src).getDebugTarget();
            }
            if (this.currentSelection instanceof IStructuredSelection && (elem = ((IStructuredSelection)this.currentSelection).getFirstElement()) instanceof IDebugElement) {
                selectionDT = ((IDebugElement)elem).getDebugTarget();
            }
            if (srcDT == selectionDT) {
                this.setEnabled(false);
            }
        }
    }

    public IMemoryBlock getLastMemoryBlock() {
        return this.fLastMemoryBlock;
    }

    private void switchMemoryBlockToTop(IMemoryBlock memoryBlock) {
        IMemoryViewTab topTap;
        IWorkbenchPage p = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (p == null) {
            return;
        }
        IViewPart view = null;
        view = p.findView("org.eclipse.debug.ui.MemoryView");
        if (view == null) {
            try {
                IWorkbenchPart activePart = p.getActivePart();
                view = (MemoryView)p.showView("org.eclipse.debug.ui.MemoryView");
                p.activate(activePart);
            }
            catch (PartInitException e) {
                return;
            }
        }
        if (view instanceof IMemoryView && (topTap = ((IMemoryView)view).getTopMemoryTab()).getMemoryBlock() != memoryBlock) {
            IMemoryViewTab[] allTabs = ((IMemoryView)view).getAllViewTabs();
            IMemoryViewTab moveToTop = null;
            for (int i = 0; i < allTabs.length; ++i) {
                if (allTabs[i].getMemoryBlock() != memoryBlock) continue;
                moveToTop = allTabs[i];
                break;
            }
            if (moveToTop != null) {
                ((IMemoryView)view).moveToTop(moveToTop);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

