/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDebugEventHandler
implements IDebugEventSetListener {
    private AbstractDebugView fView;

    public AbstractDebugEventHandler(AbstractDebugView view) {
        this.setView(view);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    protected IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public void handleDebugEvents(final DebugEvent[] events) {
        if (!this.isAvailable()) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (AbstractDebugEventHandler.this.isAvailable()) {
                    if (AbstractDebugEventHandler.this.isViewVisible()) {
                        AbstractDebugEventHandler.this.doHandleDebugEvents(events);
                    }
                    AbstractDebugEventHandler.this.updateForDebugEvents(events);
                }
            }
        };
        this.getView().asyncExec(r);
    }

    protected void updateForDebugEvents(DebugEvent[] events) {
    }

    protected abstract void doHandleDebugEvents(DebugEvent[] var1);

    protected void insert(Object element) {
        Object parent;
        if (this.isAvailable() && (parent = ((ITreeContentProvider)this.getTreeViewer().getContentProvider()).getParent(element)) != null) {
            this.getView().showViewer();
            this.getTreeViewer().add(parent, element);
        }
    }

    protected void remove(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().remove(element);
        }
    }

    protected void labelChanged(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().update(element, new String[]{"org.eclipse.jface.text"});
        }
    }

    protected void refresh(Object element) {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().refresh(element);
        }
    }

    public void refresh() {
        if (this.isAvailable()) {
            this.getView().showViewer();
            this.getTreeViewer().refresh();
        }
    }

    protected void selectAndReveal(Object element) {
        if (this.isAvailable()) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(element), true);
        }
    }

    public void dispose() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.removeDebugEventListener((IDebugEventSetListener)this);
    }

    protected AbstractDebugView getView() {
        return this.fView;
    }

    private void setView(AbstractDebugView view) {
        this.fView = view;
    }

    protected Viewer getViewer() {
        return this.getView().getViewer();
    }

    protected TreeViewer getTreeViewer() {
        if (this.getViewer() instanceof TreeViewer) {
            return (TreeViewer)this.getViewer();
        }
        return null;
    }

    protected boolean isAvailable() {
        return this.getView().isAvailable();
    }

    protected boolean isViewVisible() {
        return this.getView().isVisible();
    }

    protected void viewBecomesVisible() {
        this.refresh();
    }

    protected void viewBecomesHidden() {
    }
}

