/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.MultiOperation;
import org.eclipse.jdt.internal.core.util.Util;

public class DeleteResourceElementsOperation
extends MultiOperation {
    protected DeleteResourceElementsOperation(IJavaElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    private void deletePackageFragment(IPackageFragment frag) throws JavaModelException {
        IResource res = frag.getResource();
        if (res != null) {
            IResource fragResource;
            IResource[] remainingFiles;
            IJavaElement[] childrenOfInterest = frag.getChildren();
            if (childrenOfInterest.length > 0) {
                IResource[] resources = new IResource[childrenOfInterest.length];
                for (int i = 0; i < childrenOfInterest.length; ++i) {
                    resources[i] = childrenOfInterest[i].getCorrespondingResource();
                }
                this.deleteResources(resources, this.force);
            }
            Object[] nonJavaResources = frag.getNonJavaResources();
            int actualResourceCount = 0;
            int max = nonJavaResources.length;
            for (int i = 0; i < max; ++i) {
                if (!(nonJavaResources[i] instanceof IResource)) continue;
                ++actualResourceCount;
            }
            IResource[] actualNonJavaResources = new IResource[actualResourceCount];
            int max2 = nonJavaResources.length;
            int index = 0;
            for (int i = 0; i < max2; ++i) {
                if (!(nonJavaResources[i] instanceof IResource)) continue;
                actualNonJavaResources[index++] = (IResource)nonJavaResources[i];
            }
            this.deleteResources(actualNonJavaResources, this.force);
            try {
                remainingFiles = ((IContainer)res).members();
            }
            catch (CoreException ce) {
                throw new JavaModelException(ce);
            }
            boolean isEmpty = true;
            int length = remainingFiles.length;
            for (int i = 0; i < length; ++i) {
                IResource file = remainingFiles[i];
                if (file instanceof IFile && org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(file.getName())) {
                    this.deleteResource(file, 3);
                    continue;
                }
                isEmpty = false;
            }
            if (isEmpty && !frag.isDefaultPackage() && (fragResource = frag.getResource()) != null) {
                this.deleteEmptyPackageFragment(frag, false, (IResource)fragResource.getParent());
            }
        }
    }

    protected String getMainTaskName() {
        return Util.bind("operation.deleteResourceProgress");
    }

    protected void processElement(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 5: 
            case 6: {
                this.deleteResource(element.getResource(), this.force ? 3 : 2);
                break;
            }
            case 4: {
                this.deletePackageFragment((IPackageFragment)element);
                break;
            }
            default: {
                throw new JavaModelException(new JavaModelStatus(967, element));
            }
        }
        if (element instanceof IOpenable) {
            ((IOpenable)((Object)element)).close();
        }
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        int type;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if ((type = element.getElementType()) <= 3 || type > 5) {
            this.error(967, element);
        } else if (type == 4 && element instanceof JarPackageFragment) {
            this.error(967, element);
        }
        IResource resource = element.getResource();
        if (resource instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
    }
}

