/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class JavaPreview {
    protected final JavaSourceViewerConfiguration fViewerConfiguration;
    protected final Document fPreviewDocument;
    protected final SourceViewer fSourceViewer;
    protected final IPreferenceStore fPreferenceStore;
    protected final MarginPainter fMarginPainter;
    protected Map fWorkingValues;
    private int fTabSize = 0;

    public JavaPreview(Map workingValues, Composite parent) {
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        this.fPreviewDocument = new Document();
        this.fWorkingValues = workingValues;
        tools.setupJavaDocumentPartitioner((IDocument)this.fPreviewDocument, "___java_partitioning");
        this.fPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fSourceViewer = new JavaSourceViewer(parent, null, null, false, 2824, this.fPreferenceStore);
        this.fViewerConfiguration = new JavaSourceViewerConfiguration(tools.getColorManager(), this.fPreferenceStore, null, "___java_partitioning");
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fSourceViewer);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
        this.fMarginPainter.setMarginRulerColor(tools.getColorManager().getColor(rgb));
        this.fSourceViewer.addPainter((IPainter)this.fMarginPainter);
        new JavaSourcePreviewerUpdater();
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void update() {
        if (this.fWorkingValues == null) {
            this.fPreviewDocument.set("");
            return;
        }
        String value = (String)this.fWorkingValues.get("org.eclipse.jdt.core.formatter.lineSplit");
        int lineWidth = JavaPreview.getPositiveIntValue(value, 0);
        this.fMarginPainter.setMarginRulerColumn(lineWidth);
        int tabSize = JavaPreview.getPositiveIntValue((String)this.fWorkingValues.get("org.eclipse.jdt.core.formatter.tabulation.size"), 0);
        if (tabSize != this.fTabSize) {
            this.fSourceViewer.getTextWidget().setTabs(tabSize);
        }
        this.fTabSize = tabSize;
        StyledText widget = (StyledText)this.fSourceViewer.getControl();
        int height = widget.getClientArea().height;
        int top0 = widget.getTopPixel();
        int totalPixels0 = widget.getLineCount() * widget.getLineHeight();
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        widget.setRedraw(false);
        this.doFormatPreview();
        this.fSourceViewer.setSelection(null);
        int totalPixels1 = widget.getLineCount() * widget.getLineHeight();
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        widget.setTopPixel(top1);
        widget.setRedraw(true);
    }

    protected abstract void doFormatPreview();

    private static int getPositiveIntValue(String string, int defaultValue) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public final Map getWorkingValues() {
        return this.fWorkingValues;
    }

    public final void setWorkingValues(Map workingValues) {
        this.fWorkingValues = workingValues;
    }

    private final class JavaSourcePreviewerUpdater {
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(this){
            private final /* synthetic */ JavaSourcePreviewerUpdater this$1;
            {
                this.this$1 = this$1;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.jdt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
                    JavaSourcePreviewerUpdater.access$000((JavaSourcePreviewerUpdater)this.this$1).fSourceViewer.getTextWidget().setFont(font);
                    if (JavaSourcePreviewerUpdater.access$000((JavaSourcePreviewerUpdater)this.this$1).fMarginPainter != null) {
                        JavaSourcePreviewerUpdater.access$000((JavaSourcePreviewerUpdater)this.this$1).fMarginPainter.initialize();
                    }
                }
            }
        };
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(this){
            private final /* synthetic */ JavaSourcePreviewerUpdater this$1;
            {
                this.this$1 = this$1;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (JavaSourcePreviewerUpdater.access$000((JavaSourcePreviewerUpdater)this.this$1).fViewerConfiguration.affectsTextPresentation(event)) {
                    JavaSourcePreviewerUpdater.access$000((JavaSourcePreviewerUpdater)this.this$1).fViewerConfiguration.handlePropertyChangeEvent(event);
                    JavaSourcePreviewerUpdater.access$000((JavaSourcePreviewerUpdater)this.this$1).fSourceViewer.invalidateTextPresentation();
                }
            }
        };

        public JavaSourcePreviewerUpdater() {
            JFaceResources.getFontRegistry().addListener(this.fontListener);
            JavaPreview.this.fPreferenceStore.addPropertyChangeListener(this.propertyListener);
            JavaPreview.this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ JavaSourcePreviewerUpdater this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener(this.this$1.fontListener);
                    JavaSourcePreviewerUpdater.access$000((JavaSourcePreviewerUpdater)this.this$1).fPreferenceStore.removePropertyChangeListener(this.this$1.propertyListener);
                }
            });
        }

        static /* synthetic */ JavaPreview access$000(JavaSourcePreviewerUpdater x0) {
            return x0.JavaPreview.this;
        }
    }
}

