/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.service.AnnotatedServiceLifecycleHandler;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.ArrayUtils;
import org.gradle.util.internal.CollectionUtils;

@NonNullApi
class ServiceScopeValidator
implements AnnotatedServiceLifecycleHandler {
    private static final List<Class<? extends Annotation>> SCOPE_ANNOTATIONS = Collections.singletonList(ServiceScope.class);
    private final Class<? extends Scope> scope;

    public ServiceScopeValidator(Class<? extends Scope> scope) {
        this.scope = scope;
    }

    @Override
    public List<Class<? extends Annotation>> getAnnotations() {
        return SCOPE_ANNOTATIONS;
    }

    @Override
    public void whenRegistered(Class<? extends Annotation> annotation, AnnotatedServiceLifecycleHandler.Registration registration) {
        this.validateScope(registration.getDeclaredType());
    }

    private void validateScope(Class<?> serviceType) {
        Class<? extends Scope>[] serviceScopes = ServiceScopeValidator.scopeOf(serviceType);
        if (serviceScopes == null) {
            return;
        }
        if (serviceScopes.length == 0) {
            throw new IllegalArgumentException(String.format("Service '%s' is declared with empty scope list", serviceType.getName()));
        }
        if (!ArrayUtils.contains(serviceScopes, this.scope)) {
            throw new IllegalArgumentException(this.invalidScopeMessage(serviceType, serviceScopes));
        }
    }

    private String invalidScopeMessage(Class<?> serviceType, Class<? extends Scope>[] actualScopes) {
        return String.format("The service '%s' declares %s but is registered in the '%s' scope. Either update the '@ServiceScope()' annotation on '%s' to include the '%s' scope or move the service registration to one of the declared scopes.", serviceType.getName(), ServiceScopeValidator.displayScopes(actualScopes), this.scope.getSimpleName(), serviceType.getSimpleName(), this.scope.getSimpleName());
    }

    private static String displayScopes(Class<? extends Scope>[] scopes) {
        if (scopes.length == 1) {
            return "service scope '" + scopes[0].getSimpleName() + "'";
        }
        return "service scopes " + CollectionUtils.join(", ", scopes, new InternalTransformer<String, Class<? extends Scope>>(){

            @Override
            public String transform(Class<? extends Scope> aClass) {
                return "'" + aClass.getSimpleName() + "'";
            }
        });
    }

    @Nullable
    private static Class<? extends Scope>[] scopeOf(Class<?> serviceType) {
        ServiceScope scopeAnnotation = serviceType.getAnnotation(ServiceScope.class);
        return scopeAnnotation != null ? scopeAnnotation.value() : null;
    }
}

