/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ScopedServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.Scope;

public class ServiceRegistryBuilder {
    private final List<ServiceRegistry> parents = new ArrayList<ServiceRegistry>();
    private final List<Object> providers = new ArrayList<Object>();
    private String displayName;
    private Class<? extends Scope> scope;

    private ServiceRegistryBuilder() {
    }

    public static ServiceRegistryBuilder builder() {
        return new ServiceRegistryBuilder();
    }

    public ServiceRegistryBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public ServiceRegistryBuilder parent(ServiceRegistry parent) {
        this.parents.add(parent);
        return this;
    }

    public ServiceRegistryBuilder provider(Object provider) {
        this.providers.add(provider);
        return this;
    }

    public ServiceRegistryBuilder scope(Class<? extends Scope> scope) {
        this.scope = scope;
        return this;
    }

    public ServiceRegistry build() {
        ServiceRegistry[] parents = this.parents.toArray(new ServiceRegistry[0]);
        DefaultServiceRegistry registry = this.scope != null ? new ScopedServiceRegistry(this.scope, this.displayName, parents) : new DefaultServiceRegistry(this.displayName, parents);
        for (Object provider : this.providers) {
            registry.addProvider(provider);
        }
        return registry;
    }
}

