/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.initialization;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.configurationcache.extensions.UnsafeLazyKt;
import org.gradle.configurationcache.initialization.ConfigurationCacheStartParameterKt;
import org.gradle.configurationcache.serialization.Workarounds;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.Factory;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.SupportedEncryptionAlgorithm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scopes.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0015\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0013R\u001f\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001aR\u0013\u0010-\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001eR\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000fR\u0011\u00101\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0013R\u0011\u00102\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0013R\u0011\u00103\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0013R\u0011\u00104\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0013R\u0011\u00105\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0013R\u0011\u00106\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0013R\u0011\u00107\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0013R\u0011\u00108\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0013R\u0011\u00109\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0013R\u0011\u0010:\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0013R\u0013\u0010;\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u001eR\u0011\u0010=\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0013R\u0011\u0010?\u001a\u00020@8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010C\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001aR\u0011\u0010E\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0013R!\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001c0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010J\u001a\u0004\bH\u0010\u000fR\u0011\u0010K\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u001aR\u0011\u0010M\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u001aR\u0019\u0010O\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\f\u0012\u0004\bP\u0010Q\u001a\u0004\bR\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010S\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u0013\u00a8\u0006U"}, d2={"Lorg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter;", "", "buildLayout", "Lorg/gradle/initialization/layout/BuildLayout;", "startParameter", "Lorg/gradle/api/internal/StartParameterInternal;", "options", "Lorg/gradle/internal/buildoption/InternalOptions;", "modelParameters", "Lorg/gradle/internal/buildtree/BuildModelParameters;", "(Lorg/gradle/initialization/layout/BuildLayout;Lorg/gradle/api/internal/StartParameterInternal;Lorg/gradle/internal/buildoption/InternalOptions;Lorg/gradle/internal/buildtree/BuildModelParameters;)V", "allInitScripts", "", "Ljava/io/File;", "getAllInitScripts", "()Ljava/util/List;", "alwaysLogReportLinkAsWarning", "", "getAlwaysLogReportLinkAsWarning", "()Z", "configurationCacheLogLevel", "Lorg/gradle/api/logging/LogLevel;", "getConfigurationCacheLogLevel", "()Lorg/gradle/api/logging/LogLevel;", "currentDirectory", "getCurrentDirectory", "()Ljava/io/File;", "encryptionAlgorithm", "", "getEncryptionAlgorithm", "()Ljava/lang/String;", "encryptionRequested", "getEncryptionRequested", "excludedTaskNames", "", "getExcludedTaskNames", "()Ljava/util/Set;", "failOnProblems", "getFailOnProblems", "gradleProperties", "", "getGradleProperties", "()Ljava/util/Map;", "gradleUserHomeDir", "getGradleUserHomeDir", "ignoredFileSystemCheckInputs", "getIgnoredFileSystemCheckInputs", "includedBuilds", "getIncludedBuilds", "isBuildScan", "isDebug", "isIgnoreInputsInTaskGraphSerialization", "isIsolatedProjects", "isNoBuildScan", "isOffline", "isQuiet", "isRefreshDependencies", "isUpdateDependencyLocks", "isWriteDependencyLocks", "keystoreDir", "getKeystoreDir", "loadAfterStore", "getLoadAfterStore", "maxProblems", "", "getMaxProblems", "()I", "projectDirectory", "getProjectDirectory", "recreateCache", "getRecreateCache", "requestedTaskNames", "getRequestedTaskNames", "requestedTaskNames$delegate", "Lkotlin/Lazy;", "rootDirectory", "getRootDirectory", "settingsDirectory", "getSettingsDirectory", "settingsFile", "getSettingsFile$annotations", "()V", "getSettingsFile", "taskExecutionAccessPreStable", "getTaskExecutionAccessPreStable", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheStartParameter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheStartParameter.kt\norg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,160:1\n478#2,7:161\n*S KotlinDebug\n*F\n+ 1 ConfigurationCacheStartParameter.kt\norg/gradle/configurationcache/initialization/ConfigurationCacheStartParameter\n*L\n63#1:161,7\n*E\n"})
public final class ConfigurationCacheStartParameter {
    @NotNull
    private final BuildLayout buildLayout;
    @NotNull
    private final StartParameterInternal startParameter;
    @NotNull
    private final BuildModelParameters modelParameters;
    private final boolean loadAfterStore;
    private final boolean taskExecutionAccessPreStable;
    private final boolean encryptionRequested;
    @Nullable
    private final String keystoreDir;
    @NotNull
    private final String encryptionAlgorithm;
    private final boolean alwaysLogReportLinkAsWarning;
    @NotNull
    private final Lazy requestedTaskNames$delegate;

    public ConfigurationCacheStartParameter(@NotNull BuildLayout buildLayout, @NotNull StartParameterInternal startParameter, @NotNull InternalOptions options, @NotNull BuildModelParameters modelParameters) {
        Intrinsics.checkNotNullParameter((Object)buildLayout, (String)"buildLayout");
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)modelParameters, (String)"modelParameters");
        this.buildLayout = buildLayout;
        this.startParameter = startParameter;
        this.modelParameters = modelParameters;
        this.loadAfterStore = !this.modelParameters.isRequiresBuildModel() && ConfigurationCacheStartParameterKt.access$getInternalFlag(options, "org.gradle.configuration-cache.internal.load-after-store", true);
        this.taskExecutionAccessPreStable = ConfigurationCacheStartParameterKt.getInternalFlag$default(options, "org.gradle.configuration-cache.internal.task-execution-access-pre-stable", false, 2, null);
        this.encryptionRequested = ConfigurationCacheStartParameterKt.access$getInternalFlag(options, "org.gradle.configuration-cache.internal.encryption", true);
        this.keystoreDir = ConfigurationCacheStartParameterKt.access$getInternalString(options, "org.gradle.configuration-cache.internal.key-store-dir", null);
        String string2 = ConfigurationCacheStartParameterKt.access$getInternalString(options, "org.gradle.configuration-cache.internal.encryption-alg", SupportedEncryptionAlgorithm.AES_ECB_PADDING.getTransformation());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"options.getInternalStrin\u2026B_PADDING.transformation)");
        this.encryptionAlgorithm = string2;
        this.alwaysLogReportLinkAsWarning = ConfigurationCacheStartParameterKt.access$getInternalFlag(options, "org.gradle.configuration-cache.internal.report-link-as-warning", false);
        this.requestedTaskNames$delegate = UnsafeLazyKt.unsafeLazy((Function0)new Function0<List<String>>(this){
            final /* synthetic */ ConfigurationCacheStartParameter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return ConfigurationCacheStartParameter.access$getStartParameter$p(this.this$0).getTaskNames();
            }
        });
    }

    public final boolean getLoadAfterStore() {
        return this.loadAfterStore;
    }

    public final boolean getTaskExecutionAccessPreStable() {
        return this.taskExecutionAccessPreStable;
    }

    public final boolean getEncryptionRequested() {
        return this.encryptionRequested;
    }

    @Nullable
    public final String getKeystoreDir() {
        return this.keystoreDir;
    }

    @NotNull
    public final String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public final boolean getAlwaysLogReportLinkAsWarning() {
        return this.alwaysLogReportLinkAsWarning;
    }

    @NotNull
    public final Map<String, Object> getGradleProperties() {
        Map map = this.startParameter.getProjectProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"startParameter.projectProperties");
        Map $this$filterKeys$iv = map;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!(!Workarounds.INSTANCE.isIgnoredStartParameterProperty(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @NotNull
    public final LogLevel getConfigurationCacheLogLevel() {
        LogLevel logLevel = this.modelParameters.getConfigurationCacheLogLevel();
        Intrinsics.checkNotNullExpressionValue((Object)logLevel, (String)"modelParameters.configurationCacheLogLevel");
        return logLevel;
    }

    public final boolean isQuiet() {
        return this.startParameter.isConfigurationCacheQuiet();
    }

    public final boolean isIgnoreInputsInTaskGraphSerialization() {
        return this.startParameter.isConfigurationCacheIgnoreInputsInTaskGraphSerialization();
    }

    public final int getMaxProblems() {
        return this.startParameter.getConfigurationCacheMaxProblems();
    }

    @Nullable
    public final String getIgnoredFileSystemCheckInputs() {
        return this.startParameter.getConfigurationCacheIgnoredFileSystemCheckInputs();
    }

    public final boolean isDebug() {
        return this.startParameter.isConfigurationCacheDebug();
    }

    public final boolean getFailOnProblems() {
        return this.startParameter.getConfigurationCacheProblems() == StartParameterBuildOptions.ConfigurationCacheProblemsOption.Value.FAIL;
    }

    public final boolean getRecreateCache() {
        return this.startParameter.isConfigurationCacheRecreateCache();
    }

    @Nullable
    public final File getProjectDirectory() {
        return this.startParameter.getProjectDir();
    }

    @NotNull
    public final File getCurrentDirectory() {
        File file = this.startParameter.getCurrentDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"startParameter.currentDir");
        return file;
    }

    @NotNull
    public final File getSettingsDirectory() {
        File file = this.buildLayout.getSettingsDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildLayout.settingsDir");
        return file;
    }

    @Nullable
    public final File getSettingsFile() {
        return (File)DeprecationLogger.whileDisabled((Factory)new Factory(this){
            final /* synthetic */ ConfigurationCacheStartParameter this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final File create() {
                return ConfigurationCacheStartParameter.access$getStartParameter$p(this.this$0).getSettingsFile();
            }
        });
    }

    public static /* synthetic */ void getSettingsFile$annotations() {
    }

    @NotNull
    public final File getRootDirectory() {
        File file = this.buildLayout.getRootDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildLayout.rootDirectory");
        return file;
    }

    public final boolean isOffline() {
        return this.startParameter.isOffline();
    }

    public final boolean isRefreshDependencies() {
        return this.startParameter.isRefreshDependencies();
    }

    public final boolean isWriteDependencyLocks() {
        return this.startParameter.isWriteDependencyLocks() && !this.isUpdateDependencyLocks();
    }

    public final boolean isUpdateDependencyLocks() {
        List list = this.startParameter.getLockedDependenciesToUpdate();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"startParameter.lockedDependenciesToUpdate");
        return !((Collection)list).isEmpty();
    }

    @NotNull
    public final List<String> getRequestedTaskNames() {
        Lazy lazy = this.requestedTaskNames$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-requestedTaskNames>(...)");
        return (List)object;
    }

    @NotNull
    public final Set<String> getExcludedTaskNames() {
        Set set2 = this.startParameter.getExcludedTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"startParameter.excludedTaskNames");
        return set2;
    }

    @NotNull
    public final List<File> getAllInitScripts() {
        List list = this.startParameter.getAllInitScripts();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"startParameter.allInitScripts");
        return list;
    }

    @NotNull
    public final File getGradleUserHomeDir() {
        File file = this.startParameter.getGradleUserHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"startParameter.gradleUserHomeDir");
        return file;
    }

    @NotNull
    public final List<File> getIncludedBuilds() {
        List list = this.startParameter.getIncludedBuilds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"startParameter.includedBuilds");
        return list;
    }

    public final boolean isBuildScan() {
        return this.startParameter.isBuildScan();
    }

    public final boolean isNoBuildScan() {
        return this.startParameter.isNoBuildScan();
    }

    public final boolean isIsolatedProjects() {
        return this.modelParameters.isIsolatedProjects();
    }

    public static final /* synthetic */ StartParameterInternal access$getStartParameter$p(ConfigurationCacheStartParameter $this) {
        return $this.startParameter;
    }
}

