/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.RandUtils;

public class Permutation {
    private int[] perm;

    public Permutation(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n];
        int i = n - 1;
        while (i >= 0) {
            this.perm[i] = i;
            --i;
        }
    }

    public Permutation(int[] perm) {
        if (!this.isPermutation(perm)) {
            throw new IllegalArgumentException("array is not a permutation vector");
        }
        this.perm = IntUtils.clone(perm);
    }

    public Permutation(byte[] enc) {
        int size;
        if (enc.length <= 4) {
            throw new IllegalArgumentException("invalid encoding");
        }
        int n = LittleEndianConversions.OS2IP(enc, 0);
        if (enc.length != 4 + n * (size = IntegerFunctions.ceilLog256(n - 1))) {
            throw new IllegalArgumentException("invalid encoding");
        }
        this.perm = new int[n];
        int i = 0;
        while (i < n) {
            this.perm[i] = LittleEndianConversions.OS2IP(enc, 4 + i * size, size);
            ++i;
        }
        if (!this.isPermutation(this.perm)) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public Permutation(int n, SecureRandom sr) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n];
        int[] help = new int[n];
        int i = 0;
        while (i < n) {
            help[i] = i;
            ++i;
        }
        int k = n;
        int j = 0;
        while (j < n) {
            int i2 = RandUtils.nextInt(sr, k);
            this.perm[j] = help[i2];
            help[i2] = help[--k];
            ++j;
        }
    }

    public byte[] getEncoded() {
        int n = this.perm.length;
        int size = IntegerFunctions.ceilLog256(n - 1);
        byte[] result = new byte[4 + n * size];
        LittleEndianConversions.I2OSP(n, result, 0);
        int i = 0;
        while (i < n) {
            LittleEndianConversions.I2OSP(this.perm[i], result, 4 + i * size, size);
            ++i;
        }
        return result;
    }

    public int[] getVector() {
        return IntUtils.clone(this.perm);
    }

    public Permutation computeInverse() {
        Permutation result = new Permutation(this.perm.length);
        int i = this.perm.length - 1;
        while (i >= 0) {
            result.perm[this.perm[i]] = i;
            --i;
        }
        return result;
    }

    public Permutation rightMultiply(Permutation p) {
        if (p.perm.length != this.perm.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        Permutation result = new Permutation(this.perm.length);
        int i = this.perm.length - 1;
        while (i >= 0) {
            result.perm[i] = this.perm[p.perm[i]];
            --i;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Permutation)) {
            return false;
        }
        Permutation otherPerm = (Permutation)other;
        return IntUtils.equals(this.perm, otherPerm.perm);
    }

    public String toString() {
        String result = "[" + this.perm[0];
        int i = 1;
        while (i < this.perm.length) {
            result = String.valueOf(result) + ", " + this.perm[i];
            ++i;
        }
        result = String.valueOf(result) + "]";
        return result;
    }

    public int hashCode() {
        return this.perm.hashCode();
    }

    private boolean isPermutation(int[] perm) {
        int n = perm.length;
        boolean[] onlyOnce = new boolean[n];
        int i = 0;
        while (i < n) {
            if (perm[i] < 0 || perm[i] >= n || onlyOnce[perm[i]]) {
                return false;
            }
            onlyOnce[perm[i]] = true;
            ++i;
        }
        return true;
    }
}

