/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class CamelliaEngine
implements BlockCipher {
    private boolean initialised = false;
    private boolean _keyIs128;
    private static final int BLOCK_SIZE = 16;
    private static final int MASK8 = 255;
    private int[] subkey = new int[96];
    private int[] kw = new int[8];
    private int[] ke = new int[12];
    private int[] state = new int[4];
    private static final int[] SIGMA = new int[]{-1600231809, 1003262091, -1233459112, 1286239154, -957401297, -380665154, 1426019237, -237801700, 283453434, -563598051, -1336506174, -1276722691};
    private static final int[] SBOX1_1110;
    private static final int[] SBOX4_4404;
    private static final int[] SBOX2_0222;
    private static final int[] SBOX3_3033;

    static {
        int[] nArray = new int[256];
        nArray[0] = 0x70707000;
        nArray[1] = -2105376256;
        nArray[2] = 0x2C2C2C00;
        nArray[3] = -320017408;
        nArray[4] = -1280068864;
        nArray[5] = 0x27272700;
        nArray[6] = -1061109760;
        nArray[7] = -437918464;
        nArray[8] = -454761472;
        nArray[9] = -2054847232;
        nArray[10] = 0x57575700;
        nArray[11] = 0x35353500;
        nArray[12] = -353703424;
        nArray[13] = 0xC0C0C00;
        nArray[14] = -1364283904;
        nArray[15] = 0x41414100;
        nArray[16] = 0x23232300;
        nArray[17] = -269488384;
        nArray[18] = 0x6B6B6B00;
        nArray[19] = -1819045120;
        nArray[20] = 0x45454500;
        nArray[21] = 0x19191900;
        nArray[22] = -1515870976;
        nArray[23] = 0x21212100;
        nArray[24] = -303174400;
        nArray[25] = 0xE0E0E00;
        nArray[26] = 0x4F4F4F00;
        nArray[27] = 0x4E4E4E00;
        nArray[28] = 0x1D1D1D00;
        nArray[29] = 0x65656500;
        nArray[30] = -1835888128;
        nArray[31] = -1111638784;
        nArray[32] = -2038004224;
        nArray[33] = -1195853824;
        nArray[34] = -1347440896;
        nArray[35] = -1886417152;
        nArray[36] = 0x7C7C7C00;
        nArray[37] = -336860416;
        nArray[38] = 0x1F1F1F00;
        nArray[39] = -825307648;
        nArray[40] = 0x3E3E3E00;
        nArray[41] = 0x30303000;
        nArray[42] = -589505536;
        nArray[43] = 0x5F5F5F00;
        nArray[44] = 0x5E5E5E00;
        nArray[45] = -976894720;
        nArray[46] = 0xB0B0B00;
        nArray[47] = 0x1A1A1A00;
        nArray[48] = -1499027968;
        nArray[49] = -505290496;
        nArray[50] = 0x39393900;
        nArray[51] = -892679680;
        nArray[52] = -707406592;
        nArray[53] = 0x47474700;
        nArray[54] = 0x5D5D5D00;
        nArray[55] = 0x3D3D3D00;
        nArray[56] = -640034560;
        nArray[57] = 0x1010100;
        nArray[58] = 0x5A5A5A00;
        nArray[59] = -690563584;
        nArray[60] = 0x51515100;
        nArray[61] = 0x56565600;
        nArray[62] = 0x6C6C6C00;
        nArray[63] = 0x4D4D4D00;
        nArray[64] = -1953789184;
        nArray[65] = 0xD0D0D00;
        nArray[66] = -1701144064;
        nArray[67] = 0x66666600;
        nArray[68] = -67372288;
        nArray[69] = -858993664;
        nArray[70] = -1330597888;
        nArray[71] = 0x2D2D2D00;
        nArray[72] = 0x74747400;
        nArray[73] = 0x12121200;
        nArray[74] = 0x2B2B2B00;
        nArray[75] = 0x20202000;
        nArray[76] = -252645376;
        nArray[77] = -1313754880;
        nArray[78] = -2071690240;
        nArray[79] = -1717987072;
        nArray[80] = -538976512;
        nArray[81] = 0x4C4C4C00;
        nArray[82] = -875836672;
        nArray[83] = -1027423744;
        nArray[84] = 0x34343400;
        nArray[85] = 0x7E7E7E00;
        nArray[86] = 0x76767600;
        nArray[87] = 0x5050500;
        nArray[88] = 0x6D6D6D00;
        nArray[89] = -1212696832;
        nArray[90] = -1448498944;
        nArray[91] = 0x31313100;
        nArray[92] = -774778624;
        nArray[93] = 0x17171700;
        nArray[94] = 0x4040400;
        nArray[95] = -673720576;
        nArray[96] = 0x14141400;
        nArray[97] = 0x58585800;
        nArray[98] = 0x3A3A3A00;
        nArray[99] = 0x61616100;
        nArray[100] = -555819520;
        nArray[101] = 0x1B1B1B00;
        nArray[102] = 0x11111100;
        nArray[103] = 0x1C1C1C00;
        nArray[104] = 0x32323200;
        nArray[105] = 0xF0F0F00;
        nArray[106] = -1667458048;
        nArray[107] = 0x16161600;
        nArray[108] = 0x53535300;
        nArray[109] = 0x18181800;
        nArray[110] = -218959360;
        nArray[111] = 0x22222200;
        nArray[112] = -16843264;
        nArray[113] = 0x44444400;
        nArray[114] = -808464640;
        nArray[115] = -1296911872;
        nArray[116] = -1010580736;
        nArray[117] = -1246382848;
        nArray[118] = 0x7A7A7A00;
        nArray[119] = -1852731136;
        nArray[120] = 0x24242400;
        nArray[121] = 0x8080800;
        nArray[122] = -387389440;
        nArray[123] = -1465341952;
        nArray[124] = 0x60606000;
        nArray[125] = -50529280;
        nArray[126] = 0x69696900;
        nArray[127] = 0x50505000;
        nArray[128] = -1431655936;
        nArray[129] = -791621632;
        nArray[130] = -1600086016;
        nArray[131] = 0x7D7D7D00;
        nArray[132] = -1583243008;
        nArray[133] = -1987475200;
        nArray[134] = 0x62626200;
        nArray[135] = -1751673088;
        nArray[136] = 0x54545400;
        nArray[137] = 0x5B5B5B00;
        nArray[138] = 0x1E1E1E00;
        nArray[139] = -1785359104;
        nArray[140] = -522133504;
        nArray[141] = -256;
        nArray[142] = 0x64646400;
        nArray[143] = -757935616;
        nArray[144] = 0x10101000;
        nArray[145] = -993737728;
        nArray[147] = 0x48484800;
        nArray[148] = -1549556992;
        nArray[149] = -134744320;
        nArray[150] = 0x75757500;
        nArray[151] = -606348544;
        nArray[152] = -1970632192;
        nArray[153] = 0x3030300;
        nArray[154] = -421075456;
        nArray[155] = -623191552;
        nArray[156] = 0x9090900;
        nArray[157] = 0x3F3F3F00;
        nArray[158] = -572662528;
        nArray[159] = -1802202112;
        nArray[160] = -2021161216;
        nArray[161] = 0x5C5C5C00;
        nArray[162] = -2088533248;
        nArray[163] = 0x2020200;
        nArray[164] = -842150656;
        nArray[165] = 0x4A4A4A00;
        nArray[166] = -1869574144;
        nArray[167] = 0x33333300;
        nArray[168] = 0x73737300;
        nArray[169] = 0x67676700;
        nArray[170] = -151587328;
        nArray[171] = -202116352;
        nArray[172] = -1650615040;
        nArray[173] = 0x7F7F7F00;
        nArray[174] = -1077952768;
        nArray[175] = -488447488;
        nArray[176] = 0x52525200;
        nArray[177] = -1684301056;
        nArray[178] = -656877568;
        nArray[179] = 0x26262600;
        nArray[180] = -926365696;
        nArray[181] = 0x37373700;
        nArray[182] = -960051712;
        nArray[183] = 0x3B3B3B00;
        nArray[184] = -2122219264;
        nArray[185] = -1768516096;
        nArray[186] = 0x6F6F6F00;
        nArray[187] = 0x4B4B4B00;
        nArray[188] = 0x13131300;
        nArray[189] = -1094795776;
        nArray[190] = 0x63636300;
        nArray[191] = 0x2E2E2E00;
        nArray[192] = -370546432;
        nArray[193] = 0x79797900;
        nArray[194] = -1482184960;
        nArray[195] = -1936946176;
        nArray[196] = -1616929024;
        nArray[197] = 0x6E6E6E00;
        nArray[198] = -1128481792;
        nArray[199] = -1903260160;
        nArray[200] = 0x29292900;
        nArray[201] = -168430336;
        nArray[202] = -101058304;
        nArray[203] = -1229539840;
        nArray[204] = 0x2F2F2F00;
        nArray[205] = -33686272;
        nArray[206] = -1263225856;
        nArray[207] = 0x59595900;
        nArray[208] = 0x78787800;
        nArray[209] = -1734830080;
        nArray[210] = 0x6060600;
        nArray[211] = 0x6A6A6A00;
        nArray[212] = -404232448;
        nArray[213] = 0x46464600;
        nArray[214] = 0x71717100;
        nArray[215] = -1162167808;
        nArray[216] = -724249600;
        nArray[217] = 0x25252500;
        nArray[218] = -1414812928;
        nArray[219] = 0x42424200;
        nArray[220] = -2004318208;
        nArray[221] = -1566400000;
        nArray[222] = -1920103168;
        nArray[223] = -84215296;
        nArray[224] = 0x72727200;
        nArray[225] = 0x7070700;
        nArray[226] = -1179010816;
        nArray[227] = 0x55555500;
        nArray[228] = -117901312;
        nArray[229] = -286331392;
        nArray[230] = -1397969920;
        nArray[231] = 0xA0A0A00;
        nArray[232] = 0x36363600;
        nArray[233] = 0x49494900;
        nArray[234] = 0x2A2A2A00;
        nArray[235] = 0x68686800;
        nArray[236] = 0x3C3C3C00;
        nArray[237] = 0x38383800;
        nArray[238] = -235802368;
        nArray[239] = -1532713984;
        nArray[240] = 0x40404000;
        nArray[241] = 0x28282800;
        nArray[242] = -741092608;
        nArray[243] = 0x7B7B7B00;
        nArray[244] = -1145324800;
        nArray[245] = -909522688;
        nArray[246] = 0x43434300;
        nArray[247] = -1044266752;
        nArray[248] = 0x15151500;
        nArray[249] = -471604480;
        nArray[250] = -1381126912;
        nArray[251] = -185273344;
        nArray[252] = 0x77777700;
        nArray[253] = -943208704;
        nArray[254] = -2139062272;
        nArray[255] = -1633772032;
        SBOX1_1110 = nArray;
        int[] nArray2 = new int[256];
        nArray2[0] = 0x70700070;
        nArray2[1] = 0x2C2C002C;
        nArray2[2] = -1280114509;
        nArray2[3] = -1061158720;
        nArray2[4] = -454819612;
        nArray2[5] = 0x57570057;
        nArray2[6] = -353763094;
        nArray2[7] = -1364328274;
        nArray2[8] = 0x23230023;
        nArray2[9] = 0x6B6B006B;
        nArray2[10] = 0x45450045;
        nArray2[11] = -1515913051;
        nArray2[12] = -303234835;
        nArray2[13] = 0x4F4F004F;
        nArray2[14] = 0x1D1D001D;
        nArray2[15] = -1835925358;
        nArray2[16] = -2038038394;
        nArray2[17] = -1347485521;
        nArray2[18] = 0x7C7C007C;
        nArray2[19] = 0x1F1F001F;
        nArray2[20] = 0x3E3E003E;
        nArray2[21] = -589561636;
        nArray2[22] = 0x5E5E005E;
        nArray2[23] = 0xB0B000B;
        nArray2[24] = -1499070298;
        nArray2[25] = 0x39390039;
        nArray2[26] = -707460907;
        nArray2[27] = 0x5D5D005D;
        nArray2[28] = -640089895;
        nArray2[29] = 0x5A5A005A;
        nArray2[30] = 0x51510051;
        nArray2[31] = 0x6C6C006C;
        nArray2[32] = -1953824629;
        nArray2[33] = -1701183334;
        nArray2[34] = -67436293;
        nArray2[35] = -1330642768;
        nArray2[36] = 0x74740074;
        nArray2[37] = 0x2B2B002B;
        nArray2[38] = -252706576;
        nArray2[39] = -2071723900;
        nArray2[40] = -539033377;
        nArray2[41] = -875888437;
        nArray2[42] = 0x34340034;
        nArray2[43] = 0x76760076;
        nArray2[44] = 0x6D6D006D;
        nArray2[45] = -1448542039;
        nArray2[46] = -774831919;
        nArray2[47] = 0x4040004;
        nArray2[48] = 0x14140014;
        nArray2[49] = 0x3A3A003A;
        nArray2[50] = -555876130;
        nArray2[51] = 0x11110011;
        nArray2[52] = 0x32320032;
        nArray2[53] = -1667497828;
        nArray2[54] = 0x53530053;
        nArray2[55] = -219021070;
        nArray2[56] = -16908034;
        nArray2[57] = -808517425;
        nArray2[58] = -1010630461;
        nArray2[59] = 0x7A7A007A;
        nArray2[60] = 0x24240024;
        nArray2[61] = -387448600;
        nArray2[62] = 0x60600060;
        nArray2[63] = 0x69690069;
        nArray2[64] = -1431699286;
        nArray2[65] = -1600126816;
        nArray2[66] = -1583284063;
        nArray2[67] = 0x62620062;
        nArray2[68] = 0x54540054;
        nArray2[69] = 0x1E1E001E;
        nArray2[70] = -522190624;
        nArray2[71] = 0x64640064;
        nArray2[72] = 0x10100010;
        nArray2[74] = -1549598557;
        nArray2[75] = 0x75750075;
        nArray2[76] = -1970667382;
        nArray2[77] = -421134106;
        nArray2[78] = 0x9090009;
        nArray2[79] = -572718883;
        nArray2[80] = -2021195641;
        nArray2[81] = -2088566653;
        nArray2[82] = -842202931;
        nArray2[83] = -1869610864;
        nArray2[84] = 0x73730073;
        nArray2[85] = -151650058;
        nArray2[86] = -1650655075;
        nArray2[87] = -1078001473;
        nArray2[88] = 0x52520052;
        nArray2[89] = -656932648;
        nArray2[90] = -926416696;
        nArray2[91] = -960102202;
        nArray2[92] = -2122252159;
        nArray2[93] = 0x6F6F006F;
        nArray2[94] = 0x13130013;
        nArray2[95] = 0x63630063;
        nArray2[96] = -370605847;
        nArray2[97] = -1482227545;
        nArray2[98] = -1616969569;
        nArray2[99] = -1128529732;
        nArray2[100] = 0x29290029;
        nArray2[101] = -101121799;
        nArray2[102] = 0x2F2F002F;
        nArray2[103] = -1263271756;
        nArray2[104] = 0x78780078;
        nArray2[105] = 0x6060006;
        nArray2[106] = -404291353;
        nArray2[107] = 0x71710071;
        nArray2[108] = -724303660;
        nArray2[109] = -1414856533;
        nArray2[110] = -2004352888;
        nArray2[111] = -1920139123;
        nArray2[112] = 0x72720072;
        nArray2[113] = -1179057991;
        nArray2[114] = -117964552;
        nArray2[115] = -1398013780;
        nArray2[116] = 0x36360036;
        nArray2[117] = 0x2A2A002A;
        nArray2[118] = 0x3C3C003C;
        nArray2[119] = -235863823;
        nArray2[120] = 0x40400040;
        nArray2[121] = -741146413;
        nArray2[122] = -1145372485;
        nArray2[123] = 0x43430043;
        nArray2[124] = 0x15150015;
        nArray2[125] = -1381171027;
        nArray2[126] = 0x77770077;
        nArray2[127] = -2139094912;
        nArray2[128] = -2105409406;
        nArray2[129] = -320077588;
        nArray2[130] = 0x27270027;
        nArray2[131] = -437976859;
        nArray2[132] = -2054881147;
        nArray2[133] = 0x35350035;
        nArray2[134] = 0xC0C000C;
        nArray2[135] = 0x41410041;
        nArray2[136] = -269549329;
        nArray2[137] = -1819082605;
        nArray2[138] = 0x19190019;
        nArray2[139] = 0x21210021;
        nArray2[140] = 0xE0E000E;
        nArray2[141] = 0x4E4E004E;
        nArray2[142] = 0x65650065;
        nArray2[143] = -1111686979;
        nArray2[144] = -1195900744;
        nArray2[145] = -1886453617;
        nArray2[146] = -336920341;
        nArray2[147] = -825360178;
        nArray2[148] = 0x30300030;
        nArray2[149] = 0x5F5F005F;
        nArray2[150] = -976944955;
        nArray2[151] = 0x1A1A001A;
        nArray2[152] = -505347871;
        nArray2[153] = -892731190;
        nArray2[154] = 0x47470047;
        nArray2[155] = 0x3D3D003D;
        nArray2[156] = 0x1010001;
        nArray2[157] = -690618154;
        nArray2[158] = 0x56560056;
        nArray2[159] = 0x4D4D004D;
        nArray2[160] = 0xD0D000D;
        nArray2[161] = 0x66660066;
        nArray2[162] = -859045684;
        nArray2[163] = 0x2D2D002D;
        nArray2[164] = 0x12120012;
        nArray2[165] = 0x20200020;
        nArray2[166] = -1313800015;
        nArray2[167] = -1718026087;
        nArray2[168] = 0x4C4C004C;
        nArray2[169] = -1027473214;
        nArray2[170] = 0x7E7E007E;
        nArray2[171] = 0x5050005;
        nArray2[172] = -1212743497;
        nArray2[173] = 0x31310031;
        nArray2[174] = 0x17170017;
        nArray2[175] = -673775401;
        nArray2[176] = 0x58580058;
        nArray2[177] = 0x61610061;
        nArray2[178] = 0x1B1B001B;
        nArray2[179] = 0x1C1C001C;
        nArray2[180] = 0xF0F000F;
        nArray2[181] = 0x16160016;
        nArray2[182] = 0x18180018;
        nArray2[183] = 0x22220022;
        nArray2[184] = 0x44440044;
        nArray2[185] = -1296957262;
        nArray2[186] = -1246429003;
        nArray2[187] = -1852768111;
        nArray2[188] = 0x8080008;
        nArray2[189] = -1465384792;
        nArray2[190] = -50593540;
        nArray2[191] = 0x50500050;
        nArray2[192] = -791674672;
        nArray2[193] = 0x7D7D007D;
        nArray2[194] = -1987510135;
        nArray2[195] = -1751711593;
        nArray2[196] = 0x5B5B005B;
        nArray2[197] = -1785397099;
        nArray2[198] = -65281;
        nArray2[199] = -757989166;
        nArray2[200] = -993787708;
        nArray2[201] = 0x48480048;
        nArray2[202] = -134807305;
        nArray2[203] = -606404389;
        nArray2[204] = 0x3030003;
        nArray2[205] = -623247142;
        nArray2[206] = 0x3F3F003F;
        nArray2[207] = -1802239852;
        nArray2[208] = 0x5C5C005C;
        nArray2[209] = 0x2020002;
        nArray2[210] = 0x4A4A004A;
        nArray2[211] = 0x33330033;
        nArray2[212] = 0x67670067;
        nArray2[213] = -202178317;
        nArray2[214] = 0x7F7F007F;
        nArray2[215] = -488505118;
        nArray2[216] = -1684340581;
        nArray2[217] = 0x26260026;
        nArray2[218] = 0x37370037;
        nArray2[219] = 0x3B3B003B;
        nArray2[220] = -1768554346;
        nArray2[221] = 0x4B4B004B;
        nArray2[222] = -1094844226;
        nArray2[223] = 0x2E2E002E;
        nArray2[224] = 0x79790079;
        nArray2[225] = -1936981876;
        nArray2[226] = 0x6E6E006E;
        nArray2[227] = -1903296370;
        nArray2[228] = -168492811;
        nArray2[229] = -1229586250;
        nArray2[230] = -33750787;
        nArray2[231] = 0x59590059;
        nArray2[232] = -1734868840;
        nArray2[233] = 0x6A6A006A;
        nArray2[234] = 0x46460046;
        nArray2[235] = -1162215238;
        nArray2[236] = 0x25250025;
        nArray2[237] = 0x42420042;
        nArray2[238] = -1566441310;
        nArray2[239] = -84279046;
        nArray2[240] = 0x7070007;
        nArray2[241] = 0x55550055;
        nArray2[242] = -286392082;
        nArray2[243] = 0xA0A000A;
        nArray2[244] = 0x49490049;
        nArray2[245] = 0x68680068;
        nArray2[246] = 0x38380038;
        nArray2[247] = -1532755804;
        nArray2[248] = 0x28280028;
        nArray2[249] = 0x7B7B007B;
        nArray2[250] = -909573943;
        nArray2[251] = -1044315967;
        nArray2[252] = -471662365;
        nArray2[253] = -185335564;
        nArray2[254] = -943259449;
        nArray2[255] = -1633812322;
        SBOX4_4404 = nArray2;
        int[] nArray3 = new int[256];
        nArray3[0] = 0xE0E0E0;
        nArray3[1] = 328965;
        nArray3[2] = 0x585858;
        nArray3[3] = 0xD9D9D9;
        nArray3[4] = 0x676767;
        nArray3[5] = 0x4E4E4E;
        nArray3[6] = 0x818181;
        nArray3[7] = 0xCBCBCB;
        nArray3[8] = 0xC9C9C9;
        nArray3[9] = 723723;
        nArray3[10] = 0xAEAEAE;
        nArray3[11] = 0x6A6A6A;
        nArray3[12] = 0xD5D5D5;
        nArray3[13] = 0x181818;
        nArray3[14] = 0x5D5D5D;
        nArray3[15] = 0x828282;
        nArray3[16] = 0x464646;
        nArray3[17] = 0xDFDFDF;
        nArray3[18] = 0xD6D6D6;
        nArray3[19] = 0x272727;
        nArray3[20] = 0x8A8A8A;
        nArray3[21] = 0x323232;
        nArray3[22] = 0x4B4B4B;
        nArray3[23] = 0x424242;
        nArray3[24] = 0xDBDBDB;
        nArray3[25] = 0x1C1C1C;
        nArray3[26] = 0x9E9E9E;
        nArray3[27] = 0x9C9C9C;
        nArray3[28] = 0x3A3A3A;
        nArray3[29] = 0xCACACA;
        nArray3[30] = 0x252525;
        nArray3[31] = 0x7B7B7B;
        nArray3[32] = 855309;
        nArray3[33] = 0x717171;
        nArray3[34] = 0x5F5F5F;
        nArray3[35] = 0x1F1F1F;
        nArray3[36] = 0xF8F8F8;
        nArray3[37] = 0xD7D7D7;
        nArray3[38] = 0x3E3E3E;
        nArray3[39] = 0x9D9D9D;
        nArray3[40] = 0x7C7C7C;
        nArray3[41] = 0x606060;
        nArray3[42] = 0xB9B9B9;
        nArray3[43] = 0xBEBEBE;
        nArray3[44] = 0xBCBCBC;
        nArray3[45] = 0x8B8B8B;
        nArray3[46] = 0x161616;
        nArray3[47] = 0x343434;
        nArray3[48] = 0x4D4D4D;
        nArray3[49] = 0xC3C3C3;
        nArray3[50] = 0x727272;
        nArray3[51] = 0x959595;
        nArray3[52] = 0xABABAB;
        nArray3[53] = 0x8E8E8E;
        nArray3[54] = 0xBABABA;
        nArray3[55] = 0x7A7A7A;
        nArray3[56] = 0xB3B3B3;
        nArray3[57] = 131586;
        nArray3[58] = 0xB4B4B4;
        nArray3[59] = 0xADADAD;
        nArray3[60] = 0xA2A2A2;
        nArray3[61] = 0xACACAC;
        nArray3[62] = 0xD8D8D8;
        nArray3[63] = 0x9A9A9A;
        nArray3[64] = 0x171717;
        nArray3[65] = 0x1A1A1A;
        nArray3[66] = 0x353535;
        nArray3[67] = 0xCCCCCC;
        nArray3[68] = 0xF7F7F7;
        nArray3[69] = 0x999999;
        nArray3[70] = 0x616161;
        nArray3[71] = 0x5A5A5A;
        nArray3[72] = 0xE8E8E8;
        nArray3[73] = 0x242424;
        nArray3[74] = 0x565656;
        nArray3[75] = 0x404040;
        nArray3[76] = 0xE1E1E1;
        nArray3[77] = 0x636363;
        nArray3[78] = 592137;
        nArray3[79] = 0x333333;
        nArray3[80] = 0xBFBFBF;
        nArray3[81] = 0x989898;
        nArray3[82] = 0x979797;
        nArray3[83] = 0x858585;
        nArray3[84] = 0x686868;
        nArray3[85] = 0xFCFCFC;
        nArray3[86] = 0xECECEC;
        nArray3[87] = 657930;
        nArray3[88] = 0xDADADA;
        nArray3[89] = 0x6F6F6F;
        nArray3[90] = 0x535353;
        nArray3[91] = 0x626262;
        nArray3[92] = 0xA3A3A3;
        nArray3[93] = 0x2E2E2E;
        nArray3[94] = 526344;
        nArray3[95] = 0xAFAFAF;
        nArray3[96] = 0x282828;
        nArray3[97] = 0xB0B0B0;
        nArray3[98] = 0x747474;
        nArray3[99] = 0xC2C2C2;
        nArray3[100] = 0xBDBDBD;
        nArray3[101] = 0x363636;
        nArray3[102] = 0x222222;
        nArray3[103] = 0x383838;
        nArray3[104] = 0x646464;
        nArray3[105] = 0x1E1E1E;
        nArray3[106] = 0x393939;
        nArray3[107] = 0x2C2C2C;
        nArray3[108] = 0xA6A6A6;
        nArray3[109] = 0x303030;
        nArray3[110] = 0xE5E5E5;
        nArray3[111] = 0x444444;
        nArray3[112] = 0xFDFDFD;
        nArray3[113] = 0x888888;
        nArray3[114] = 0x9F9F9F;
        nArray3[115] = 0x656565;
        nArray3[116] = 0x878787;
        nArray3[117] = 0x6B6B6B;
        nArray3[118] = 0xF4F4F4;
        nArray3[119] = 0x232323;
        nArray3[120] = 0x484848;
        nArray3[121] = 0x101010;
        nArray3[122] = 0xD1D1D1;
        nArray3[123] = 0x515151;
        nArray3[124] = 0xC0C0C0;
        nArray3[125] = 0xF9F9F9;
        nArray3[126] = 0xD2D2D2;
        nArray3[127] = 0xA0A0A0;
        nArray3[128] = 0x555555;
        nArray3[129] = 0xA1A1A1;
        nArray3[130] = 0x414141;
        nArray3[131] = 0xFAFAFA;
        nArray3[132] = 0x434343;
        nArray3[133] = 0x131313;
        nArray3[134] = 0xC4C4C4;
        nArray3[135] = 0x2F2F2F;
        nArray3[136] = 0xA8A8A8;
        nArray3[137] = 0xB6B6B6;
        nArray3[138] = 0x3C3C3C;
        nArray3[139] = 0x2B2B2B;
        nArray3[140] = 0xC1C1C1;
        nArray3[141] = 0xFFFFFF;
        nArray3[142] = 0xC8C8C8;
        nArray3[143] = 0xA5A5A5;
        nArray3[144] = 0x202020;
        nArray3[145] = 0x898989;
        nArray3[147] = 0x909090;
        nArray3[148] = 0x474747;
        nArray3[149] = 0xEFEFEF;
        nArray3[150] = 0xEAEAEA;
        nArray3[151] = 0xB7B7B7;
        nArray3[152] = 0x151515;
        nArray3[153] = 394758;
        nArray3[154] = 0xCDCDCD;
        nArray3[155] = 0xB5B5B5;
        nArray3[156] = 0x121212;
        nArray3[157] = 0x7E7E7E;
        nArray3[158] = 0xBBBBBB;
        nArray3[159] = 0x292929;
        nArray3[160] = 986895;
        nArray3[161] = 0xB8B8B8;
        nArray3[162] = 460551;
        nArray3[163] = 263172;
        nArray3[164] = 0x9B9B9B;
        nArray3[165] = 0x949494;
        nArray3[166] = 0x212121;
        nArray3[167] = 0x666666;
        nArray3[168] = 0xE6E6E6;
        nArray3[169] = 0xCECECE;
        nArray3[170] = 0xEDEDED;
        nArray3[171] = 0xE7E7E7;
        nArray3[172] = 0x3B3B3B;
        nArray3[173] = 0xFEFEFE;
        nArray3[174] = 0x7F7F7F;
        nArray3[175] = 0xC5C5C5;
        nArray3[176] = 0xA4A4A4;
        nArray3[177] = 0x373737;
        nArray3[178] = 0xB1B1B1;
        nArray3[179] = 0x4C4C4C;
        nArray3[180] = 0x919191;
        nArray3[181] = 0x6E6E6E;
        nArray3[182] = 0x8D8D8D;
        nArray3[183] = 0x767676;
        nArray3[184] = 197379;
        nArray3[185] = 0x2D2D2D;
        nArray3[186] = 0xDEDEDE;
        nArray3[187] = 0x969696;
        nArray3[188] = 0x262626;
        nArray3[189] = 0x7D7D7D;
        nArray3[190] = 0xC6C6C6;
        nArray3[191] = 0x5C5C5C;
        nArray3[192] = 0xD3D3D3;
        nArray3[193] = 0xF2F2F2;
        nArray3[194] = 0x4F4F4F;
        nArray3[195] = 0x191919;
        nArray3[196] = 0x3F3F3F;
        nArray3[197] = 0xDCDCDC;
        nArray3[198] = 0x797979;
        nArray3[199] = 0x1D1D1D;
        nArray3[200] = 0x525252;
        nArray3[201] = 0xEBEBEB;
        nArray3[202] = 0xF3F3F3;
        nArray3[203] = 0x6D6D6D;
        nArray3[204] = 0x5E5E5E;
        nArray3[205] = 0xFBFBFB;
        nArray3[206] = 0x696969;
        nArray3[207] = 0xB2B2B2;
        nArray3[208] = 0xF0F0F0;
        nArray3[209] = 0x313131;
        nArray3[210] = 789516;
        nArray3[211] = 0xD4D4D4;
        nArray3[212] = 0xCFCFCF;
        nArray3[213] = 0x8C8C8C;
        nArray3[214] = 0xE2E2E2;
        nArray3[215] = 0x757575;
        nArray3[216] = 0xA9A9A9;
        nArray3[217] = 0x4A4A4A;
        nArray3[218] = 0x575757;
        nArray3[219] = 0x848484;
        nArray3[220] = 0x111111;
        nArray3[221] = 0x454545;
        nArray3[222] = 0x1B1B1B;
        nArray3[223] = 0xF5F5F5;
        nArray3[224] = 0xE4E4E4;
        nArray3[225] = 921102;
        nArray3[226] = 0x737373;
        nArray3[227] = 0xAAAAAA;
        nArray3[228] = 0xF1F1F1;
        nArray3[229] = 0xDDDDDD;
        nArray3[230] = 0x595959;
        nArray3[231] = 0x141414;
        nArray3[232] = 0x6C6C6C;
        nArray3[233] = 0x929292;
        nArray3[234] = 0x545454;
        nArray3[235] = 0xD0D0D0;
        nArray3[236] = 0x787878;
        nArray3[237] = 0x707070;
        nArray3[238] = 0xE3E3E3;
        nArray3[239] = 0x494949;
        nArray3[240] = 0x808080;
        nArray3[241] = 0x505050;
        nArray3[242] = 0xA7A7A7;
        nArray3[243] = 0xF6F6F6;
        nArray3[244] = 0x777777;
        nArray3[245] = 0x939393;
        nArray3[246] = 0x868686;
        nArray3[247] = 0x838383;
        nArray3[248] = 0x2A2A2A;
        nArray3[249] = 0xC7C7C7;
        nArray3[250] = 0x5B5B5B;
        nArray3[251] = 0xE9E9E9;
        nArray3[252] = 0xEEEEEE;
        nArray3[253] = 0x8F8F8F;
        nArray3[254] = 65793;
        nArray3[255] = 0x3D3D3D;
        SBOX2_0222 = nArray3;
        int[] nArray4 = new int[256];
        nArray4[0] = 0x38003838;
        nArray4[1] = 0x41004141;
        nArray4[2] = 0x16001616;
        nArray4[3] = 0x76007676;
        nArray4[4] = -654255655;
        nArray4[5] = -1828678765;
        nArray4[6] = 0x60006060;
        nArray4[7] = -234818830;
        nArray4[8] = 0x72007272;
        nArray4[9] = -1040137534;
        nArray4[10] = -1426019413;
        nArray4[11] = -1711236454;
        nArray4[12] = 0x75007575;
        nArray4[13] = 0x6000606;
        nArray4[14] = 0x57005757;
        nArray4[15] = -1610571616;
        nArray4[16] = -1862233711;
        nArray4[17] = -150931465;
        nArray4[18] = -1258244683;
        nArray4[19] = -922695223;
        nArray4[20] = -1577016670;
        nArray4[21] = -1946121076;
        nArray4[22] = -771697966;
        nArray4[23] = -1879011184;
        nArray4[24] = -167708938;
        nArray4[25] = 0x7000707;
        nArray4[26] = -1493129305;
        nArray4[27] = 0x27002727;
        nArray4[28] = -1912566130;
        nArray4[29] = -1308577102;
        nArray4[30] = 0x49004949;
        nArray4[31] = -570368290;
        nArray4[32] = 0x43004343;
        nArray4[33] = 0x5C005C5C;
        nArray4[34] = -687810601;
        nArray4[35] = -956250169;
        nArray4[36] = 0x3E003E3E;
        nArray4[37] = -184486411;
        nArray4[38] = -1895788657;
        nArray4[39] = 0x67006767;
        nArray4[40] = 0x1F001F1F;
        nArray4[41] = 0x18001818;
        nArray4[42] = 0x6E006E6E;
        nArray4[43] = -1358909521;
        nArray4[44] = 0x2F002F2F;
        nArray4[45] = -503258398;
        nArray4[46] = -2063563387;
        nArray4[47] = 0xD000D0D;
        nArray4[48] = 0x53005353;
        nArray4[49] = -268373776;
        nArray4[50] = -1677681508;
        nArray4[51] = 0x65006565;
        nArray4[52] = -369038614;
        nArray4[53] = -1560239197;
        nArray4[54] = -1375686994;
        nArray4[55] = -1644126562;
        nArray4[56] = -335483668;
        nArray4[57] = -2147450752;
        nArray4[58] = 0x2D002D2D;
        nArray4[59] = 0x6B006B6B;
        nArray4[60] = -1476351832;
        nArray4[61] = 0x2B002B2B;
        nArray4[62] = 0x36003636;
        nArray4[63] = -1509906778;
        nArray4[64] = -989805115;
        nArray4[65] = -2046785914;
        nArray4[66] = 0x4D004D4D;
        nArray4[67] = 0x33003333;
        nArray4[68] = -50266627;
        nArray4[69] = 0x66006666;
        nArray4[70] = 0x58005858;
        nArray4[71] = -1778346346;
        nArray4[72] = 0x3A003A3A;
        nArray4[73] = 0x9000909;
        nArray4[74] = -1795123819;
        nArray4[75] = 0x10001010;
        nArray4[76] = 0x78007878;
        nArray4[77] = -671033128;
        nArray4[78] = 0x42004242;
        nArray4[79] = -872362804;
        nArray4[80] = -285151249;
        nArray4[81] = 0x26002626;
        nArray4[82] = -452925979;
        nArray4[83] = 0x61006161;
        nArray4[84] = 0x1A001A1A;
        nArray4[85] = 0x3F003F3F;
        nArray4[86] = 0x3B003B3B;
        nArray4[87] = -2113895806;
        nArray4[88] = -1241467210;
        nArray4[89] = -620700709;
        nArray4[90] = -738143020;
        nArray4[91] = -1744791400;
        nArray4[92] = -402593560;
        nArray4[93] = -1962898549;
        nArray4[94] = 0x2000202;
        nArray4[95] = -352261141;
        nArray4[96] = 0xA000A0A;
        nArray4[97] = 0x2C002C2C;
        nArray4[98] = 0x1D001D1D;
        nArray4[99] = -1342132048;
        nArray4[100] = 0x6F006F6F;
        nArray4[101] = -1929343603;
        nArray4[102] = -2013230968;
        nArray4[103] = 0xE000E0E;
        nArray4[104] = 0x19001919;
        nArray4[105] = -2030008441;
        nArray4[106] = 0x4E004E4E;
        nArray4[107] = 0xB000B0B;
        nArray4[108] = -1459574359;
        nArray4[109] = 0xC000C0C;
        nArray4[110] = 0x79007979;
        nArray4[111] = 0x11001111;
        nArray4[112] = 0x7F007F7F;
        nArray4[113] = 0x22002222;
        nArray4[114] = -419371033;
        nArray4[115] = 0x59005959;
        nArray4[116] = -520035871;
        nArray4[117] = -637478182;
        nArray4[118] = 0x3D003D3D;
        nArray4[119] = -939472696;
        nArray4[120] = 0x12001212;
        nArray4[121] = 0x4000404;
        nArray4[122] = 0x74007474;
        nArray4[123] = 0x54005454;
        nArray4[124] = 0x30003030;
        nArray4[125] = 0x7E007E7E;
        nArray4[126] = -1275022156;
        nArray4[127] = 0x28002828;
        nArray4[128] = 0x55005555;
        nArray4[129] = 0x68006868;
        nArray4[130] = 0x50005050;
        nArray4[131] = -1107247426;
        nArray4[132] = -805252912;
        nArray4[133] = -1006582588;
        nArray4[134] = 0x31003131;
        nArray4[135] = -889140277;
        nArray4[136] = 0x2A002A2A;
        nArray4[137] = -1392464467;
        nArray4[138] = 0xF000F0F;
        nArray4[139] = -905917750;
        nArray4[140] = 0x70007070;
        nArray4[141] = -16711681;
        nArray4[142] = 0x32003232;
        nArray4[143] = 0x69006969;
        nArray4[144] = 0x8000808;
        nArray4[145] = 0x62006262;
        nArray4[147] = 0x24002424;
        nArray4[148] = -788475439;
        nArray4[149] = -83821573;
        nArray4[150] = -1174357318;
        nArray4[151] = -318706195;
        nArray4[152] = 0x45004545;
        nArray4[153] = -2130673279;
        nArray4[154] = 0x73007373;
        nArray4[155] = 0x6D006D6D;
        nArray4[156] = -2080340860;
        nArray4[157] = -1627349089;
        nArray4[158] = -301928722;
        nArray4[159] = 0x4A004A4A;
        nArray4[160] = -1023360061;
        nArray4[161] = 0x2E002E2E;
        nArray4[162] = -1056915007;
        nArray4[163] = 0x1000101;
        nArray4[164] = -436148506;
        nArray4[165] = 0x25002525;
        nArray4[166] = 0x48004848;
        nArray4[167] = -1728013927;
        nArray4[168] = -1191134791;
        nArray4[169] = -1291799629;
        nArray4[170] = 0x7B007B7B;
        nArray4[171] = -117376519;
        nArray4[172] = -838807858;
        nArray4[173] = -1090469953;
        nArray4[174] = -553590817;
        nArray4[175] = 0x71007171;
        nArray4[176] = 0x29002929;
        nArray4[177] = -855585331;
        nArray4[178] = 0x6C006C6C;
        nArray4[179] = 0x13001313;
        nArray4[180] = 0x64006464;
        nArray4[181] = -1694458981;
        nArray4[182] = 0x63006363;
        nArray4[183] = -1660904035;
        nArray4[184] = -1073692480;
        nArray4[185] = 0x4B004B4B;
        nArray4[186] = -1224689737;
        nArray4[187] = -1526684251;
        nArray4[188] = -1996453495;
        nArray4[189] = 0x5F005F5F;
        nArray4[190] = -1325354575;
        nArray4[191] = 0x17001717;
        nArray4[192] = -201263884;
        nArray4[193] = -1140802372;
        nArray4[194] = -754920493;
        nArray4[195] = 0x46004646;
        nArray4[196] = -822030385;
        nArray4[197] = 0x37003737;
        nArray4[198] = 0x5E005E5E;
        nArray4[199] = 0x47004747;
        nArray4[200] = -1811901292;
        nArray4[201] = -100599046;
        nArray4[202] = -67044100;
        nArray4[203] = 0x5B005B5B;
        nArray4[204] = -1761568873;
        nArray4[205] = -33489154;
        nArray4[206] = 0x5A005A5A;
        nArray4[207] = -1409241940;
        nArray4[208] = 0x3C003C3C;
        nArray4[209] = 0x4C004C4C;
        nArray4[210] = 0x3000303;
        nArray4[211] = 0x35003535;
        nArray4[212] = -218041357;
        nArray4[213] = 0x23002323;
        nArray4[214] = -1207912264;
        nArray4[215] = 0x5D005D5D;
        nArray4[216] = 0x6A006A6A;
        nArray4[217] = -1845456238;
        nArray4[218] = -721365547;
        nArray4[219] = 0x21002121;
        nArray4[220] = 0x44004444;
        nArray4[221] = 0x51005151;
        nArray4[222] = -973027642;
        nArray4[223] = 0x7D007D7D;
        nArray4[224] = 0x39003939;
        nArray4[225] = -2097118333;
        nArray4[226] = -603923236;
        nArray4[227] = -1442796886;
        nArray4[228] = 0x7C007C7C;
        nArray4[229] = 0x77007777;
        nArray4[230] = 0x56005656;
        nArray4[231] = 0x5000505;
        nArray4[232] = 0x1B001B1B;
        nArray4[233] = -1543461724;
        nArray4[234] = 0x15001515;
        nArray4[235] = 0x34003434;
        nArray4[236] = 0x1E001E1E;
        nArray4[237] = 0x1C001C1C;
        nArray4[238] = -134153992;
        nArray4[239] = 0x52005252;
        nArray4[240] = 0x20002020;
        nArray4[241] = 0x14001414;
        nArray4[242] = -385816087;
        nArray4[243] = -1124024899;
        nArray4[244] = -587145763;
        nArray4[245] = -469703452;
        nArray4[246] = -1593794143;
        nArray4[247] = -536813344;
        nArray4[248] = -1979676022;
        nArray4[249] = -251596303;
        nArray4[250] = -704588074;
        nArray4[251] = 0x7A007A7A;
        nArray4[252] = -1157579845;
        nArray4[253] = -486480925;
        nArray4[254] = 0x40004040;
        nArray4[255] = 0x4F004F4F;
        SBOX3_3033 = nArray4;
    }

    private static int rightRotate(int x, int s) {
        return (x >>> s) + (x << 32 - s);
    }

    private static int leftRotate(int x, int s) {
        return (x << s) + (x >>> 32 - s);
    }

    private static void roldq(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[0 + ooff] = ki[0 + ioff] << rot | ki[1 + ioff] >>> 32 - rot;
        ko[1 + ooff] = ki[1 + ioff] << rot | ki[2 + ioff] >>> 32 - rot;
        ko[2 + ooff] = ki[2 + ioff] << rot | ki[3 + ioff] >>> 32 - rot;
        ko[3 + ooff] = ki[3 + ioff] << rot | ki[0 + ioff] >>> 32 - rot;
        ki[0 + ioff] = ko[0 + ooff];
        ki[1 + ioff] = ko[1 + ooff];
        ki[2 + ioff] = ko[2 + ooff];
        ki[3 + ioff] = ko[3 + ooff];
    }

    private static void decroldq(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[2 + ooff] = ki[0 + ioff] << rot | ki[1 + ioff] >>> 32 - rot;
        ko[3 + ooff] = ki[1 + ioff] << rot | ki[2 + ioff] >>> 32 - rot;
        ko[0 + ooff] = ki[2 + ioff] << rot | ki[3 + ioff] >>> 32 - rot;
        ko[1 + ooff] = ki[3 + ioff] << rot | ki[0 + ioff] >>> 32 - rot;
        ki[0 + ioff] = ko[2 + ooff];
        ki[1 + ioff] = ko[3 + ooff];
        ki[2 + ioff] = ko[0 + ooff];
        ki[3 + ioff] = ko[1 + ooff];
    }

    private static void roldqo32(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[0 + ooff] = ki[1 + ioff] << rot - 32 | ki[2 + ioff] >>> 64 - rot;
        ko[1 + ooff] = ki[2 + ioff] << rot - 32 | ki[3 + ioff] >>> 64 - rot;
        ko[2 + ooff] = ki[3 + ioff] << rot - 32 | ki[0 + ioff] >>> 64 - rot;
        ko[3 + ooff] = ki[0 + ioff] << rot - 32 | ki[1 + ioff] >>> 64 - rot;
        ki[0 + ioff] = ko[0 + ooff];
        ki[1 + ioff] = ko[1 + ooff];
        ki[2 + ioff] = ko[2 + ooff];
        ki[3 + ioff] = ko[3 + ooff];
    }

    private static void decroldqo32(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[2 + ooff] = ki[1 + ioff] << rot - 32 | ki[2 + ioff] >>> 64 - rot;
        ko[3 + ooff] = ki[2 + ioff] << rot - 32 | ki[3 + ioff] >>> 64 - rot;
        ko[0 + ooff] = ki[3 + ioff] << rot - 32 | ki[0 + ioff] >>> 64 - rot;
        ko[1 + ooff] = ki[0 + ioff] << rot - 32 | ki[1 + ioff] >>> 64 - rot;
        ki[0 + ioff] = ko[2 + ooff];
        ki[1 + ioff] = ko[3 + ooff];
        ki[2 + ioff] = ko[0 + ooff];
        ki[3 + ioff] = ko[1 + ooff];
    }

    private int bytes2int(byte[] src, int offset) {
        int word = 0;
        int i = 0;
        while (i < 4) {
            word = (word << 8) + (src[i + offset] & 0xFF);
            ++i;
        }
        return word;
    }

    private void int2bytes(int word, byte[] dst, int offset) {
        int i = 0;
        while (i < 4) {
            dst[3 - i + offset] = (byte)word;
            word >>>= 8;
            ++i;
        }
    }

    private void camelliaF2(int[] s, int[] skey, int keyoff) {
        int t1 = s[0] ^ skey[0 + keyoff];
        int u = SBOX4_4404[t1 & 0xFF];
        u ^= SBOX3_3033[t1 >>> 8 & 0xFF];
        u ^= SBOX2_0222[t1 >>> 16 & 0xFF];
        int t2 = s[1] ^ skey[1 + keyoff];
        int v = SBOX1_1110[t2 & 0xFF];
        v ^= SBOX4_4404[t2 >>> 8 & 0xFF];
        v ^= SBOX3_3033[t2 >>> 16 & 0xFF];
        s[2] = s[2] ^ ((u ^= SBOX1_1110[t1 >>> 24 & 0xFF]) ^ (v ^= SBOX2_0222[t2 >>> 24 & 0xFF]));
        s[3] = s[3] ^ (u ^ v ^ CamelliaEngine.rightRotate(u, 8));
        t1 = s[2] ^ skey[2 + keyoff];
        u = SBOX4_4404[t1 & 0xFF];
        u ^= SBOX3_3033[t1 >>> 8 & 0xFF];
        u ^= SBOX2_0222[t1 >>> 16 & 0xFF];
        t2 = s[3] ^ skey[3 + keyoff];
        v = SBOX1_1110[t2 & 0xFF];
        v ^= SBOX4_4404[t2 >>> 8 & 0xFF];
        v ^= SBOX3_3033[t2 >>> 16 & 0xFF];
        s[0] = s[0] ^ ((u ^= SBOX1_1110[t1 >>> 24 & 0xFF]) ^ (v ^= SBOX2_0222[t2 >>> 24 & 0xFF]));
        s[1] = s[1] ^ (u ^ v ^ CamelliaEngine.rightRotate(u, 8));
    }

    private void camelliaFLs(int[] s, int[] fkey, int keyoff) {
        s[1] = s[1] ^ CamelliaEngine.leftRotate(s[0] & fkey[0 + keyoff], 1);
        s[0] = s[0] ^ (fkey[1 + keyoff] | s[1]);
        s[2] = s[2] ^ (fkey[3 + keyoff] | s[3]);
        s[3] = s[3] ^ CamelliaEngine.leftRotate(fkey[2 + keyoff] & s[2], 1);
    }

    private void setKey(boolean forEncryption, byte[] key) {
        int[] k = new int[8];
        int[] ka = new int[4];
        int[] kb = new int[4];
        int[] t = new int[4];
        switch (key.length) {
            case 16: {
                this._keyIs128 = true;
                k[0] = this.bytes2int(key, 0);
                k[1] = this.bytes2int(key, 4);
                k[2] = this.bytes2int(key, 8);
                k[3] = this.bytes2int(key, 12);
                k[7] = 0;
                k[6] = 0;
                k[5] = 0;
                k[4] = 0;
                break;
            }
            case 24: {
                k[0] = this.bytes2int(key, 0);
                k[1] = this.bytes2int(key, 4);
                k[2] = this.bytes2int(key, 8);
                k[3] = this.bytes2int(key, 12);
                k[4] = this.bytes2int(key, 16);
                k[5] = this.bytes2int(key, 20);
                k[6] = ~k[4];
                k[7] = ~k[5];
                this._keyIs128 = false;
                break;
            }
            case 32: {
                k[0] = this.bytes2int(key, 0);
                k[1] = this.bytes2int(key, 4);
                k[2] = this.bytes2int(key, 8);
                k[3] = this.bytes2int(key, 12);
                k[4] = this.bytes2int(key, 16);
                k[5] = this.bytes2int(key, 20);
                k[6] = this.bytes2int(key, 24);
                k[7] = this.bytes2int(key, 28);
                this._keyIs128 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("key sizes are only 16/24/32 bytes.");
            }
        }
        int i = 0;
        while (i < 4) {
            ka[i] = k[i] ^ k[i + 4];
            ++i;
        }
        this.camelliaF2(ka, SIGMA, 0);
        i = 0;
        while (i < 4) {
            int n = i;
            ka[n] = ka[n] ^ k[i];
            ++i;
        }
        this.camelliaF2(ka, SIGMA, 4);
        if (this._keyIs128) {
            if (forEncryption) {
                this.kw[0] = k[0];
                this.kw[1] = k[1];
                this.kw[2] = k[2];
                this.kw[3] = k[3];
                CamelliaEngine.roldq(15, k, 0, this.subkey, 4);
                CamelliaEngine.roldq(30, k, 0, this.subkey, 12);
                CamelliaEngine.roldq(15, k, 0, t, 0);
                this.subkey[18] = t[2];
                this.subkey[19] = t[3];
                CamelliaEngine.roldq(17, k, 0, this.ke, 4);
                CamelliaEngine.roldq(17, k, 0, this.subkey, 24);
                CamelliaEngine.roldq(17, k, 0, this.subkey, 32);
                this.subkey[0] = ka[0];
                this.subkey[1] = ka[1];
                this.subkey[2] = ka[2];
                this.subkey[3] = ka[3];
                CamelliaEngine.roldq(15, ka, 0, this.subkey, 8);
                CamelliaEngine.roldq(15, ka, 0, this.ke, 0);
                CamelliaEngine.roldq(15, ka, 0, t, 0);
                this.subkey[16] = t[0];
                this.subkey[17] = t[1];
                CamelliaEngine.roldq(15, ka, 0, this.subkey, 20);
                CamelliaEngine.roldqo32(34, ka, 0, this.subkey, 28);
                CamelliaEngine.roldq(17, ka, 0, this.kw, 4);
            } else {
                this.kw[4] = k[0];
                this.kw[5] = k[1];
                this.kw[6] = k[2];
                this.kw[7] = k[3];
                CamelliaEngine.decroldq(15, k, 0, this.subkey, 28);
                CamelliaEngine.decroldq(30, k, 0, this.subkey, 20);
                CamelliaEngine.decroldq(15, k, 0, t, 0);
                this.subkey[16] = t[0];
                this.subkey[17] = t[1];
                CamelliaEngine.decroldq(17, k, 0, this.ke, 0);
                CamelliaEngine.decroldq(17, k, 0, this.subkey, 8);
                CamelliaEngine.decroldq(17, k, 0, this.subkey, 0);
                this.subkey[34] = ka[0];
                this.subkey[35] = ka[1];
                this.subkey[32] = ka[2];
                this.subkey[33] = ka[3];
                CamelliaEngine.decroldq(15, ka, 0, this.subkey, 24);
                CamelliaEngine.decroldq(15, ka, 0, this.ke, 4);
                CamelliaEngine.decroldq(15, ka, 0, t, 0);
                this.subkey[18] = t[2];
                this.subkey[19] = t[3];
                CamelliaEngine.decroldq(15, ka, 0, this.subkey, 12);
                CamelliaEngine.decroldqo32(34, ka, 0, this.subkey, 4);
                CamelliaEngine.roldq(17, ka, 0, this.kw, 0);
            }
        } else {
            i = 0;
            while (i < 4) {
                kb[i] = ka[i] ^ k[i + 4];
                ++i;
            }
            this.camelliaF2(kb, SIGMA, 8);
            if (forEncryption) {
                this.kw[0] = k[0];
                this.kw[1] = k[1];
                this.kw[2] = k[2];
                this.kw[3] = k[3];
                CamelliaEngine.roldqo32(45, k, 0, this.subkey, 16);
                CamelliaEngine.roldq(15, k, 0, this.ke, 4);
                CamelliaEngine.roldq(17, k, 0, this.subkey, 32);
                CamelliaEngine.roldqo32(34, k, 0, this.subkey, 44);
                CamelliaEngine.roldq(15, k, 4, this.subkey, 4);
                CamelliaEngine.roldq(15, k, 4, this.ke, 0);
                CamelliaEngine.roldq(30, k, 4, this.subkey, 24);
                CamelliaEngine.roldqo32(34, k, 4, this.subkey, 36);
                CamelliaEngine.roldq(15, ka, 0, this.subkey, 8);
                CamelliaEngine.roldq(30, ka, 0, this.subkey, 20);
                this.ke[8] = ka[1];
                this.ke[9] = ka[2];
                this.ke[10] = ka[3];
                this.ke[11] = ka[0];
                CamelliaEngine.roldqo32(49, ka, 0, this.subkey, 40);
                this.subkey[0] = kb[0];
                this.subkey[1] = kb[1];
                this.subkey[2] = kb[2];
                this.subkey[3] = kb[3];
                CamelliaEngine.roldq(30, kb, 0, this.subkey, 12);
                CamelliaEngine.roldq(30, kb, 0, this.subkey, 28);
                CamelliaEngine.roldqo32(51, kb, 0, this.kw, 4);
            } else {
                this.kw[4] = k[0];
                this.kw[5] = k[1];
                this.kw[6] = k[2];
                this.kw[7] = k[3];
                CamelliaEngine.decroldqo32(45, k, 0, this.subkey, 28);
                CamelliaEngine.decroldq(15, k, 0, this.ke, 4);
                CamelliaEngine.decroldq(17, k, 0, this.subkey, 12);
                CamelliaEngine.decroldqo32(34, k, 0, this.subkey, 0);
                CamelliaEngine.decroldq(15, k, 4, this.subkey, 40);
                CamelliaEngine.decroldq(15, k, 4, this.ke, 8);
                CamelliaEngine.decroldq(30, k, 4, this.subkey, 20);
                CamelliaEngine.decroldqo32(34, k, 4, this.subkey, 8);
                CamelliaEngine.decroldq(15, ka, 0, this.subkey, 36);
                CamelliaEngine.decroldq(30, ka, 0, this.subkey, 24);
                this.ke[2] = ka[1];
                this.ke[3] = ka[2];
                this.ke[0] = ka[3];
                this.ke[1] = ka[0];
                CamelliaEngine.decroldqo32(49, ka, 0, this.subkey, 4);
                this.subkey[46] = kb[0];
                this.subkey[47] = kb[1];
                this.subkey[44] = kb[2];
                this.subkey[45] = kb[3];
                CamelliaEngine.decroldq(30, kb, 0, this.subkey, 32);
                CamelliaEngine.decroldq(30, kb, 0, this.subkey, 16);
                CamelliaEngine.roldqo32(51, kb, 0, this.kw, 0);
            }
        }
    }

    private int processBlock128(byte[] in, int inOff, byte[] out, int outOff) {
        int i = 0;
        while (i < 4) {
            this.state[i] = this.bytes2int(in, inOff + i * 4);
            int n = i;
            this.state[n] = this.state[n] ^ this.kw[i];
            ++i;
        }
        this.camelliaF2(this.state, this.subkey, 0);
        this.camelliaF2(this.state, this.subkey, 4);
        this.camelliaF2(this.state, this.subkey, 8);
        this.camelliaFLs(this.state, this.ke, 0);
        this.camelliaF2(this.state, this.subkey, 12);
        this.camelliaF2(this.state, this.subkey, 16);
        this.camelliaF2(this.state, this.subkey, 20);
        this.camelliaFLs(this.state, this.ke, 4);
        this.camelliaF2(this.state, this.subkey, 24);
        this.camelliaF2(this.state, this.subkey, 28);
        this.camelliaF2(this.state, this.subkey, 32);
        this.state[2] = this.state[2] ^ this.kw[4];
        this.state[3] = this.state[3] ^ this.kw[5];
        this.state[0] = this.state[0] ^ this.kw[6];
        this.state[1] = this.state[1] ^ this.kw[7];
        this.int2bytes(this.state[2], out, outOff);
        this.int2bytes(this.state[3], out, outOff + 4);
        this.int2bytes(this.state[0], out, outOff + 8);
        this.int2bytes(this.state[1], out, outOff + 12);
        return 16;
    }

    private int processBlock192or256(byte[] in, int inOff, byte[] out, int outOff) {
        int i = 0;
        while (i < 4) {
            this.state[i] = this.bytes2int(in, inOff + i * 4);
            int n = i;
            this.state[n] = this.state[n] ^ this.kw[i];
            ++i;
        }
        this.camelliaF2(this.state, this.subkey, 0);
        this.camelliaF2(this.state, this.subkey, 4);
        this.camelliaF2(this.state, this.subkey, 8);
        this.camelliaFLs(this.state, this.ke, 0);
        this.camelliaF2(this.state, this.subkey, 12);
        this.camelliaF2(this.state, this.subkey, 16);
        this.camelliaF2(this.state, this.subkey, 20);
        this.camelliaFLs(this.state, this.ke, 4);
        this.camelliaF2(this.state, this.subkey, 24);
        this.camelliaF2(this.state, this.subkey, 28);
        this.camelliaF2(this.state, this.subkey, 32);
        this.camelliaFLs(this.state, this.ke, 8);
        this.camelliaF2(this.state, this.subkey, 36);
        this.camelliaF2(this.state, this.subkey, 40);
        this.camelliaF2(this.state, this.subkey, 44);
        this.state[2] = this.state[2] ^ this.kw[4];
        this.state[3] = this.state[3] ^ this.kw[5];
        this.state[0] = this.state[0] ^ this.kw[6];
        this.state[1] = this.state[1] ^ this.kw[7];
        this.int2bytes(this.state[2], out, outOff);
        this.int2bytes(this.state[3], out, outOff + 4);
        this.int2bytes(this.state[0], out, outOff + 8);
        this.int2bytes(this.state[1], out, outOff + 12);
        return 16;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("only simple KeyParameter expected.");
        }
        this.setKey(forEncryption, ((KeyParameter)params).getKey());
        this.initialised = true;
    }

    public String getAlgorithmName() {
        return "Camellia";
    }

    public int getBlockSize() {
        return 16;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Camellia engine not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this._keyIs128) {
            return this.processBlock128(in, inOff, out, outOff);
        }
        return this.processBlock192or256(in, inOff, out, outOff);
    }

    public void reset() {
    }
}

