/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.ICommandHandler;
import org.xmind.core.internal.command.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMindCommandHandlerRegistry
implements IRegistryEventListener {
    private static final String EXT_POINT_ID = "handlers";
    private static final String ATT_COMMAND = "command";
    private static final String ATT_CLASS = "class";
    private static final String ATT_ID = "id";
    private static final XMindCommandHandlerRegistry instance = new XMindCommandHandlerRegistry();
    private List<CommandHandlerDescriptor> descriptors = null;
    private Map<String, List<CommandHandlerDescriptor>> cache = null;

    private XMindCommandHandlerRegistry() {
    }

    private synchronized List<CommandHandlerDescriptor> getHandlers() {
        this.ensureLoaded();
        return this.descriptors;
    }

    private void ensureLoaded() {
        if (this.descriptors != null) {
            return;
        }
        this.loadFromExtensions();
        if (this.descriptors == null) {
            this.descriptors = Collections.emptyList();
        }
    }

    private void loadFromExtensions() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.xmind.core.command", EXT_POINT_ID);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        this.loadFromExtensions(extensions);
    }

    private void loadFromExtensions(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            this.loadFromConfigurationElements(extensions[i].getConfigurationElements());
            ++i;
        }
    }

    private void loadFromConfigurationElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.loadFromConfigurationElement(elements[i]);
            ++i;
        }
    }

    private void loadFromConfigurationElement(IConfigurationElement element) {
        String name = element.getName();
        if ("handler".equals(name)) {
            this.loadFromHandlerConfigurationElement(element);
            this.loadFromConfigurationElements(element.getChildren());
        }
    }

    private void loadFromHandlerConfigurationElement(IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            Logger.log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid extension: (id missing)"));
            return;
        }
        if (element.getAttribute(ATT_CLASS) == null) {
            Logger.log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid extension: (class missing)"));
            return;
        }
        this.registerContribution(new CommandHandlerDescriptor(id, element));
    }

    private void registerContribution(CommandHandlerDescriptor contribution) {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList<CommandHandlerDescriptor>();
        }
        this.descriptors.add(contribution);
    }

    synchronized List<CommandHandlerDescriptor> findMatchedHandlerDescriptors(ICommand command) {
        List<CommandHandlerDescriptor> list;
        if (this.cache == null) {
            this.cache = new HashMap<String, List<CommandHandlerDescriptor>>();
        }
        if ((list = this.cache.get(command.getCommandName())) == null) {
            list = this.collectHandlers(command.getCommandName());
            this.cache.put(command.getCommandName(), list);
        }
        return list;
    }

    private List<CommandHandlerDescriptor> collectHandlers(String commandName) {
        ArrayList<CommandHandlerDescriptor> list = new ArrayList<CommandHandlerDescriptor>();
        for (CommandHandlerDescriptor desc : this.getHandlers()) {
            if (!desc.match(commandName).matches()) continue;
            list.add(desc);
        }
        return list;
    }

    private void invalidate() {
        this.descriptors = null;
        this.cache = null;
    }

    public void added(IExtension[] extensions) {
        this.invalidate();
    }

    public void removed(IExtension[] extensions) {
        this.invalidate();
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void installRegistryEventListener(IExtensionRegistry registry) {
        if (registry == null) {
            return;
        }
        registry.addListener((IRegistryEventListener)this, "org.xmind.core.command.handlers");
    }

    public void uninstallRegistryEventListener(IExtensionRegistry registry) {
        if (registry == null) {
            return;
        }
        registry.removeListener((IRegistryEventListener)this);
    }

    public static XMindCommandHandlerRegistry getInstance() {
        return instance;
    }

    public static class CommandHandlerDescriptor {
        private String id;
        private Pattern pattern;
        private IConfigurationElement element;
        private ICommandHandler handler;

        public CommandHandlerDescriptor(String id, IConfigurationElement element) {
            String namePattern = element.getAttribute(XMindCommandHandlerRegistry.ATT_COMMAND);
            if (namePattern == null) {
                namePattern = "";
            }
            this.id = id;
            this.pattern = Pattern.compile(namePattern);
            this.element = element;
            this.handler = null;
        }

        public String getId() {
            return this.id;
        }

        public Matcher match(String commandName) {
            return this.pattern.matcher(commandName);
        }

        public ICommandHandler getHandler() {
            if (this.handler == null) {
                try {
                    this.handler = (ICommandHandler)this.element.createExecutableExtension(XMindCommandHandlerRegistry.ATT_CLASS);
                }
                catch (CoreException e) {
                    Logger.log(null, e);
                }
            }
            return this.handler;
        }

        public String toString() {
            return "CommandHandler{" + this.getId() + "}";
        }
    }
}

