/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class KeepVisibleToolTipHelper
extends ToolTipHelper {
    private IFigure currentTipSource;

    public KeepVisibleToolTipHelper(Control control) {
        super(control);
    }

    private Point computeWindowLocation(IFigure tip, int eventX, int eventY) {
        Rectangle clientArea = this.control.getDisplay().getClientArea();
        Point preferredLocation = new Point(eventX, eventY + 26);
        Dimension tipSize = this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
        if (preferredLocation.y + tipSize.height > clientArea.height) {
            preferredLocation.y = eventY - tipSize.height;
        }
        if (preferredLocation.x + tipSize.width > clientArea.width) {
            preferredLocation.x -= preferredLocation.x + tipSize.width - clientArea.width;
        }
        return preferredLocation;
    }

    public void displayToolTipNear(IFigure hoverSource, IFigure tip, int eventX, int eventY) {
        if (tip != null && hoverSource != this.currentTipSource) {
            this.getLightweightSystem().setContents(tip);
            Point displayPoint = this.computeWindowLocation(tip, eventX, eventY);
            Dimension shellSize = this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
            this.setShellBounds(displayPoint.x, displayPoint.y, shellSize.width, shellSize.height);
            this.show();
            this.currentTipSource = hoverSource;
        }
    }

    public void dispose() {
        if (this.isShowing()) {
            this.hide();
        }
        this.getShell().dispose();
    }

    protected void hookShellListeners() {
        this.getShell().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                KeepVisibleToolTipHelper.this.hide();
                KeepVisibleToolTipHelper.this.currentTipSource = null;
            }
        });
    }

    public void updateToolTip(IFigure figureUnderMouse, IFigure tip, int eventX, int eventY) {
        if (figureUnderMouse == null && this.isShowing()) {
            this.hide();
        }
        if (this.isShowing() && figureUnderMouse != this.currentTipSource) {
            this.hide();
            this.displayToolTipNear(figureUnderMouse, tip, eventX, eventY);
        } else if (!this.isShowing() && figureUnderMouse != this.currentTipSource) {
            this.currentTipSource = null;
        }
    }
}

