/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.cell;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.part.NullGraphicalPart;
import org.xmind.ui.gallery.ContentPanePart;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.MSExportWizardPage;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IViewerModel;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.wizards.ExportUtils;

public class ExcelExportPageBase
extends MSExportWizardPage {
    private final String PREVIEW_MERGED_COLUMN = "images/merged_column.png";
    private final String PREVIEW_MERGED_ROW = "images/merged_row.png";
    private final String PREVIEW_OUTLINE_COLUMN = "images/outline_column.png";
    private final String PREVIEW_OUTLINE_ROW = "images/outline_row.png";
    private final String PREVIEW_PIVOT_COLUMN = "images/pivot_column.png";
    private final String PREVIEW_PIVOT_ROW = "images/pivot_row.png";
    private Label previewImage;
    private Label previewLabel;
    private Button allCheck;

    protected void createPreviewViewer(Composite parent) {
        GridData data = (GridData)parent.getLayoutData();
        data.heightHint = 230;
        data.widthHint = 370;
        this.previewImage = new Label(parent, 0);
        this.previewImage.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.previewLabel = new Label(parent, 64);
        GridData previewLabelData = new GridData(1, 0x1000000, false, false);
        previewLabelData.widthHint = 320;
        previewLabelData.heightHint = 30;
        this.previewLabel.setLayoutData((Object)previewLabelData);
        this.updatePreview(this.getDialogSettings().get("excelType"), this.getDialogSettings().get("positionType"));
    }

    private void updatePreview(String excelType, String positionType) {
        String previewType = new String();
        if (excelType.equals(ExcelType.MergedCell.getKey())) {
            this.previewLabel.setText(ExportMessages.ExcelPage_PreviewLabel_MergedCell);
            if (positionType.equals(CentralTopicPosition.Row.name())) {
                previewType = "images/merged_row.png";
            } else if (positionType.equals(CentralTopicPosition.Column.name())) {
                previewType = "images/merged_column.png";
            }
        } else if (excelType.equals(ExcelType.Pivot.getKey())) {
            this.previewLabel.setText(ExportMessages.ExcelPage_PreviewLabel_Pivot);
            if (positionType.equals(CentralTopicPosition.Row.name())) {
                previewType = "images/pivot_row.png";
            } else if (positionType.equals(CentralTopicPosition.Column.name())) {
                previewType = "images/pivot_column.png";
            }
        } else if (excelType.equals(ExcelType.Outline.getKey())) {
            this.previewLabel.setText(ExportMessages.ExcelPage_PreviewLabel_Outline);
            if (positionType.equals(CentralTopicPosition.Row.name())) {
                previewType = "images/outline_row.png";
            } else if (positionType.equals(CentralTopicPosition.Column.name())) {
                previewType = "images/outline_column.png";
            }
        }
        URL url = Platform.getBundle((String)"org.xmind.ui.aspose").getEntry(previewType);
        if (url != null) {
            try {
                Image image = new Image(null, url.openStream());
                this.previewImage.setImage(image);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ExcelExportPageBase(String pageName, String title) {
        super(pageName, title);
    }

    protected void createPropertyWidgets(Composite parent) {
        this.createLayoutControls(parent);
        this.createCentralTopicPositionControls(parent);
        this.createBooleanWidget(parent, "includeFloatingTopics", WizardMessages.DocumentExportPage_IncludeFloatingTopics);
        this.createBooleanWidget(parent, "includeTaskInfo", ExportMessages.MSExportWizardPage_IncludeTaskInfo);
    }

    protected void createAdditionalWidgets(Composite parent) {
        this.createAllCheck(parent);
    }

    protected void createAllCheck(Composite parent) {
        this.allCheck = new Button(parent, 32);
        this.allCheck.setText(WizardMessages.DocumentExportPage_AllContents_text);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.verticalIndent = 2;
        this.allCheck.setLayoutData((Object)layoutData);
        this.hookWidget((Widget)this.allCheck, 13);
    }

    private void createCentralTopicPositionControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 7;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(ExportMessages.ExcelPage_RootTopicPosition_label);
        Composite radioGroup = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 7;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 3;
        gridLayout2.horizontalSpacing = 5;
        radioGroup.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 210;
        gridData.heightHint = -1;
        radioGroup.setLayoutData((Object)gridData);
        this.createRadio(radioGroup, CentralTopicPosition.Row);
        this.createRadio(radioGroup, CentralTopicPosition.Column);
    }

    private void createLayoutControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 7;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(ExportMessages.ExcelPage_TableLayout_Label);
        Composite radioGroup = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 7;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 3;
        gridLayout2.horizontalSpacing = 5;
        radioGroup.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 210;
        gridData.heightHint = -1;
        radioGroup.setLayoutData((Object)gridData);
        this.createLayoutRadio(radioGroup, ExcelType.MergedCell);
        this.createLayoutRadio(radioGroup, ExcelType.Pivot);
        this.createLayoutRadio(radioGroup, ExcelType.Outline);
    }

    private void createLayoutRadio(Composite parent, final ExcelType type) {
        final Button widget = new Button(parent, 16);
        widget.setText(type.getValue());
        widget.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        widget.setSelection(this.getExcelTypeSelection(type));
        widget.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (widget.getSelection()) {
                    ExcelExportPageBase.this.getDialogSettings().put("excelType", type.getKey());
                    ExcelExportPageBase.this.updateStatus();
                    ExcelExportPageBase.this.updatePreview(type.getKey(), ExcelExportPageBase.this.getDialogSettings().get("positionType"));
                }
            }
        });
    }

    private void createRadio(Composite parent, final CentralTopicPosition type) {
        final Button widget = new Button(parent, 16);
        widget.setText(type.getDescription());
        widget.setData((Object)type);
        widget.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        widget.setSelection(this.getCentralTopicPositionSelection(type));
        widget.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (widget.getSelection()) {
                    ExcelExportPageBase.this.getDialogSettings().put("positionType", type.name());
                    ExcelExportPageBase.this.updateStatus();
                    ExcelExportPageBase.this.updatePreview(ExcelExportPageBase.this.getDialogSettings().get("excelType"), type.name());
                }
            }
        });
    }

    private boolean getExcelTypeSelection(ExcelType type) {
        boolean isSelection;
        ExcelType selection;
        String excelType = this.getDialogSettings().get("excelType");
        ExcelType excelType2 = selection = excelType == null ? ExcelType.MergedCell : ExcelType.getByKey(excelType);
        if (selection == null) {
            selection = ExcelType.MergedCell;
        }
        boolean bl = isSelection = type == selection;
        if (isSelection) {
            this.getDialogSettings().put("excelType", selection.getKey());
        }
        return isSelection;
    }

    private boolean getCentralTopicPositionSelection(CentralTopicPosition type) {
        boolean isSelection;
        String positionType = this.getDialogSettings().get("positionType");
        CentralTopicPosition selection = positionType == null ? CentralTopicPosition.Row : CentralTopicPosition.valueOf(positionType);
        boolean bl = isSelection = type == selection;
        if (isSelection) {
            this.getDialogSettings().put("positionType", selection.name());
        }
        return isSelection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CentralTopicPosition {
        Row(ExportMessages.ExcelPage_RootTopicPosition_row),
        Column(ExportMessages.ExcelPage_RootTopicPosition_column);

        private String description;

        private CentralTopicPosition(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class ExcelContantPanePart
    extends ContentPanePart {
        public ExcelContantPanePart(ISheet input) {
            super((Object)input);
        }

        protected Object[] getModelChildren(Object model) {
            ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
            ISheet sheet = (ISheet)this.getModel();
            ITopic rootTopic = sheet.getRootTopic();
            list.add(new ViewerModel(TopicTitlePreviewPart.class, (Object)rootTopic));
            return list.toArray();
        }
    }

    protected class ExcelPreviewPartFactory
    implements IPartFactory {
        private IPartFactory factory;

        public ExcelPreviewPartFactory(IPartFactory factory) {
            this.factory = factory;
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof ContentPanePart) {
                return this.factory.createPart(context, model);
            }
            if (model instanceof ISheet) {
                return new ExcelContantPanePart((ISheet)model);
            }
            if (model instanceof IViewerModel) {
                IViewerModel m = (IViewerModel)model;
                try {
                    IPart part = (IPart)m.getPartType().getConstructors()[0].newInstance(new Object[]{ExcelExportPageBase.this});
                    part.setModel(model);
                    return part;
                }
                catch (Throwable e) {
                    Logger.log((Throwable)e, (String)("Failed to create export preview part: " + m.getPartType()));
                }
            }
            return new NullGraphicalPart();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExcelType {
        MergedCell("Merged Cell", ExportMessages.ExcelPage_TableLayout_MergedCell),
        Pivot("Pivot", ExportMessages.ExcelPage_TableLayout_Pivot),
        Outline("Outline", ExportMessages.ExcelPage_TableLayout_Outline);

        private String key;
        private String value;

        private ExcelType(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static ExcelType getByKey(String key) {
            ExcelType[] excelTypeArray = ExcelType.values();
            int n = excelTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExcelType excelType = excelTypeArray[n2];
                if (excelType.getKey().equals(key)) {
                    return excelType;
                }
                ++n2;
            }
            return null;
        }
    }

    protected class TopicTitlePreviewPart
    extends GraphicalEditPart {
        private RotatableWrapLabel number;
        private RotatableWrapLabel title;

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        public RotatableWrapLabel getNumber() {
            return this.number;
        }

        public RotatableWrapLabel getTitle() {
            return this.title;
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
            if (this.getTopic().isRoot()) {
                layout.setMajorAlignment(0);
            } else {
                layout.setMajorAlignment(1);
            }
            layout.setMinorAlignment(2);
            layout.setInnerMinorAlignment(2);
            layout.setSpacing(5);
            return layout;
        }

        protected IFigure createFigure() {
            return new Figure();
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            ITopic topic = this.getTopic();
            int level = MindMapUtils.getLevel((ITopic)this.getTopic(), null);
            level = Math.min(2, level);
            Font font = level <= 1 ? FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)(-level)) : FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)(-level));
            String num = ExportUtils.getNumberingText((ITopic)topic, null);
            if (num != null) {
                this.number = new RotatableWrapLabel(0);
                this.number.setFont(font);
                this.number.setForegroundColor(ColorConstants.black);
                this.number.setText(num);
                figure.add((IFigure)this.number);
            }
            this.title = new RotatableWrapLabel(0);
            this.title.setFont(font);
            this.title.setForegroundColor(ColorConstants.black);
            this.title.setText(topic.getTitleText());
            figure.add((IFigure)this.title);
        }
    }
}

