/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.xmind.core.net.Field;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.internal.EncodingUtils;

public class MultipartEntity
extends HttpEntity {
    private static final String MULTIPART_CONTENT_TYPE = "multipart/form-data; boundary=";
    private static final byte[] BOUNDARY_CHARS = EncodingUtils.toAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    private static final byte[] CRLF = EncodingUtils.toAsciiBytes("\r\n");
    private static final byte[] QUOTE = EncodingUtils.toAsciiBytes("\"");
    private static final byte[] EXTRA = EncodingUtils.toAsciiBytes("--");
    private static final byte[] CONTENT_DISPOSITION = EncodingUtils.toAsciiBytes("Content-Disposition: form-data; name=");
    private static final byte[] CONTENT_TYPE = EncodingUtils.toAsciiBytes("Content-Type: ");
    private static final byte[] CONTENT_TRANSFER_ENCODING = EncodingUtils.toAsciiBytes("Content-Transfer-Encoding: ");
    private static final byte[] FILE_NAME = EncodingUtils.toAsciiBytes("; filename=");
    private static final byte[] TEXT_CONTENT_TYPE = EncodingUtils.toAsciiBytes("text/plain; charset=utf-8");
    private static final byte[] FILE_TRANSFER_ENCODING = EncodingUtils.toAsciiBytes("binary");
    private static final byte[] TEXT_TRANSFER_ENCODING = EncodingUtils.toAsciiBytes("8bit");
    private FieldSet parts;
    private byte[] boundary = null;

    public MultipartEntity(FieldSet parts) {
        this.parts = parts;
    }

    public FieldSet getParts() {
        return this.parts;
    }

    private byte[] getBoundary() {
        if (this.boundary != null) {
            return this.boundary;
        }
        Random rand = new Random();
        byte[] bytes = new byte[rand.nextInt(11) + 30];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = BOUNDARY_CHARS[rand.nextInt(BOUNDARY_CHARS.length)];
            ++i;
        }
        this.boundary = bytes;
        return this.boundary;
    }

    @Override
    public String getContentType() {
        StringBuffer typeBuffer = new StringBuffer(MULTIPART_CONTENT_TYPE);
        typeBuffer.append(EncodingUtils.toAsciiString(this.getBoundary()));
        return typeBuffer.toString();
    }

    private static String toSafeName(String name) {
        return name.replaceAll("\"", "%22");
    }

    @Override
    public long getContentLength() {
        if (this.parts.isEmpty()) {
            return 0L;
        }
        long length = 0L;
        for (Field part : this.parts) {
            length += (long)EXTRA.length;
            length += (long)this.getBoundary().length;
            length += (long)CRLF.length;
            length += (long)CONTENT_DISPOSITION.length;
            length += (long)QUOTE.length;
            length += (long)EncodingUtils.toAsciiBytes(MultipartEntity.toSafeName(part.name)).length;
            length += (long)QUOTE.length;
            length += (long)CRLF.length;
            if (part.value instanceof HttpEntity) {
                String fileName = ((HttpEntity)part.value).getFileName();
                if (fileName == null) {
                    fileName = part.name;
                }
                length += (long)FILE_NAME.length;
                length += (long)QUOTE.length;
                length += (long)EncodingUtils.toAsciiBytes(MultipartEntity.toSafeName(fileName)).length;
                length += (long)QUOTE.length;
            }
            length += (long)CONTENT_TYPE.length;
            length += (long)MultipartEntity.getContentType(part.value).length;
            length += (long)CRLF.length;
            length += (long)CONTENT_TRANSFER_ENCODING.length;
            length += (long)MultipartEntity.getTransferEncoding(part.value).length;
            length += (long)CRLF.length;
            length += (long)CRLF.length;
            length += MultipartEntity.getPartDataLength(part);
            length += (long)CRLF.length;
        }
        length += (long)EXTRA.length;
        length += (long)this.getBoundary().length;
        length += (long)EXTRA.length;
        return length += (long)CRLF.length;
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        if (this.parts.isEmpty()) {
            return;
        }
        for (Field part : this.parts) {
            stream.write(EXTRA);
            stream.write(this.getBoundary());
            stream.write(CRLF);
            stream.write(CONTENT_DISPOSITION);
            stream.write(QUOTE);
            stream.write(EncodingUtils.toAsciiBytes(MultipartEntity.toSafeName(part.name)));
            stream.write(QUOTE);
            if (part.value instanceof HttpEntity) {
                String fileName = ((HttpEntity)part.value).getFileName();
                if (fileName == null) {
                    fileName = part.name;
                }
                stream.write(FILE_NAME);
                stream.write(QUOTE);
                stream.write(EncodingUtils.toAsciiBytes(MultipartEntity.toSafeName(fileName)));
                stream.write(QUOTE);
            }
            stream.write(CRLF);
            stream.write(CONTENT_TYPE);
            stream.write(MultipartEntity.getContentType(part.value));
            stream.write(CRLF);
            stream.write(CONTENT_TRANSFER_ENCODING);
            stream.write(MultipartEntity.getTransferEncoding(part.value));
            stream.write(CRLF);
            stream.write(CRLF);
            MultipartEntity.writePartData(stream, part);
            stream.write(CRLF);
        }
        stream.write(EXTRA);
        stream.write(this.getBoundary());
        stream.write(EXTRA);
        stream.write(CRLF);
    }

    private static byte[] getContentType(Object value) {
        if (value instanceof HttpEntity) {
            return EncodingUtils.toAsciiBytes(((HttpEntity)value).getContentType());
        }
        return TEXT_CONTENT_TYPE;
    }

    private static byte[] getTransferEncoding(Object value) {
        if (value instanceof HttpEntity) {
            return FILE_TRANSFER_ENCODING;
        }
        return TEXT_TRANSFER_ENCODING;
    }

    private static long getPartDataLength(Field part) {
        if (part.value instanceof HttpEntity) {
            return ((HttpEntity)part.value).getContentLength();
        }
        return EncodingUtils.toAsciiBytes(part.getValue()).length;
    }

    private static void writePartData(OutputStream stream, Field part) throws IOException {
        if (part.value instanceof HttpEntity) {
            ((HttpEntity)part.value).writeTo(stream);
        } else {
            MultipartEntity.writeFromText(stream, part.getValue());
        }
    }

    private static void writeFromText(OutputStream writeStream, String encodedText) throws IOException {
        writeStream.write(encodedText.getBytes("UTF-8"));
    }
}

