/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.index.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.index.resource.AbstractIndexResource;
import org.xmind.ui.internal.index.resource.ITaskDateResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDateResourceForWorkbook
extends AbstractIndexResource
implements ITaskDateResource {
    private IWorkbook workbook;
    private int taskDateType;
    private Set<String> startDates = new HashSet<String>();
    private Map<String, Set<ITopic>> startDateToTopics = new HashMap<String, Set<ITopic>>();
    private Set<String> endDates = new HashSet<String>();
    private Map<String, Set<ITopic>> endDateToTopics = new HashMap<String, Set<ITopic>>();
    private Set<ITopic> allEndDateTopics = new HashSet<ITopic>();
    private Set<ITopic> allStartDateTopics = new HashSet<ITopic>();
    private Map<ITopic, String> topicToEndDate = new HashMap<ITopic, String>();
    private Map<ITopic, String> topicToStartDate = new HashMap<ITopic, String>();

    public TaskDateResourceForWorkbook(IWorkbook workbook, int taskDateType) {
        Assert.isNotNull((Object)workbook);
        this.workbook = workbook;
        this.taskDateType = taskDateType;
        this.init(false);
    }

    private void init(boolean update) {
        if (update) {
            this.startDates.clear();
            this.startDateToTopics.clear();
            this.endDates.clear();
            this.endDateToTopics.clear();
        }
        this.collectResourceForWorkbook(this.workbook);
    }

    @Override
    public Object getSource() {
        return this.workbook;
    }

    @Override
    public void reset(Object source, boolean update) {
        Assert.isNotNull((Object)source);
        this.workbook = (IWorkbook)source;
        this.init(update);
    }

    @Override
    protected void collectResourceForTopic(ITopic topic) {
        ITopicExtension ext = topic.getExtension("org.xmind.ui.taskInfo");
        if (ext == null) {
            return;
        }
        if (this.taskDateType == 4) {
            this.collectStartDateResource(topic, ext);
        } else if (this.taskDateType == 8) {
            this.collectEndDateResource(topic, ext);
        }
    }

    private void collectStartDateResource(ITopic topic, ITopicExtension ext) {
        ITopicExtensionElement content = ext.getContent();
        List children = content.getChildren("start-date");
        if (!children.isEmpty()) {
            for (ITopicExtensionElement element : children) {
                Set<ITopic> assignedTopics;
                String assignee = element.getTextContent();
                this.topicToStartDate.put(topic, assignee);
                this.allStartDateTopics.add(topic);
                if (this.startDateToTopics.containsKey(assignee)) {
                    assignedTopics = this.startDateToTopics.get(assignee);
                    if (assignedTopics == null) {
                        assignedTopics = new HashSet<ITopic>();
                        this.startDateToTopics.put(assignee, assignedTopics);
                    }
                    assignedTopics.add(topic);
                    continue;
                }
                this.startDates.add(assignee);
                assignedTopics = new HashSet<ITopic>();
                assignedTopics.add(topic);
                this.startDateToTopics.put(assignee, assignedTopics);
            }
        }
    }

    private void collectEndDateResource(ITopic topic, ITopicExtension ext) {
        ITopicExtensionElement content = ext.getContent();
        List children = content.getChildren("end-date");
        if (!children.isEmpty()) {
            for (ITopicExtensionElement element : children) {
                Set<ITopic> assignedTopics;
                String assignee = element.getTextContent();
                this.topicToEndDate.put(topic, assignee);
                this.allEndDateTopics.add(topic);
                if (this.endDateToTopics.containsKey(assignee)) {
                    assignedTopics = this.endDateToTopics.get(assignee);
                    if (assignedTopics == null) {
                        assignedTopics = new HashSet<ITopic>();
                        this.endDateToTopics.put(assignee, assignedTopics);
                    }
                    assignedTopics.add(topic);
                    continue;
                }
                this.endDates.add(assignee);
                assignedTopics = new HashSet<ITopic>();
                assignedTopics.add(topic);
                this.endDateToTopics.put(assignee, assignedTopics);
            }
        }
    }

    @Override
    public Set<String> getTaskDates() {
        if (this.taskDateType == 4) {
            return this.startDates;
        }
        if (this.taskDateType == 8) {
            return this.endDates;
        }
        return new HashSet<String>();
    }

    @Override
    public Set<ITopic> getTopics(String taskDate) {
        if (this.taskDateType == 4) {
            return this.startDateToTopics.get(taskDate);
        }
        if (this.taskDateType == 8) {
            return this.endDateToTopics.get(taskDate);
        }
        return new HashSet<ITopic>();
    }

    @Override
    public void setTaskDateResourceType(int type) {
        this.taskDateType = type;
    }

    @Override
    public Set<ITopic> getAllTopicsForTaskDate() {
        if (this.taskDateType == 4) {
            return this.allStartDateTopics;
        }
        if (this.taskDateType == 8) {
            return this.allEndDateTopics;
        }
        return new HashSet<ITopic>();
    }

    @Override
    public String getTaskDate(ITopic topic) {
        if (this.taskDateType == 4) {
            return this.topicToStartDate.get(topic);
        }
        if (this.taskDateType == 8) {
            return this.topicToEndDate.get(topic);
        }
        return null;
    }

    @Override
    public int getTaskDateResourceType() {
        return this.taskDateType;
    }
}

