/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.css;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.custom.CTabETabHelper;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyXShowCloseHandler
extends CTabETabHelper
implements ICSSPropertyHandler {
    public static final ICSSPropertyHandler INSTANCE = new CSSPropertyXShowCloseHandler();
    private static final String CSS_CTABITEM_SELECTED_SHOW_CLOSE_LISTENER_KEY = "CSS_CTABFOLDER_SELECTED_SHOW_CLOSE_LISTENER_KEY";
    private static final String SUPPORTED_PSEUDO = "selected";
    private static final String TAG_NOCLOSE = "NoClose";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget instanceof CTabItem) {
            Item item = (Item)widget;
            boolean showClose = (Boolean)engine.convert(value, Boolean.class, null);
            if (SUPPORTED_PSEUDO.equals(pseudo)) {
                Control parent = CSSPropertyXShowCloseHandler.getParent((Widget)widget);
                ShowCloseSelectionListener listener = (ShowCloseSelectionListener)parent.getData(CSS_CTABITEM_SELECTED_SHOW_CLOSE_LISTENER_KEY);
                if (listener == null) {
                    listener = new ShowCloseSelectionListener(engine);
                    parent.addListener(9, (Listener)listener);
                    parent.setData(CSS_CTABITEM_SELECTED_SHOW_CLOSE_LISTENER_KEY, (Object)listener);
                } else {
                    listener.setEngine(engine);
                }
                item = CSSPropertyXShowCloseHandler.getSelection((Widget)CSSPropertyXShowCloseHandler.getParent((Widget)widget));
                if (item != null) {
                    this.internalSetShowClose(item, showClose);
                }
            } else {
                this.internalSetShowClose(item, showClose);
            }
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget instanceof CTabItem) {
            CTabItem item = (CTabItem)widget;
            return Boolean.toString(item.getShowClose());
        }
        return null;
    }

    private void internalSetShowClose(Item item, boolean showClose) {
        boolean noClose;
        Object data = item.getData("modelElement");
        if (data instanceof MUIElement && (noClose = ((MUIElement)data).getTags().contains(TAG_NOCLOSE))) {
            boolean bl = showClose = !noClose;
        }
        if (item instanceof CTabItem) {
            ((CTabItem)item).setShowClose(showClose);
        }
    }

    private class ShowCloseSelectionListener
    implements Listener {
        private CSSEngine engine;

        public ShowCloseSelectionListener(CSSEngine engine) {
            this.engine = engine;
        }

        public void setEngine(CSSEngine engine) {
            this.engine = engine;
        }

        public void handleEvent(Event e) {
            CSSStyleDeclaration unselectedStyle;
            CSSValue value;
            Item selection = CSSPropertyXShowCloseHandler.getSelection((Widget)e.widget);
            if (selection == null || selection.isDisposed()) {
                return;
            }
            Item[] items = CSSPropertyXShowCloseHandler.getItems((Widget)e.widget);
            int selectionIndex = CSSPropertyXShowCloseHandler.getSelectionIndex((Widget)e.widget);
            boolean selectionSet = false;
            CSSStyleDeclaration selectedStyle = this.engine.getViewCSS().getComputedStyle(this.engine.getElement((Object)selection), CSSPropertyXShowCloseHandler.SUPPORTED_PSEUDO);
            if (selectedStyle != null && (value = selectedStyle.getPropertyCSSValue("xmind-swt-show-close")) != null) {
                CSSPropertyXShowCloseHandler.this.internalSetShowClose(selection, Boolean.parseBoolean(value.getCssText()));
                selectionSet = true;
            }
            if ((unselectedStyle = this.engine.getViewCSS().getComputedStyle(this.engine.getElement((Object)selection), null)) == null) {
                int i = 0;
                while (i < items.length) {
                    if (selectionSet && i != selectionIndex) {
                        CSSPropertyXShowCloseHandler.this.internalSetShowClose(items[i], false);
                    }
                    ++i;
                }
            } else {
                CSSValue value2 = unselectedStyle.getPropertyCSSValue("xmind-swt-show-close");
                boolean unselectedShowClose = value2 == null ? false : Boolean.parseBoolean(value2.getCssText());
                int i = 0;
                while (i < items.length) {
                    if (selectionSet && i != selectionIndex) {
                        CSSPropertyXShowCloseHandler.this.internalSetShowClose(items[i], unselectedShowClose);
                    }
                    ++i;
                }
            }
        }
    }
}

