/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.internal.wizards.XMind2008Importer;
import org.xmind.ui.wizards.AbstractMindMapImportPage;
import org.xmind.ui.wizards.AbstractMindMapImportWizard;
import org.xmind.ui.wizards.MindMapImporter;

public class XMind2008ImportWizard
extends AbstractMindMapImportWizard {
    private static final String SETTINGS_ID = "org.xmind.ui.import.xmind2008";
    private static final String PAGE_ID = "importXMind2008";
    private static final String EXT = "*.xmap";
    private XMind2008ImportPage page;

    public XMind2008ImportWizard() {
        IDialogSettings settings = MindMapUIPlugin.getDefault().getDialogSettings(SETTINGS_ID);
        this.setDialogSettings(settings);
        this.setWindowTitle(WizardMessages.XMind2008ImportWizard_windowTitle);
    }

    public void addPages() {
        this.page = new XMind2008ImportPage();
        this.addPage((IWizardPage)this.page);
    }

    @Override
    protected MindMapImporter createImporter(String sourcePath, IWorkbook targetWorkbook) {
        return new XMind2008Importer(sourcePath, targetWorkbook);
    }

    @Override
    protected String getApplicationId() {
        return "XMind2008";
    }

    @Override
    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private class XMind2008ImportPage
    extends AbstractMindMapImportPage {
        protected XMind2008ImportPage() {
            super(XMind2008ImportWizard.PAGE_ID, WizardMessages.XMind2008ImportPage_title);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            Control destinationControl = this.createDestinationControl(composite);
            destinationControl.setLayoutData((Object)new GridData(4, 4, true, true));
            this.updateStatus();
            parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XMind2008ImportPage.this.openBrowseDialog();
                }
            });
        }

        @Override
        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            dialog.setFilterExtensions(new String[]{XMind2008ImportWizard.EXT});
            dialog.setFilterNames(new String[]{NLS.bind((String)WizardMessages.XMind2008MindImportPage_FilterName, (Object)XMind2008ImportWizard.EXT)});
            return dialog;
        }
    }
}

