/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.ILegendItemPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.tools.DummyMoveTool;

public class LegendMoveTool
extends DummyMoveTool {
    private int oldAlpha = -1;
    private Point oldPosition = null;

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((source instanceof ILegendPart || source instanceof ILegendItemPart ? 1 : 0) != 0);
        super.setSource(source);
    }

    protected ILegendPart getLegendPart() {
        if (this.getSource() instanceof ILegendPart) {
            return (ILegendPart)this.getSource();
        }
        if (this.getSource() instanceof ILegendItemPart) {
            return ((ILegendItemPart)this.getSource()).getOwnedLegend();
        }
        return null;
    }

    @Override
    protected IFigure createDummy() {
        ILegendPart legend = this.getLegendPart();
        IFigure figure = legend.getFigure();
        if (figure instanceof IReferencedFigure) {
            IReferencedFigure refFigure = (IReferencedFigure)figure;
            Point ref = refFigure.getReference();
            Point origin = refFigure.getOrigin();
            this.oldPosition = new Point(ref.x - origin.x, ref.y - origin.y);
        }
        if (figure instanceof IUseTransparency) {
            this.oldAlpha = ((IUseTransparency)figure).getMainAlpha();
            ((IUseTransparency)figure).setMainAlpha(128);
        }
        figure.setEnabled(false);
        return figure;
    }

    @Override
    protected void destroyDummy(IFigure dummy) {
        dummy.setEnabled(true);
        if (dummy instanceof IUseTransparency && this.oldAlpha >= 0) {
            ((IUseTransparency)dummy).setMainAlpha(this.oldAlpha);
        }
        dummy.revalidate();
    }

    @Override
    protected Request createRequest() {
        Request request = null;
        if (this.oldPosition != null) {
            request = new Request("move to");
            request.setPrimaryTarget((IPart)this.getLegendPart());
            Dimension diff = this.getCursorPosition().getDifference(this.getStartingPosition());
            Point newPosition = this.oldPosition.getTranslated(diff);
            request.setParameter("position", (Object)newPosition);
            this.oldPosition = null;
        }
        return request;
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        return Cursors.HAND;
    }
}

