/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;
import org.xmind.core.INotes;
import org.xmind.core.INotesContent;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyNotesCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.internal.notes.RichDocumentNotesAdapter;
import org.xmind.ui.internal.notes.TopicNotesViewer;
import org.xmind.ui.internal.spellsupport.SpellingSupport;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentListener;
import org.xmind.ui.richtext.IRichTextAction;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;
import org.xmind.ui.richtext.SimpleRichTextActionBarContributor;
import org.xmind.ui.texteditor.IMenuContributor;
import org.xmind.ui.texteditor.ISpellingActivation;

public class NotesPopup
extends PopupDialog
implements IDocumentListener,
IRichDocumentListener,
ISelectionChangedListener {
    private static final String CONTEXT_ID = "org.xmind.ui.context.notesPopup";
    private static final String CMD_GOTO_NOTES_VIEW = "org.xmind.ui.command.gotoNotesView";
    private static final String CMD_COMMIT_NOTES = "org.xmind.ui.command.commitNotes";
    private IWorkbenchWindow window;
    private ITopicPart topicPart;
    private TopicNotesViewer notesViewer;
    private NotesPopupActionBarContributor contributor;
    private RichDocumentNotesAdapter notesAdapter;
    private Map<TriggerSequence, String> triggerableCommands = new HashMap<TriggerSequence, String>(3);
    private IContextActivation contextActivation;
    private IContextService contextService;
    private IBindingService bindingService;
    private boolean showGotoNotesPart;
    private boolean editable;
    private boolean updating = false;
    private ISpellingActivation spellingActivation;
    private ICoreEventRegistration saveNotesReg;

    public NotesPopup(IWorkbenchWindow window, ITopicPart topicPart, boolean editable, boolean showGotoNotesView) {
        super(window.getShell(), 16, true, true, true, false, false, null, showGotoNotesView ? "" : null);
        this.window = window;
        this.topicPart = topicPart;
        this.showGotoNotesPart = showGotoNotesView;
        this.editable = editable;
    }

    public NotesPopup(Shell parentShell, ITopicPart topicPart, boolean editable) {
        super(parentShell, 11, true, true, true, false, false, null, null);
        this.topicPart = topicPart;
        this.window = null;
        this.showGotoNotesPart = false;
        this.editable = editable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.notesViewer = new TopicNotesViewer();
        if (this.editable) {
            this.contributor = new NotesPopupActionBarContributor();
            this.notesViewer.setContributor((IRichTextActionBarContributor)this.contributor);
        }
        int style = 834;
        if (!this.editable) {
            style |= 8;
        }
        this.notesViewer.createControl(composite, style);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        this.notesViewer.getControl().setLayoutData((Object)gridData);
        ITopic topic = this.topicPart.getTopic();
        this.notesAdapter = new RichDocumentNotesAdapter(topic);
        this.notesViewer.setInput(this.notesAdapter);
        this.notesViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NotesPopup.this.notesAdapter != null) {
                    NotesPopup.this.notesAdapter.dispose();
                    NotesPopup.this.notesAdapter = null;
                }
            }
        });
        this.notesViewer.getImplementation().addSelectionChangedListener((ISelectionChangedListener)this);
        this.notesViewer.getImplementation().getDocument().addDocumentListener((IDocumentListener)this);
        this.notesViewer.getImplementation().getDocument().addRichDocumentListener((IRichDocumentListener)this);
        new PopupKeyboardListener().hook(this.notesViewer.getImplementation().getFocusControl());
        this.update();
        this.addSpellCheck();
        return composite;
    }

    private void addSpellCheck() {
        this.spellingActivation = SpellingSupport.getInstance().activateSpelling((ITextViewer)this.notesViewer.getImplementation().getTextViewer());
    }

    public TopicNotesViewer getNotesViewer() {
        return this.notesViewer;
    }

    public RichDocumentNotesAdapter getNotesAdapter() {
        return this.notesAdapter;
    }

    public ITopicPart getTopicPart() {
        return this.topicPart;
    }

    protected Control getFocusControl() {
        return this.notesViewer.getImplementation().getFocusControl();
    }

    protected Point getInitialLocation(Point initialSize) {
        IViewer viewer = this.topicPart.getSite().getViewer();
        Rectangle bounds = this.topicPart.getFigure().getBounds().getCopy();
        return this.calcInitialLocation((IGraphicalViewer)viewer, bounds);
    }

    private Point calcInitialLocation(IGraphicalViewer viewer, Rectangle bounds) {
        ZoomManager zoom = viewer.getZoomManager();
        bounds = bounds.scale(zoom.getScale()).expand(1, 1).translate(viewer.getScrollPosition().getNegated());
        return viewer.getControl().toDisplay(bounds.x, bounds.y + bounds.height);
    }

    protected List getBackgroundColorExclusions() {
        List list = super.getBackgroundColorExclusions();
        this.collectBackgroundColorExclusions(this.notesViewer.getControl(), list);
        return list;
    }

    private void collectBackgroundColorExclusions(Control control, List list) {
        list.add(control);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.collectBackgroundColorExclusions(child, list);
                ++n2;
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        return MindMapUIPlugin.getDefault().getDialogSettings("org.xmind.ui.popupDialog");
    }

    public int open() {
        int ret;
        IWorkbench workbench = this.window.getWorkbench();
        this.bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
        this.contextService = (IContextService)workbench.getAdapter(IContextService.class);
        if (this.bindingService != null) {
            this.registerWorkbenchCommands();
        }
        if ((ret = super.open()) == 0) {
            if (this.contextService != null) {
                this.contextActivation = this.contextService.activateContext(CONTEXT_ID);
            }
            if (this.bindingService != null) {
                this.registerDialogCommands();
            }
        }
        this.activateJob();
        return ret;
    }

    private void activateJob() {
        IWorkbook workbook;
        IEditorPart editorPart;
        if (this.saveNotesReg != null && this.saveNotesReg.isValid()) {
            return;
        }
        this.saveNotesReg = null;
        if (this.window != null && (editorPart = this.window.getActivePage().getActiveEditor()) != null && editorPart instanceof MindMapEditor && (workbook = ((MindMapEditor)editorPart).getWorkbook()) instanceof ICoreEventSource2) {
            this.saveNotesReg = ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
        }
    }

    protected void registerDialogCommands() {
        TriggerSequence key;
        if (this.showGotoNotesPart && (key = this.registerCommand(CMD_GOTO_NOTES_VIEW)) != null) {
            this.setInfoText(NLS.bind((String)DialogMessages.NotesPopup_GotoNotesView_text, (Object)key.format()));
        }
        this.registerCommand(CMD_COMMIT_NOTES);
        for (String commandId : this.contributor.getTextCommandIds()) {
            this.registerCommand(commandId);
        }
    }

    protected void registerWorkbenchCommands() {
        this.registerCommand("org.eclipse.ui.file.save");
        this.registerCommand("org.eclipse.ui.edit.undo");
        this.registerCommand("org.eclipse.ui.edit.redo");
        this.registerCommand("org.eclipse.ui.edit.cut");
        this.registerCommand("org.eclipse.ui.edit.copy");
        this.registerCommand("org.eclipse.ui.edit.paste");
        this.registerCommand("org.eclipse.ui.edit.selectAll");
    }

    protected TriggerSequence registerCommand(String commandId) {
        if (this.bindingService == null) {
            return null;
        }
        TriggerSequence key = this.bindingService.getBestActiveBindingFor(commandId);
        if (key != null) {
            this.triggerableCommands.put(key, commandId);
        }
        return key;
    }

    protected boolean handleCommand(String commandId) {
        if (CMD_GOTO_NOTES_VIEW.equals(commandId)) {
            if (this.showGotoNotesPart) {
                this.gotoNotesPart();
            }
            return true;
        }
        if (CMD_COMMIT_NOTES.equals(commandId)) {
            this.setReturnCode(0);
            this.close();
            return true;
        }
        if ("org.eclipse.ui.file.save".equals(commandId)) {
            this.saveNotes();
            return true;
        }
        IAction action = this.contributor.getActionHandler(commandId);
        if (action != null && action.isEnabled()) {
            if (action.getStyle() == 2) {
                action.setChecked(!action.isChecked());
            }
            action.run();
            return true;
        }
        return false;
    }

    public boolean close() {
        if (this.contextActivation != null && this.contextService != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        this.deactivateJob();
        if (this.getReturnCode() == 0) {
            this.saveNotes();
        }
        return super.close();
    }

    private void deactivateJob() {
        if (this.saveNotesReg != null) {
            this.saveNotesReg.unregister();
            this.saveNotesReg = null;
        }
    }

    private void saveNotes() {
        if (this.notesAdapter == null || this.notesViewer == null || this.notesViewer.getControl().isDisposed() || !this.notesViewer.hasModified()) {
            return;
        }
        this.doSaveNotes();
        this.notesViewer.resetModified();
    }

    private void doSaveNotes() {
        ICommandStack cs;
        INotesContent html = this.notesAdapter.makeNewHtmlContent();
        INotesContent plain = this.notesAdapter.makeNewPlainContent();
        ITopic topic = this.topicPart.getTopic();
        EditDomain domain = this.topicPart.getSite().getViewer().getEditDomain();
        if (domain != null && (cs = domain.getCommandStack()) != null) {
            ModifyNotesCommand modifyHtml = new ModifyNotesCommand(topic, html, "html");
            ModifyNotesCommand modifyPlain = new ModifyNotesCommand(topic, plain, "plain");
            CompoundCommand cmd = new CompoundCommand(new Command[]{modifyHtml, modifyPlain});
            cmd.setLabel(CommandMessages.Command_ModifyNotes);
            cs.execute((Command)cmd);
            return;
        }
        INotes notes = topic.getNotes();
        notes.setContent("html", html);
        notes.setContent("plain", plain);
    }

    private void gotoNotesPart() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (NotesPopup.this.window == null) {
                    return;
                }
                NotesPopup.this.close();
                E4Utils.showPart("org.xmind.ui.command.showModelPart", NotesPopup.this.window, "org.xmind.ui.modelPart.notes", null, "org.xmind.ui.stack.right");
            }
        });
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.update();
    }

    public void hyperlinkChanged(IRichDocument document, Hyperlink[] oldHyperlinks, Hyperlink[] newHyperlinks) {
        this.update();
    }

    public void imageChanged(IRichDocument document, ImagePlaceHolder[] oldImages, ImagePlaceHolder[] newImages) {
        this.update();
    }

    public void lineStyleChanged(IRichDocument document, LineStyle[] oldLineStyles, LineStyle[] newLineStyles) {
        this.update();
    }

    public void textStyleChanged(IRichDocument document, StyleRange[] oldTextStyles, StyleRange[] newTextStyles) {
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    private void update() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                NotesPopup.this.updateTextActions();
                NotesPopup.this.updating = false;
            }
        });
        this.doSaveNotes();
    }

    private void updateTextActions() {
        if (this.notesViewer == null || this.notesViewer.getControl().isDisposed() || this.contributor == null) {
            return;
        }
        TextViewer textViewer = this.notesViewer.getImplementation().getTextViewer();
        if (textViewer != null) {
            this.contributor.update(textViewer);
        }
    }

    private class NotesPopupActionBarContributor
    extends SimpleRichTextActionBarContributor {
        private Map<String, TextAction> textActions = new HashMap<String, TextAction>(10);
        private Map<String, IAction> actionHandlers = new HashMap<String, IAction>(10);
        private Collection<String> textCommandIds = new HashSet<String>(10);

        private NotesPopupActionBarContributor() {
        }

        protected void makeActions(IRichTextEditViewer viewer) {
            super.makeActions(viewer);
            this.addWorkbenchAction(ActionFactory.UNDO, 1);
            this.addWorkbenchAction(ActionFactory.REDO, 2);
            this.addWorkbenchAction(ActionFactory.CUT, 3);
            this.addWorkbenchAction(ActionFactory.COPY, 4);
            this.addWorkbenchAction(ActionFactory.PASTE, 5);
            this.addWorkbenchAction(ActionFactory.SELECT_ALL, 7);
            this.registerTextCommand("bold", "org.xmind.ui.command.text.bold");
            this.registerTextCommand("italic", "org.xmind.ui.command.text.italic");
            this.registerTextCommand("underline", "org.xmind.ui.command.text.underline");
            this.registerTextCommand("leftAlign", "org.xmind.ui.command.text.leftAlign");
            this.registerTextCommand("centerAlign", "org.xmind.ui.command.text.centerAlign");
            this.registerTextCommand("rightAlign", "org.xmind.ui.command.text.rightAlign");
        }

        private void addWorkbenchAction(ActionFactory factory, int textOp) {
            ActionFactory.IWorkbenchAction action = factory.create(NotesPopup.this.window);
            TextAction textAction = new TextAction(textOp);
            textAction.setId(action.getId());
            textAction.setActionDefinitionId(action.getActionDefinitionId());
            textAction.setText(action.getText());
            textAction.setToolTipText(action.getToolTipText());
            textAction.setDescription(action.getDescription());
            textAction.setImageDescriptor(action.getImageDescriptor());
            textAction.setDisabledImageDescriptor(action.getDisabledImageDescriptor());
            textAction.setHoverImageDescriptor(action.getHoverImageDescriptor());
            action.dispose();
            this.actionHandlers.put(action.getActionDefinitionId(), (IAction)textAction);
            this.textActions.put(textAction.getId(), textAction);
        }

        private void registerTextCommand(String actionId, String commandId) {
            IRichTextAction action = this.getRichTextAction(actionId);
            if (action != null) {
                action.setActionDefinitionId(commandId);
                this.actionHandlers.put(commandId, (IAction)action);
                this.textCommandIds.add(commandId);
            }
        }

        public void fillToolBar(IToolBarManager toolbar) {
            super.fillToolBar(toolbar);
            if (NotesPopup.this.showGotoNotesPart) {
                toolbar.add((IContributionItem)new Separator());
                toolbar.add((IAction)new GotoNotesPartAction());
            }
        }

        public void fillContextMenu(IMenuManager menu) {
            IMenuContributor contributor;
            menu.add(this.getTextAction(ActionFactory.UNDO.getId()));
            menu.add(this.getTextAction(ActionFactory.REDO.getId()));
            menu.add((IContributionItem)new Separator());
            menu.add(this.getTextAction(ActionFactory.CUT.getId()));
            menu.add(this.getTextAction(ActionFactory.COPY.getId()));
            menu.add(this.getTextAction(ActionFactory.PASTE.getId()));
            menu.add((IContributionItem)new Separator());
            menu.add(this.getTextAction(ActionFactory.SELECT_ALL.getId()));
            menu.add((IContributionItem)new Separator());
            super.fillContextMenu(menu);
            if (NotesPopup.this.spellingActivation != null && (contributor = (IMenuContributor)NotesPopup.this.spellingActivation.getAdapter(IMenuContributor.class)) != null) {
                menu.add((IContributionItem)new Separator());
                contributor.fillMenu(menu);
            }
        }

        public void dispose() {
            this.actionHandlers.clear();
            this.textActions.clear();
            super.dispose();
        }

        public void update(TextViewer textViewer) {
            for (TextAction action : this.textActions.values()) {
                action.update(textViewer);
            }
        }

        public IAction getActionHandler(String commandId) {
            return this.actionHandlers.get(commandId);
        }

        public IAction getTextAction(String actionId) {
            return (IAction)this.textActions.get(actionId);
        }

        public Collection<String> getTextCommandIds() {
            return this.textCommandIds;
        }

        private class GotoNotesPartAction
        extends Action {
            public GotoNotesPartAction() {
                super(MindMapMessages.EditInNotesView_text);
                this.setToolTipText(MindMapMessages.EditInNotesView_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("notes_part.png", true));
                this.setDisabledImageDescriptor(MindMapUI.getImages().get("notes_part.png", false));
            }

            public void run() {
                NotesPopup.this.gotoNotesPart();
            }
        }
    }

    private class PopupKeyboardListener
    implements Listener {
        private List<TriggerSequence> currentSequences = null;
        private int nextKeyIndex = -1;

        private PopupKeyboardListener() {
        }

        public void hook(Control control) {
            control.getDisplay().addFilter(1, (Listener)this);
            control.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!e.display.isDisposed()) {
                        e.display.removeFilter(1, (Listener)PopupKeyboardListener.this);
                    }
                }
            });
        }

        public void handleEvent(Event event) {
            if (event.type == 1) {
                this.handleKeyDown(event);
            }
            NotesPopup.this.update();
        }

        private void handleKeyDown(Event event) {
            if (NotesPopup.this.triggerableCommands.isEmpty()) {
                return;
            }
            List<KeyStroke> keys = this.generateKeyStrokes(event);
            if (this.currentSequences == null) {
                this.nextKeyIndex = -1;
                for (TriggerSequence ts : NotesPopup.this.triggerableCommands.keySet()) {
                    if (!this.matches(keys, ts.getTriggers()[0])) continue;
                    if (this.currentSequences == null) {
                        this.currentSequences = new ArrayList<TriggerSequence>(NotesPopup.this.triggerableCommands.size());
                    }
                    this.currentSequences.add(ts);
                }
                if (this.currentSequences == null) {
                    return;
                }
            }
            if (this.nextKeyIndex < 0) {
                this.nextKeyIndex = 0;
            }
            Iterator<TriggerSequence> it = this.currentSequences.iterator();
            while (it.hasNext()) {
                TriggerSequence ts = it.next();
                Trigger[] triggers = ts.getTriggers();
                if (this.nextKeyIndex >= triggers.length) {
                    it.remove();
                    continue;
                }
                if (this.matches(keys, triggers[this.nextKeyIndex])) {
                    if (this.nextKeyIndex != triggers.length - 1) continue;
                    if (this.triggerFound(ts)) {
                        event.doit = false;
                    }
                    return;
                }
                it.remove();
            }
            if (this.currentSequences != null && this.currentSequences.isEmpty()) {
                ++this.nextKeyIndex;
            } else {
                this.currentSequences = null;
                this.nextKeyIndex = -1;
            }
        }

        private boolean triggerFound(TriggerSequence triggerSequence) {
            this.currentSequences = null;
            this.nextKeyIndex = -1;
            String commandId = (String)NotesPopup.this.triggerableCommands.get(triggerSequence);
            if (commandId != null) {
                return NotesPopup.this.handleCommand(commandId);
            }
            return false;
        }

        private boolean matches(List<KeyStroke> keys, Trigger expected) {
            for (KeyStroke key : keys) {
                if (!key.equals((Object)expected)) continue;
                return true;
            }
            return false;
        }

        private List<KeyStroke> generateKeyStrokes(Event event) {
            int thirdAccelerator;
            ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
            if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
                return keyStrokes;
            }
            int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)firstAccelerator));
            if (event.character == '\u007f') {
                return keyStrokes;
            }
            int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
            if (secondAccelerator != firstAccelerator) {
                keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)secondAccelerator));
            }
            if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
                keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)thirdAccelerator));
            }
            return keyStrokes;
        }
    }

    private class TextAction
    extends Action {
        private int op;
        private TextViewer textViewer;

        public TextAction(int op) {
            this.op = op;
        }

        public void run() {
            if (this.textViewer == null) {
                this.textViewer = NotesPopup.this.notesViewer.getImplementation().getTextViewer();
            }
            if (this.textViewer != null && this.textViewer.canDoOperation(this.op)) {
                this.textViewer.doOperation(this.op);
            }
        }

        public void update(TextViewer textViewer) {
            this.setEnabled(textViewer.canDoOperation(this.op));
        }
    }
}

