/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.Page;
import org.xmind.ui.internal.editor.IDialogPane;
import org.xmind.ui.internal.editor.IDialogPaneContainer;

public abstract class DialogPane
extends Page
implements IDialogPane {
    private static final float CORNER_OFFSET = 20.0f;
    private static final float CORNER_CONTROL_OFFSET = 5.0f;
    private static final String DEFAULT_BUTTON_TRIGGER_EVENT_ID = "DEFAULT_BUTTON_TRIGGER_EVENT_ID";
    private int returnCode = 0;
    private IDialogPaneContainer paneContainer;
    private Map<Integer, Button> buttons;
    private int defaultButtonId = -1;
    private Font defaultFont;
    private Composite container;
    private Listener defaultButtonListener;
    private Listener escapeKeyListener;

    @Override
    public void init(IDialogPaneContainer paneContainer) {
        this.paneContainer = paneContainer;
    }

    protected IDialogPaneContainer getPaneContainer() {
        return this.paneContainer;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setBackground(parent.getDisplay().getSystemColor(25));
        this.paintCornersFor(this.container, parent.getBackground());
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
        gridData.widthHint = this.getPreferredWidth();
        gridData.heightHint = -1;
        this.container.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 30;
        gridLayout.marginHeight = 20;
        gridLayout.marginTop = 10;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        this.container.setLayout((Layout)gridLayout);
        Control contents = this.createDialogContents(this.container);
        GridData gridData2 = new GridData(4, 4, true, false);
        gridData2.widthHint = -1;
        gridData2.heightHint = -1;
        contents.setLayoutData((Object)gridData2);
        this.createButtonBar(this.container);
        this.container.addListener(31, this.getEscapeKeyListener());
    }

    protected int getPreferredWidth() {
        return 400;
    }

    protected void paintCornersFor(Composite control, final Color background) {
        if (background == null) {
            return;
        }
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Control c = (Control)e.widget;
                Rectangle b = c.getBounds();
                float x1 = 0.0f;
                float y1 = 0.0f;
                float x2 = x1 + (float)b.width;
                float y2 = y1 + (float)b.height;
                Path p = new Path((Device)e.display);
                p.moveTo(x1, y1);
                p.lineTo(x1 + 20.0f, y1);
                p.cubicTo(x1 + 5.0f, y1, x1, y1 + 5.0f, x1, y1 + 20.0f);
                p.close();
                p.moveTo(x2, y2);
                p.lineTo(x2 - 20.0f, y2);
                p.cubicTo(x2 - 5.0f, y2, x2, y2 - 5.0f, x2, y2 - 20.0f);
                p.close();
                e.gc.setAntialias(1);
                e.gc.setBackground(background);
                e.gc.fillPath(p);
                p.dispose();
            }
        });
    }

    protected Control createDialogContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        return composite;
    }

    protected Composite getContainer() {
        return this.container;
    }

    public Control getControl() {
        return this.container;
    }

    @Override
    public abstract void setFocus();

    public void dispose() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
        this.buttons = null;
    }

    protected abstract void createButtonsForButtonBar(Composite var1);

    protected boolean buttonPressed(int buttonId) {
        if (buttonId == 0) {
            return this.okPressed();
        }
        if (buttonId == 12) {
            return this.closePressed();
        }
        if (buttonId == 1) {
            return this.cancelPressed();
        }
        return false;
    }

    protected boolean cancelPressed() {
        return false;
    }

    protected boolean closePressed() {
        return false;
    }

    protected boolean okPressed() {
        return false;
    }

    protected void createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        buttonBar.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 5;
        buttonBar.setLayout((Layout)gridLayout);
        this.createBlankArea(buttonBar);
        this.createButtonsForButtonBar(buttonBar);
        this.adjustButtonWidths(buttonBar);
    }

    protected void createBlankArea(Composite buttonBar) {
        Label blank = new Label(buttonBar, 0);
        blank.setBackground(buttonBar.getBackground());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = -1;
        gridData.heightHint = 1;
        blank.setLayoutData((Object)gridData);
    }

    protected Button createButton(Composite buttonBar, int id, String label, boolean defaultButton) {
        ++((GridLayout)buttonBar.getLayout()).numColumns;
        Button button = new Button(buttonBar, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int pressId = (Integer)event.widget.getData();
                DialogPane.this.buttonPressed(pressId);
            }
        });
        if (defaultButton) {
            this.defaultButtonId = id;
        }
        if (this.buttons == null) {
            this.buttons = new HashMap<Integer, Button>();
        }
        this.buttons.put(new Integer(id), button);
        this.setButtonLayoutData(button);
        return button;
    }

    protected Button getButton(int id) {
        return this.buttons == null ? null : this.buttons.get(id);
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        button.setLayoutData((Object)gridData);
    }

    private void adjustButtonWidths(Composite buttonBar) {
        if (this.buttons == null) {
            return;
        }
        int maxWidth = 90;
        for (Button b : this.buttons.values()) {
            int width = b.computeSize((int)-1, (int)-1).x;
            maxWidth = Math.max(maxWidth, width);
        }
        for (Button b : this.buttons.values()) {
            ((GridData)b.getLayoutData()).widthHint = maxWidth + 2;
        }
    }

    protected void addRefreshDefaultButtonListener(Control focusControl) {
        focusControl.addListener(15, this.getDefaultButtonListener());
        focusControl.addListener(16, this.getDefaultButtonListener());
    }

    protected void addTriggerDefaultButtonListener(Control control, int triggerEvent) {
        control.addListener(triggerEvent, this.getDefaultButtonListener());
        control.setData(DEFAULT_BUTTON_TRIGGER_EVENT_ID, (Object)triggerEvent);
    }

    private Listener getDefaultButtonListener() {
        if (this.defaultButtonListener == null) {
            this.defaultButtonListener = new Listener(){
                private Button savedDefaultButton = null;

                public void handleEvent(Event event) {
                    Object triggerEvent = event.widget.getData(DialogPane.DEFAULT_BUTTON_TRIGGER_EVENT_ID);
                    if (triggerEvent instanceof Integer && event.type == (Integer)triggerEvent) {
                        DialogPane.this.triggerDefaultButton();
                        return;
                    }
                    if (event.type == 15) {
                        this.changeDefaultButton();
                    } else if (event.type == 16) {
                        this.restoreDefaultButton();
                    }
                }

                private void restoreDefaultButton() {
                    if (DialogPane.this.defaultButtonId >= 0) {
                        Shell shell = DialogPane.this.container.getShell();
                        if (this.savedDefaultButton != null && this.savedDefaultButton.isDisposed()) {
                            this.savedDefaultButton = null;
                        }
                        shell.setDefaultButton(this.savedDefaultButton);
                    }
                }

                private void changeDefaultButton() {
                    if (DialogPane.this.defaultButtonId >= 0) {
                        final Shell shell = DialogPane.this.container.getShell();
                        this.savedDefaultButton = shell.getDefaultButton();
                        shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Button button = DialogPane.this.getButton(DialogPane.this.defaultButtonId);
                                if (button != null && !button.isDisposed()) {
                                    shell.setDefaultButton(button);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.defaultButtonListener;
    }

    private Listener getEscapeKeyListener() {
        if (this.escapeKeyListener == null) {
            this.escapeKeyListener = new Listener(){

                public void handleEvent(Event event) {
                    if (this.isEscapeKeyPressed(event)) {
                        DialogPane.this.escapeKeyPressed();
                        event.doit = false;
                    }
                }

                private boolean isEscapeKeyPressed(Event event) {
                    return event.type == 31 && event.detail == 2 || event.type == 1 && event.keyCode == 27 && event.stateMask == 0;
                }
            };
        }
        return this.escapeKeyListener;
    }

    protected void escapeKeyPressed() {
        this.triggerButton(1);
    }

    protected Button getDefaultButton() {
        if (this.buttons != null && this.defaultButtonId >= 0) {
            return this.getButton(this.defaultButtonId);
        }
        return null;
    }

    protected void triggerDefaultButton() {
        this.triggerButton(this.defaultButtonId);
    }

    protected boolean triggerButton(int buttonId) {
        Button button;
        if (buttonId >= 0 && (button = this.getButton(buttonId)) != null && !button.isDisposed() && button.isEnabled()) {
            return this.buttonPressed(buttonId);
        }
        return false;
    }

    protected void applyFont(Control control) {
        if (this.defaultFont != null) {
            control.setFont(this.defaultFont);
        }
    }

    protected void hookText(final Text text) {
        text.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                text.selectAll();
            }
        });
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    protected void relayout() {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        this.container.getParent().layout(true);
    }

    @Override
    public void setReturnCode(int code) {
        this.returnCode = code;
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    protected boolean close() {
        return this.paneContainer.close();
    }
}

