/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.CompoundDecoration;
import org.xmind.gef.draw2d.decoration.IConnectionDecoration;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.ILineDecoration;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.IBranchConnections;

public class BranchConnections
extends CompoundDecoration
implements IBranchConnections,
IShadowedDecoration {
    private IAnchor sourceAnchor;
    private Color lineColor = null;
    private int lineStyle = 1;
    private int lineWidth = 1;
    private int sourceOrientation = 0;
    private int sourceExpansion = 0;
    private boolean tapered = false;
    private int cornerSize = 0;

    public void paintShadow(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        for (IDecoration decoration : this.getDecorations()) {
            if (!(decoration instanceof IShadowedDecoration)) continue;
            ((IShadowedDecoration)decoration).paintShadow(figure, graphics);
        }
    }

    @Override
    public void setSourceAnchor(IFigure figure, IAnchor anchor) {
        if (anchor == this.sourceAnchor) {
            return;
        }
        this.sourceAnchor = anchor;
        this.updateAnchors(figure);
    }

    private void updateAnchors(IFigure figure) {
        for (IDecoration decoration : this.getDecorations()) {
            this.updateAnchor(figure, decoration);
        }
    }

    private void updateAnchor(IFigure figure, IDecoration decoration) {
        if (decoration instanceof IConnectionDecoration) {
            ((IConnectionDecoration)decoration).setSourceAnchor(figure, this.getSourceAnchor());
        }
    }

    @Override
    public void rerouteAll(IFigure figure) {
        int size = this.size();
        int i = 0;
        while (i < size) {
            IDecoration decoration = this.getDecoration(i);
            if (decoration instanceof IConnectionDecoration) {
                ((IConnectionDecoration)decoration).reroute(figure);
            }
            ++i;
        }
        if (figure != null) {
            this.repaint(figure);
        }
    }

    protected void update(IFigure figure, IDecoration decoration) {
        super.update(figure, decoration);
        this.updateAnchor(figure, decoration);
        this.updateConnection(figure, decoration);
    }

    @Override
    public IAnchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    protected void update(IFigure figure) {
        for (IDecoration decoration : this.getDecorations()) {
            if (decoration == null) continue;
            this.update(figure, decoration);
        }
    }

    protected void updateConnection(IFigure figure, IDecoration decoration) {
        if (decoration instanceof ICorneredDecoration) {
            ((ICorneredDecoration)decoration).setCornerSize(figure, this.cornerSize);
        }
        if (decoration instanceof ILineDecoration) {
            ILineDecoration line = (ILineDecoration)decoration;
            line.setLineStyle(figure, this.getLineStyle());
            line.setLineWidth(figure, this.getLineWidth());
        }
        if (decoration instanceof IBranchConnectionDecoration) {
            IBranchConnectionDecoration conn = (IBranchConnectionDecoration)decoration;
            conn.setSourceOrientation(figure, this.sourceOrientation);
            conn.setSourceExpansion(figure, this.sourceExpansion);
            conn.setTapered(figure, this.tapered);
        }
    }

    public void setLineColor(IFigure figure, Color color) {
        if (color == this.lineColor || color != null && color.equals((Object)this.lineColor)) {
            return;
        }
        this.lineColor = color;
        if (figure != null) {
            this.repaint(figure);
        }
    }

    public void setLineStyle(IFigure figure, int style) {
        if (style == this.lineStyle) {
            return;
        }
        this.lineStyle = style;
        if (figure != null) {
            this.repaint(figure);
        }
        this.update(figure);
    }

    public void setLineWidth(IFigure figure, int width) {
        if (width == this.lineWidth) {
            return;
        }
        this.lineWidth = width;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure);
    }

    @Override
    public void setSourceOrientation(IFigure figure, int orientation) {
        if (orientation == this.sourceOrientation) {
            return;
        }
        this.sourceOrientation = orientation;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure);
    }

    @Override
    public void setSourceExpansion(IFigure figure, int expansion) {
        if (expansion == this.sourceExpansion) {
            return;
        }
        this.sourceExpansion = expansion;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure);
    }

    @Override
    public void setTapered(IFigure figure, boolean tapered) {
        if (tapered == this.tapered) {
            return;
        }
        this.tapered = tapered;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure);
    }

    public void setCornerSize(IFigure figure, int cornerSize) {
        if (cornerSize == this.cornerSize) {
            return;
        }
        this.cornerSize = cornerSize;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
        this.update(figure);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    @Override
    public int getSourceExpansion() {
        return this.sourceExpansion;
    }

    @Override
    public int getSourceOrientation() {
        return this.sourceOrientation;
    }

    @Override
    public boolean isTapered() {
        return this.tapered;
    }
}

