/* mgiID.c was originally generated by the autoSql program, which also 
 * generated mgiID.h and mgiID.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "mgiID.h"


void MGIidStaticLoad(char **row, struct MGIid *ret)
/* Load a row from MGIid table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

strcpy(ret->LLid, row[0]);
strcpy(ret->MGIid, row[1]);
strcpy(ret->symbol, row[2]);
}

struct MGIid *MGIidLoad(char **row)
/* Load a MGIid from row fetched with select * from MGIid
 * from database.  Dispose of this with MGIidFree(). */
{
struct MGIid *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
strcpy(ret->LLid, row[0]);
strcpy(ret->MGIid, row[1]);
strcpy(ret->symbol, row[2]);
return ret;
}

struct MGIid *MGIidLoadAll(char *fileName) 
/* Load all MGIid from a tab-separated file.
 * Dispose of this with MGIidFreeList(). */
{
struct MGIid *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = MGIidLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct MGIid *MGIidLoadWhere(struct sqlConnection *conn, char *table, char *where)
/* Load all MGIid from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with MGIidFreeList(). */
{
struct MGIid *list = NULL, *el;
struct dyString *query = dyStringNew(256);
struct sqlResult *sr;
char **row;

dyStringPrintf(query, "select * from %s", table);
if (where != NULL)
    dyStringPrintf(query, " where %s", where);
sr = sqlGetResult(conn, query->string);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = MGIidLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
dyStringFree(&query);
return list;
}

struct MGIid *MGIidCommaIn(char **pS, struct MGIid *ret)
/* Create a MGIid out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new MGIid */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->LLid, sizeof(ret->LLid));
sqlFixedStringComma(&s, ret->MGIid, sizeof(ret->MGIid));
sqlFixedStringComma(&s, ret->symbol, sizeof(ret->symbol));
*pS = s;
return ret;
}

void MGIidFree(struct MGIid **pEl)
/* Free a single dynamically allocated MGIid such as created
 * with MGIidLoad(). */
{
struct MGIid *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void MGIidFreeList(struct MGIid **pList)
/* Free a list of dynamically allocated MGIid's */
{
struct MGIid *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    MGIidFree(&el);
    }
*pList = NULL;
}

void MGIidOutput(struct MGIid *el, FILE *f, char sep, char lastSep) 
/* Print out MGIid.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->LLid);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->MGIid);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->symbol);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

