table ucscRetroInfo
"Retrogenes based on cDNA alignments that are expressed or processed pseudogenes."
    (
    string chrom;	"Reference sequence chromosome or scaffold col1"
    uint chromStart;	"pseudogene alignment start position col2"
    uint chromEnd;      "pseudogene alignment end position col3"
    string name;        "Name of pseudogene col4"
    uint score;         "score of pseudogene with gene col5"
    char[2] strand;     "+ or -"
    uint thickStart;    "Start of where display should be thick (start codon)"
    uint thickEnd;      "End of where display should be thick (stop codon)"
    uint reserved;      "Always zero for now"
    int blockCount;     "Number of blocks"
    int[blockCount] blockSizes; "Comma separated list of block sizes"
    int[blockCount] chromStarts; "Start positions relative to chromStart"
    int retroExonCount;	"number of exons in retroGene col13"
    int axtScore;       "blastz score, parent mrna aligned to pseudogene col14"
    string type;	"type of evidence col15"
    string gChrom;	"Chromosome name col16"
    int gStart;	        "gene alignment start position col17"
    int gEnd;           "gene alignment end position col18"
    char[2] gStrand;    "strand of gene col19"
    uint parentSpliceCount;     "# of splice sites in parent gene col20"
    uint geneOverlap;   "bases overlapping col21"
    uint polyA;         "count of As in polyA col22"
    int polyAstart;     "start of polyA, relative to end of pseudogene col23"
    int exonCover;      "number of exons in Gene covered col24"
    uint intronCount;   "number of introns in pseudogene col25"
    uint bestAliCount;  "number of good mrnas aligning col26"
    uint matches;       "matches + repMatches col27"
    uint qSize;         "aligning bases in pseudogene col28"
    uint qEnd;          "end of cdna alignment col29"
    uint tReps;         "repeats in gene col30"
    uint coverage;      "% of bases that align to gene col31"
    int label;          "1=pseudogene,-1 not pseudogene -2 expressed retroGene col32"
    uint milliBad;      "milliBad score, pseudogene aligned to genome col33"
    uint oldScore;      "another heuristic col34"
    int oldIntronCount; "old simple intron count col35"
    int processedIntrons; "count of introns removed via retrotransposition col36"
    int conservedSpliceSites; "conserved splice site count col37"
    int maxOverlap ;    "largest overlap with another mrna col38"
    string refSeq;	"Name of closest regSeq to gene col39"
    int rStart;	        "refSeq alignment start position col40"
    int rEnd;           "refSeq alignment end position col41"
    string mgc;	        "Name of closest mgc to gene col42"
    int mStart;	        "mgc alignment start position col43"
    int mEnd;           "mgc alignment end position col44"
    string kgName;	"Name of closest knownGene to gene col45"
    int kStart;	        "kg alignment start position col46"
    int kEnd;           "kg alignment end position col47"
    string overName;	"name of overlapping mrna col48"
    int overStart;	"overlapping mrna start position col49"
    int overExonCover;  "count of overlapping mrna exons col50"
    char[2] overStrand;  "strand of overlapping mrna col51"
    float posConf;      "pvalue for positive col52"
    uint polyAlen;      "length of polyA col53"
    )
