/* isochores.h was originally generated by the autoSql program, which also 
 * generated isochores.c and isochores.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef ISOCHORES_H
#define ISOCHORES_H

struct isochores
/* Describes the positions of isochores with a chromosome */
    {
    struct isochores *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome number */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of isochore - AT-rich or GC-rich */
    unsigned gcPpt;	/* GC content in parts per thousand */
    };

void isochoresStaticLoad(char **row, struct isochores *ret);
/* Load a row from isochores table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct isochores *isochoresLoad(char **row);
/* Load a isochores from row fetched with select * from isochores
 * from database.  Dispose of this with isochoresFree(). */

struct isochores *isochoresCommaIn(char **pS, struct isochores *ret);
/* Create a isochores out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new isochores */

void isochoresFree(struct isochores **pEl);
/* Free a single dynamically allocated isochores such as created
 * with isochoresLoad(). */

void isochoresFreeList(struct isochores **pList);
/* Free a list of dynamically allocated isochores's */

void isochoresOutput(struct isochores *el, FILE *f, char sep, char lastSep);
/* Print out isochores.  Separate fields with sep. Follow last field with lastSep. */

#define isochoresTabOut(el,f) isochoresOutput(el,f,'\t','\n');
/* Print out isochores as a line in a tab-separated file. */

#define isochoresCommaOut(el,f) isochoresOutput(el,f,',',',');
/* Print out isochores as a comma separated list including final comma. */

#endif /* ISOCHORES_H */

