/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit.swingui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.antlr.gunit.swingui.IController;
import org.antlr.gunit.swingui.RunnerController;
import org.antlr.gunit.swingui.Translator;
import org.antlr.gunit.swingui.WorkSpaceView;
import org.antlr.gunit.swingui.images.ImageFactory;
import org.antlr.gunit.swingui.model.Rule;
import org.antlr.gunit.swingui.model.TestSuite;
import org.antlr.gunit.swingui.runner.gUnitAdapter;

public class WorkSpaceController
implements IController {
    private TestSuite currentTestSuite;
    private gUnitAdapter adapter = new gUnitAdapter();
    private String testSuiteFileName = null;
    private final WorkSpaceView view = new WorkSpaceView();
    private final RunnerController runner = new RunnerController();

    public WorkSpaceController() {
        this.view.resultPane = (JPanel)this.runner.getView();
        this.view.initComponents();
        this.initEventHandlers();
        this.initToolbar();
    }

    public void show() {
        this.view.setTitle("gUnitEditor");
        this.view.setVisible(true);
        this.view.pack();
    }

    public Component getEmbeddedView() {
        return this.view.paneEditor.getView();
    }

    private void initEventHandlers() {
        this.view.tabEditors.addChangeListener(new TabChangeListener());
        this.view.listRules.setListSelectionListener(new RuleListSelectionListener());
        this.view.paneEditor.onTestCaseNumberChange = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((WorkSpaceController)WorkSpaceController.this).view.listRules.getView().updateUI();
            }
        };
    }

    private void OnCreateTest() {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Create test suite from grammar");
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this.view) != 0) {
            return;
        }
        this.view.paneStatus.setProgressIndetermined(true);
        File grammarFile = jfc.getSelectedFile();
        this.currentTestSuite = new TestSuite(grammarFile, Translator.loadRulesFromGrammar(grammarFile));
        this.view.listRules.initialize(this.currentTestSuite);
        this.view.tabEditors.setSelectedIndex(0);
        this.view.paneStatus.setText("Grammar: " + this.currentTestSuite.getGrammarName());
        this.view.paneStatus.setProgressIndetermined(false);
        this.testSuiteFileName = null;
    }

    private void OnSaveTest() {
        this.view.paneStatus.setProgressIndetermined(true);
        try {
            File file;
            if (this.testSuiteFileName == null || this.testSuiteFileName.equals("")) {
                JFileChooser jfc = new JFileChooser();
                jfc.setDialogTitle("Save test suite");
                jfc.setDialogType(1);
                if (jfc.showSaveDialog(this.view) != 0) {
                    return;
                }
                file = jfc.getSelectedFile();
                this.testSuiteFileName = file.getCanonicalPath();
            } else {
                file = new File(this.testSuiteFileName);
            }
            FileWriter fw = new FileWriter(file);
            fw.write(Translator.toScript(this.currentTestSuite));
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.view.paneStatus.setProgressIndetermined(false);
    }

    private void OnSaveAsTest() {
    }

    private void OnOpenTest() {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Open existing gUnit test suite");
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this.view) != 0) {
            return;
        }
        File testSuiteFile = jfc.getSelectedFile();
        try {
            this.testSuiteFileName = testSuiteFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.view.paneStatus.setProgressIndetermined(true);
        this.currentTestSuite = Translator.toTestSuite(testSuiteFile, new ArrayList());
        this.view.listRules.initialize(this.currentTestSuite);
        this.view.paneStatus.setText(this.currentTestSuite.getGrammarName());
        this.view.tabEditors.setSelectedIndex(0);
        this.view.paneStatus.setProgressIndetermined(false);
    }

    private void OnSelectRule(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("Null");
        }
        this.view.paneEditor.OnLoadRule(rule);
        this.view.paneStatus.setRule(rule.getName());
        this.runner.OnShowRuleResult(rule);
    }

    private void OnSelectTextPane() {
        Thread worker = new Thread(){

            public void run() {
                ((WorkSpaceController)WorkSpaceController.this).view.paneStatus.setProgressIndetermined(true);
                ((WorkSpaceController)WorkSpaceController.this).view.txtEditor.setText(Translator.toScript(WorkSpaceController.this.currentTestSuite));
                ((WorkSpaceController)WorkSpaceController.this).view.paneStatus.setProgressIndetermined(false);
            }
        };
        worker.start();
    }

    private void OnRunTest() {
        if (this.currentTestSuite == null) {
            return;
        }
        this.adapter.run(this.testSuiteFileName, this.currentTestSuite);
        this.view.tabEditors.addTab("Test Result", ImageFactory.FILE16, this.runner.getView());
        this.runner.OnShowSuiteResult(this.currentTestSuite);
    }

    private void initToolbar() {
        this.view.toolbar.add(new JButton(new CreateAction()));
        this.view.toolbar.add(new JButton(new OpenAction()));
        this.view.toolbar.add(new JButton(new SaveAction()));
        this.view.toolbar.add(new JButton(new RunAction()));
    }

    public Object getModel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Component getView() {
        return this.view;
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            super("Run", ImageFactory.NEXT);
            this.putValue("ShortDescription", "Run the current test suite");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 2));
        }

        public void actionPerformed(ActionEvent e) {
            WorkSpaceController.this.OnRunTest();
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super("Open", ImageFactory.OPEN);
            this.putValue("ShortDescription", "Open an existing test suite");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        }

        public void actionPerformed(ActionEvent e) {
            WorkSpaceController.this.OnOpenTest();
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super("Save as", ImageFactory.SAVEAS);
            this.putValue("ShortDescription", "Save a copy");
        }

        public void actionPerformed(ActionEvent e) {
            WorkSpaceController.this.OnSaveAsTest();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save", ImageFactory.SAVE);
            this.putValue("ShortDescription", "Save the test suite");
        }

        public void actionPerformed(ActionEvent e) {
            WorkSpaceController.this.OnSaveTest();
        }
    }

    private class CreateAction
    extends AbstractAction {
        public CreateAction() {
            super("Create", ImageFactory.ADDFILE);
            this.putValue("ShortDescription", "Create a test suite from an ANTLR grammar");
        }

        public void actionPerformed(ActionEvent e) {
            WorkSpaceController.this.OnCreateTest();
        }
    }

    public class TabChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent evt) {
            if (((WorkSpaceController)WorkSpaceController.this).view.tabEditors.getSelectedIndex() == 1) {
                WorkSpaceController.this.OnSelectTextPane();
            }
        }
    }

    private class RuleListSelectionListener
    implements ListSelectionListener {
        private RuleListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            JList list = (JList)event.getSource();
            Rule rule = (Rule)list.getSelectedValue();
            if (rule != null) {
                WorkSpaceController.this.OnSelectRule(rule);
            }
        }
    }
}

