/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.config.ConfigurationSource;
import com.google.jstestdriver.coverage.Coverage;
import com.google.jstestdriver.coverage.CoverageActionDecorator;
import com.google.jstestdriver.coverage.CoverageInstrumentingProcessor;
import com.google.jstestdriver.coverage.CoverageJsAdder;
import com.google.jstestdriver.coverage.CoverageNameMapper;
import com.google.jstestdriver.coverage.CoverageResponseStreamFactory;
import com.google.jstestdriver.coverage.CoverageThreadedActionProvider;
import com.google.jstestdriver.coverage.CoverageWriter;
import com.google.jstestdriver.coverage.LcovWriter;
import com.google.jstestdriver.coverage.SummaryCoverageWriter;
import com.google.jstestdriver.guice.BrowserActionProvider;
import com.google.jstestdriver.hooks.ActionListProcessor;
import com.google.jstestdriver.hooks.FileLoadPostProcessor;
import com.google.jstestdriver.hooks.ResourcePreProcessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageModule
extends AbstractModule {
    private final List<String> excludes;

    public CoverageModule(List<String> excludes) {
        this.excludes = excludes;
    }

    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), FileLoadPostProcessor.class).addBinding().to(CoverageInstrumentingProcessor.class);
        Multibinder.newSetBinder((Binder)this.binder(), ResourcePreProcessor.class).addBinding().to(CoverageJsAdder.class);
        Multibinder.newSetBinder((Binder)this.binder(), ResponseStreamFactory.class).addBinding().to(CoverageResponseStreamFactory.class);
        Multibinder.newSetBinder((Binder)this.binder(), ActionListProcessor.class).addBinding().to(CoverageActionDecorator.class);
        this.bind((TypeLiteral)new TypeLiteral<Set<String>>(){}).annotatedWith((Annotation)new CoverageImpl("coverageExcludes")).toInstance((Object)Sets.newHashSet(this.excludes));
        this.bind(BrowserActionProvider.class).to(CoverageThreadedActionProvider.class);
    }

    @Provides
    @Inject
    public CoverageWriter createCoverageWriter(@Named(value="testOutput") String testOut, @Named(value="config") ConfigurationSource source, @Named(value="outputStream") PrintStream out, CoverageNameMapper mapper) {
        if (testOut.length() > 0) {
            try {
                File coverageFile;
                File testOutDir = new File(testOut);
                if (!testOutDir.exists()) {
                    testOutDir.mkdirs();
                }
                if ((coverageFile = new File(testOutDir, String.format("%s-coverage.dat", source.getName()))).exists()) {
                    coverageFile.delete();
                }
                coverageFile.createNewFile();
                return new LcovWriter(new FileWriter(coverageFile), mapper);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new SummaryCoverageWriter(out, mapper);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CoverageImpl
    implements Coverage {
        private final String value;

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Coverage)) {
                return false;
            }
            Coverage other = (Coverage)obj;
            return !(this.value == null ? other.value() != null : !this.value.equals(other.value()));
        }

        public CoverageImpl(String name) {
            this.value = name;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Coverage.class;
        }
    }
}

