/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.DryRunInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.RunData;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryRunAction
implements BrowserAction {
    private final List<String> expressions;
    private final ResponseStreamFactory responseStreamFactory;

    public DryRunAction(ResponseStreamFactory responseStreamFactory, List<String> expressions) {
        this.responseStreamFactory = responseStreamFactory;
        this.expressions = expressions;
    }

    @Override
    public ResponseStream run(String id, JsTestDriverClient client, RunData runData, JstdTestCase testCase) {
        ResponseStream responseStream = this.responseStreamFactory.getDryRunActionResponseStream();
        if (this.expressions.size() == 1 && this.expressions.get(0).equals("all")) {
            client.dryRun(id, responseStream, testCase);
        } else {
            client.dryRunFor(id, responseStream, this.expressions, testCase);
        }
        return responseStream;
    }

    public static class DryRunActionResponseStream
    implements ResponseStream {
        private final Gson gson = new Gson();
        private final PrintStream out;

        public DryRunActionResponseStream(PrintStream out) {
            this.out = out;
        }

        public void finish() {
        }

        public void stream(Response response) {
            BrowserInfo browser = response.getBrowser();
            DryRunInfo dryRunInfo = this.gson.fromJson(response.getResponse(), DryRunInfo.class);
            this.out.println(String.format("%s %s: %s tests %s", browser.getName(), browser.getVersion(), dryRunInfo.getNumTests(), dryRunInfo.getTestNames()));
        }
    }
}

