/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.io.File;
import java.util.HashMap;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.converter.BuildLayoutConverter;
import org.gradle.launcher.cli.converter.BuildOptionBackedConverter;
import org.gradle.launcher.cli.converter.InitialPropertiesConverter;
import org.gradle.launcher.cli.converter.LayoutToPropertiesConverter;
import org.gradle.launcher.cli.converter.StartParameterConverter;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.configuration.InitialProperties;
import org.gradle.launcher.daemon.configuration.DaemonBuildOptions;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.toolchain.ToolchainBuildOptions;
import org.jspecify.annotations.Nullable;

public class BuildEnvironmentConfigurationConverter {
    private final InitialPropertiesConverter initialPropertiesConverter;
    private final BuildLayoutConverter buildLayoutConverter;
    private final LayoutToPropertiesConverter layoutToPropertiesConverter;
    private final StartParameterConverter startParameterConverter;
    private final BuildOptionBackedConverter<DaemonParameters> daemonParametersConverter;
    private final BuildOptionBackedConverter<ToolchainConfiguration> toolchainConfigurationBuildOptionBackedConverter;
    private final FileCollectionFactory fileCollectionFactory;

    BuildEnvironmentConfigurationConverter(InitialPropertiesConverter initialPropertiesConverter, BuildLayoutConverter buildLayoutConverter, LayoutToPropertiesConverter layoutToPropertiesConverter, StartParameterConverter startParameterConverter, BuildOptionBackedConverter<DaemonParameters> daemonParametersConverter, FileCollectionFactory fileCollectionFactory) {
        this.initialPropertiesConverter = initialPropertiesConverter;
        this.buildLayoutConverter = buildLayoutConverter;
        this.layoutToPropertiesConverter = layoutToPropertiesConverter;
        this.startParameterConverter = startParameterConverter;
        this.daemonParametersConverter = daemonParametersConverter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.toolchainConfigurationBuildOptionBackedConverter = new BuildOptionBackedConverter<ToolchainConfiguration>(new ToolchainBuildOptions());
    }

    public BuildEnvironmentConfigurationConverter(BuildLayoutFactory buildLayoutFactory, FileCollectionFactory fileCollectionFactory) {
        this(new InitialPropertiesConverter(), new BuildLayoutConverter(), new LayoutToPropertiesConverter(buildLayoutFactory), new StartParameterConverter(), new BuildOptionBackedConverter<DaemonParameters>(new DaemonBuildOptions()), fileCollectionFactory);
    }

    public Parameters convertParameters(ParsedCommandLine args, @Nullable File currentDir) throws CommandLineArgumentException {
        InitialProperties initialProperties = this.initialPropertiesConverter.convert(args);
        BuildLayoutResult buildLayout = this.buildLayoutConverter.convert(initialProperties, args, currentDir);
        AllProperties properties = this.layoutToPropertiesConverter.convert(initialProperties, buildLayout);
        StartParameterInternal startParameter = new StartParameterInternal();
        this.startParameterConverter.convert(args, buildLayout, properties, startParameter);
        DaemonParameters daemonParameters = new DaemonParameters(buildLayout.getGradleUserHomeDir(), this.fileCollectionFactory, properties.getRequestedSystemProperties());
        this.daemonParametersConverter.convert(args, properties.getProperties(), daemonParameters);
        HashMap<String, String> gradlePropertiesAsSeenByToolchains = new HashMap<String, String>();
        gradlePropertiesAsSeenByToolchains.putAll(properties.getProperties());
        gradlePropertiesAsSeenByToolchains.putAll(startParameter.getProjectPropertiesUntracked());
        this.toolchainConfigurationBuildOptionBackedConverter.convert(args, gradlePropertiesAsSeenByToolchains, daemonParameters.getToolchainConfiguration());
        daemonParameters.setRequestedJvmCriteriaFromMap(properties.getDaemonJvmProperties());
        return new Parameters(startParameter, daemonParameters, properties);
    }

    public void configure(CommandLineParser parser) {
        this.initialPropertiesConverter.configure(parser);
        this.buildLayoutConverter.configure(parser);
        this.startParameterConverter.configure(parser);
        this.daemonParametersConverter.configure(parser);
    }
}

