/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Function;
import java.util.function.Predicate;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class FilterMapStream<T, U>
extends EventStreamBase<U> {
    private final EventStream<T> source;
    private final Predicate<? super T> predicate;
    private final Function<? super T, ? extends U> f;

    public FilterMapStream(EventStream<T> source, Predicate<? super T> predicate, Function<? super T, ? extends U> f) {
        this.source = source;
        this.predicate = predicate;
        this.f = f;
    }

    @Override
    protected Subscription observeInputs() {
        return this.source.subscribe(value -> {
            if (this.predicate.test(value)) {
                this.emit(this.f.apply(value));
            }
        });
    }
}

