/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.pdf;

import java.util.Locale;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FileAnnotationType {
    TEXT("Text", false),
    HIGHLIGHT("Highlight", true),
    SQUIGGLY("Squiggly", true),
    UNDERLINE("Underline", true),
    STRIKEOUT("StrikeOut", true),
    POLYGON("Polygon", false),
    POPUP("Popup", false),
    LINE("Line", false),
    CIRCLE("Circle", false),
    FREETEXT("FreeText", false),
    INK("Ink", false),
    UNKNOWN("Unknown", false),
    NONE("None", false);

    private static final Logger LOGGER;
    private final String name;
    private final boolean linkedFileAnnotationType;

    private FileAnnotationType(String name, boolean linkedFileAnnotationType) {
        this.name = name;
        this.linkedFileAnnotationType = linkedFileAnnotationType;
    }

    public static FileAnnotationType parse(PDAnnotation annotation) {
        try {
            return FileAnnotationType.valueOf(annotation.getSubtype().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            LOGGER.info(String.format("FileAnnotationType %s is not supported and was converted into 'Unknown'!", annotation.getSubtype()));
            return UNKNOWN;
        }
    }

    public static boolean isMarkedFileAnnotationType(String annotationType) {
        try {
            return FileAnnotationType.valueOf((String)annotationType.toUpperCase((Locale)Locale.ROOT)).linkedFileAnnotationType;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isLinkedFileAnnotationType() {
        return this.linkedFileAnnotationType;
    }

    public String toString() {
        return this.name;
    }

    static {
        LOGGER = LoggerFactory.getLogger(FileAnnotationType.class);
    }
}

