/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.xmp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.xml.XmpSerializer;
import org.jabref.logic.xmp.DublinCoreExtractor;
import org.jabref.logic.xmp.EncryptedPdfsNotSupportedException;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilShared;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpUtilWriter {
    private static final String XMP_BEGIN_END_TAG = "?xpacket";
    private static final Logger LOGGER = LoggerFactory.getLogger(XmpUtilWriter.class);

    public static void writeXmp(String fileName, BibEntry entry, BibDatabase database, XmpPreferences xmpPreferences) throws IOException, TransformerException {
        XmpUtilWriter.writeXmp(Paths.get(fileName, new String[0]), entry, database, xmpPreferences);
    }

    public static void writeXmp(Path file, BibEntry entry, BibDatabase database, XmpPreferences xmpPreferences) throws IOException, TransformerException {
        ArrayList<BibEntry> bibEntryList = new ArrayList<BibEntry>();
        bibEntryList.add(entry);
        XmpUtilWriter.writeXmp(file, bibEntryList, database, xmpPreferences);
    }

    private static void writeToDCSchema(DublinCoreSchema dcSchema, BibEntry entry, BibDatabase database, XmpPreferences xmpPreferences) {
        BibEntry resolvedEntry = XmpUtilWriter.getDefaultOrDatabaseEntry(entry, database);
        XmpUtilWriter.writeToDCSchema(dcSchema, resolvedEntry, xmpPreferences);
    }

    private static void writeToDCSchema(DublinCoreSchema dcSchema, BibEntry entry, XmpPreferences xmpPreferences) {
        DublinCoreExtractor dcExtractor = new DublinCoreExtractor(dcSchema, xmpPreferences, entry);
        dcExtractor.fillDublinCoreSchema();
    }

    public static void writeDublinCore(PDDocument document, BibEntry entry, BibDatabase database, XmpPreferences xmpPreferences) throws IOException, TransformerException {
        ArrayList<BibEntry> entries = new ArrayList<BibEntry>();
        entries.add(entry);
        XmpUtilWriter.writeDublinCore(document, entries, database, xmpPreferences);
    }

    private static void writeDublinCore(PDDocument document, List<BibEntry> entries, BibDatabase database, XmpPreferences xmpPreferences) throws IOException, TransformerException {
        XMPMetadata meta;
        List<BibEntry> resolvedEntries = database == null ? entries : database.resolveForStrings(entries, false);
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDMetadata metaRaw = catalog.getMetadata();
        if (metaRaw == null) {
            meta = XMPMetadata.createXMPMetadata();
        } else {
            try {
                meta = XmpUtilShared.parseXmpMetadata(metaRaw.createInputStream());
            }
            catch (IOException e) {
                meta = XMPMetadata.createXMPMetadata();
            }
        }
        meta.removeSchema(meta.getDublinCoreSchema());
        for (BibEntry entry : resolvedEntries) {
            DublinCoreSchema dcSchema = meta.createAndAddDublinCoreSchema();
            XmpUtilWriter.writeToDCSchema(dcSchema, entry, null, xmpPreferences);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XmpSerializer serializer = new XmpSerializer();
        serializer.serialize(meta, os, true);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        PDMetadata metadataStream = new PDMetadata(document, is);
        catalog.setMetadata(metadataStream);
    }

    public static String generateXmpStringWithXmpDeclaration(List<BibEntry> entries, XmpPreferences xmpPreferences) {
        String string;
        XMPMetadata meta = XMPMetadata.createXMPMetadata();
        for (BibEntry entry : entries) {
            DublinCoreSchema dcSchema = meta.createAndAddDublinCoreSchema();
            XmpUtilWriter.writeToDCSchema(dcSchema, entry, xmpPreferences);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            XmpSerializer serializer = new XmpSerializer();
            serializer.serialize(meta, os, true);
            string = os.toString(StandardCharsets.UTF_8.name());
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    XmpUtilWriter.$closeResource(throwable, os);
                    throw throwable3;
                }
            }
            catch (TransformerException e) {
                LOGGER.warn("Tranformation into xmp not possible: " + e.getMessage(), e);
                return "";
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn("Unsupported encoding to UTF-8 of bib entries in xmp metadata.", e);
                return "";
            }
            catch (IOException e) {
                LOGGER.warn("IO Exception thrown by closing the output stream.", e);
                return "";
            }
        }
        XmpUtilWriter.$closeResource(throwable, os);
        return string;
    }

    public static String generateXmpStringWithoutXmpDeclaration(List<BibEntry> entries, XmpPreferences xmpPreferences) {
        String xmpContent = XmpUtilWriter.generateXmpStringWithXmpDeclaration(entries, xmpPreferences);
        Predicate<String> isBeginOrEndTag = s2 -> s2.contains(XMP_BEGIN_END_TAG);
        String updatedXmpContent = Arrays.stream(xmpContent.split(System.lineSeparator())).filter(isBeginOrEndTag.negate()).map(line -> line.toString()).collect(Collectors.joining(System.lineSeparator()));
        return updatedXmpContent;
    }

    private static void writeDocumentInformation(PDDocument document, BibEntry entry, BibDatabase database, XmpPreferences xmpPreferences) {
        PDDocumentInformation di = document.getDocumentInformation();
        BibEntry resolvedEntry = XmpUtilWriter.getDefaultOrDatabaseEntry(entry, database);
        boolean useXmpPrivacyFilter = xmpPreferences.isUseXMPPrivacyFilter();
        TreeSet<String> filters = new TreeSet<String>(xmpPreferences.getXmpPrivacyFilter());
        for (Map.Entry<String, String> field2 : resolvedEntry.getFieldMap().entrySet()) {
            String fieldName = field2.getKey();
            String fieldContent = field2.getValue();
            if (useXmpPrivacyFilter && filters.contains(fieldName)) {
                if ("author".equals(fieldName)) {
                    di.setAuthor(null);
                    continue;
                }
                if ("title".equals(fieldName)) {
                    di.setTitle(null);
                    continue;
                }
                if ("keywords".equals(fieldName)) {
                    di.setKeywords(null);
                    continue;
                }
                if ("abstract".equals(fieldName)) {
                    di.setSubject(null);
                    continue;
                }
                di.setCustomMetadataValue("bibtex/" + fieldName, null);
                continue;
            }
            if ("author".equals(fieldName)) {
                di.setAuthor(fieldContent);
                continue;
            }
            if ("title".equals(fieldName)) {
                di.setTitle(fieldContent);
                continue;
            }
            if ("keywords".equals(fieldName)) {
                di.setKeywords(fieldContent);
                continue;
            }
            if ("abstract".equals(fieldName)) {
                di.setSubject(fieldContent);
                continue;
            }
            di.setCustomMetadataValue("bibtex/" + fieldName, fieldContent);
        }
        di.setCustomMetadataValue("bibtex/entrytype", StringUtil.capitalizeFirst(resolvedEntry.getType()));
    }

    public static void writeXmp(Path path, List<BibEntry> bibtexEntries, BibDatabase database, XmpPreferences xmpPreferences) throws IOException, TransformerException {
        List<BibEntry> resolvedEntries = database == null ? bibtexEntries : database.resolveForStrings(bibtexEntries, false);
        try (PDDocument document = PDDocument.load(path.toFile());){
            if (document.isEncrypted()) {
                throw new EncryptedPdfsNotSupportedException();
            }
            if (resolvedEntries.size() > 0) {
                XmpUtilWriter.writeDocumentInformation(document, resolvedEntries.get(0), null, xmpPreferences);
                XmpUtilWriter.writeDublinCore(document, resolvedEntries, null, xmpPreferences);
            }
            try {
                document.save(path.toFile());
            }
            catch (IOException e) {
                LOGGER.debug("Could not write XMP metadata", e);
                throw new TransformerException("Could not write XMP metadata: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static BibEntry getDefaultOrDatabaseEntry(BibEntry defaultEntry, BibDatabase database) {
        if (database == null) {
            return defaultEntry;
        }
        return database.resolveForStrings(defaultEntry, false);
    }
}

